/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityManagerInternal;
import android.app.PendingIntent;
import android.companion.AssociationInfo;
import android.companion.AssociationRequest;
import android.companion.CompanionException;
import android.companion.DeviceNotAssociatedException;
import android.companion.IAssociationRequestCallback;
import android.companion.ICompanionDeviceManager;
import android.companion.IOnAssociationsChangedListener;
import android.companion.IOnMessageReceivedListener;
import android.companion.IOnTransportsChangedListener;
import android.companion.ISystemDataTransferCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.net.MacAddress;
import android.os.Binder;
import android.os.Handler;
import android.os.OutcomeReceiver;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.CollectionUtils;
import com.android.server.LocalServices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import libcore.io.IoUtils;

@SuppressLint(value={"LongLogTag"})
public class CompanionDeviceManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "CDM_CompanionDeviceManager";
    public static final int RESULT_OK = -1;
    public static final int RESULT_CANCELED = 0;
    public static final int RESULT_USER_REJECTED = 1;
    public static final int RESULT_DISCOVERY_TIMEOUT = 2;
    public static final int RESULT_INTERNAL_ERROR = 3;
    public static final String REASON_USER_REJECTED = "user_rejected";
    public static final String REASON_DISCOVERY_TIMEOUT = "discovery_timeout";
    public static final String REASON_INTERNAL_ERROR = "internal_error";
    public static final String REASON_CANCELED = "canceled";
    public static final int FLAG_CALL_METADATA = 1;
    @Deprecated
    public static final String EXTRA_DEVICE = "android.companion.extra.DEVICE";
    public static final String EXTRA_ASSOCIATION = "android.companion.extra.ASSOCIATION";
    public static final String COMPANION_DEVICE_DISCOVERY_PACKAGE_NAME = "com.android.companiondevicemanager";
    private final ICompanionDeviceManager mService;
    private Context mContext;
    @GuardedBy(value={"mListeners"})
    private final ArrayList<OnAssociationsChangedListenerProxy> mListeners = new ArrayList();
    @GuardedBy(value={"mTransports"})
    private final SparseArray<Transport> mTransports = new SparseArray();

    public CompanionDeviceManager(ICompanionDeviceManager service, Context context) {
        this.mService = service;
        this.mContext = context;
    }

    @RequiresPermission(anyOf={"android.permission.REQUEST_COMPANION_PROFILE_WATCH", "android.permission.REQUEST_COMPANION_PROFILE_COMPUTER", "android.permission.REQUEST_COMPANION_PROFILE_APP_STREAMING", "android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION"}, conditional=true)
    public void associate(AssociationRequest request, Callback callback, Handler handler) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(request, "Request cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        handler = Handler.mainIfNull(handler);
        try {
            this.mService.associate(request, new AssociationRequestCallbackProxy(handler, callback), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.REQUEST_COMPANION_PROFILE_WATCH", "android.permission.REQUEST_COMPANION_PROFILE_COMPUTER", "android.permission.REQUEST_COMPANION_PROFILE_APP_STREAMING", "android.permission.REQUEST_COMPANION_PROFILE_AUTOMOTIVE_PROJECTION"}, conditional=true)
    public void associate(AssociationRequest request, Executor executor, Callback callback) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(request, "Request cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        try {
            this.mService.associate(request, new AssociationRequestCallbackProxy(executor, callback), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public IntentSender buildAssociationCancellationIntent() {
        if (!this.checkFeaturePresent()) {
            return null;
        }
        try {
            PendingIntent pendingIntent = this.mService.buildAssociationCancellationIntent(this.mContext.getOpPackageName(), this.mContext.getUserId());
            return pendingIntent.getIntentSender();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void enableSystemDataSyncForTypes(int associationId, int flags) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.enableSystemDataSync(associationId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disableSystemDataSyncForTypes(int associationId, int flags) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.disableSystemDataSync(associationId, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public List<String> getAssociations() {
        return CollectionUtils.mapNotNull(this.getMyAssociations(), a -> a.isSelfManaged() ? null : a.getDeviceMacAddressAsString());
    }

    public List<AssociationInfo> getMyAssociations() {
        if (!this.checkFeaturePresent()) {
            return Collections.emptyList();
        }
        try {
            return this.mService.getAssociations(this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void disassociate(String deviceMacAddress) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.legacyDisassociate(deviceMacAddress, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void disassociate(int associationId) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.disassociate(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            IntentSender intentSender = this.mService.requestNotificationAccess(component, this.mContext.getUserId()).getIntentSender();
            this.mContext.startIntentSender(intentSender, null, 0, 0, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IntentSender.SendIntentException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public boolean hasNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        try {
            return this.mService.hasNotificationAccess(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean isDeviceAssociatedForWifiConnection(String packageName, MacAddress macAddress, UserHandle user) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(macAddress, "mac address cannot be null");
        Objects.requireNonNull(user, "user cannot be null");
        try {
            return this.mService.isDeviceAssociatedForWifiConnection(packageName, macAddress.toString(), user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public List<AssociationInfo> getAllAssociations() {
        if (!this.checkFeaturePresent()) {
            return Collections.emptyList();
        }
        try {
            return this.mService.getAllAssociationsForUser(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void addOnAssociationsChangedListener(Executor executor, OnAssociationsChangedListener listener) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        ArrayList<OnAssociationsChangedListenerProxy> arrayList = this.mListeners;
        synchronized (arrayList) {
            OnAssociationsChangedListenerProxy proxy = new OnAssociationsChangedListenerProxy(executor, listener);
            try {
                this.mService.addOnAssociationsChangedListener(proxy, this.mContext.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mListeners.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void removeOnAssociationsChangedListener(OnAssociationsChangedListener listener) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        ArrayList<OnAssociationsChangedListenerProxy> arrayList = this.mListeners;
        synchronized (arrayList) {
            Iterator<OnAssociationsChangedListenerProxy> iterator = this.mListeners.iterator();
            while (iterator.hasNext()) {
                OnAssociationsChangedListenerProxy proxy = iterator.next();
                if (proxy.mListener != listener) continue;
                try {
                    this.mService.removeOnAssociationsChangedListener(proxy, this.mContext.getUserId());
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                iterator.remove();
            }
        }
    }

    public void addOnTransportsChangedListener(Executor executor, OnTransportsChangedListener listener) {
        OnTransportsChangedListenerProxy proxy = new OnTransportsChangedListenerProxy(executor, listener);
        try {
            this.mService.addOnTransportsChangedListener(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeOnTransportsChangedListener(OnTransportsChangedListener listener) {
        OnTransportsChangedListenerProxy proxy = new OnTransportsChangedListenerProxy(null, listener);
        try {
            this.mService.removeOnTransportsChangedListener(proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void sendMessage(int messageType, byte[] data, int[] associationIds) {
        try {
            this.mService.sendMessage(messageType, data, associationIds);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addOnMessageReceivedListener(Executor executor, int messageType, OnMessageReceivedListener listener) {
        OnMessageReceivedListenerProxy proxy = new OnMessageReceivedListenerProxy(executor, listener);
        try {
            this.mService.addOnMessageReceivedListener(messageType, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeOnMessageReceivedListener(int messageType, OnMessageReceivedListener listener) {
        OnMessageReceivedListenerProxy proxy = new OnMessageReceivedListenerProxy(null, listener);
        try {
            this.mService.removeOnMessageReceivedListener(messageType, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, UserHandle user) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(deviceMacAddress, "device mac address cannot be null");
        Objects.requireNonNull(user, "user handle cannot be null");
        try {
            return this.mService.canPairWithoutPrompt(packageName, deviceMacAddress, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void startObservingDevicePresence(String deviceAddress) throws DeviceNotAssociatedException {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(deviceAddress, "address cannot be null");
        try {
            this.mService.registerDevicePresenceListenerService(deviceAddress, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        ActivityManagerInternal managerInternal = LocalServices.getService(ActivityManagerInternal.class);
        if (managerInternal != null) {
            managerInternal.logFgsApiBegin(9, callingUid, callingPid);
        }
    }

    @RequiresPermission(value="android.permission.REQUEST_OBSERVE_COMPANION_DEVICE_PRESENCE")
    public void stopObservingDevicePresence(String deviceAddress) throws DeviceNotAssociatedException {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(deviceAddress, "address cannot be null");
        try {
            this.mService.unregisterDevicePresenceListenerService(deviceAddress, this.mContext.getPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
        }
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        ActivityManagerInternal managerInternal = LocalServices.getService(ActivityManagerInternal.class);
        if (managerInternal != null) {
            managerInternal.logFgsApiEnd(9, callingUid, callingPid);
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void dispatchMessage(int messageId, int associationId, byte[] message) throws DeviceNotAssociatedException {
        Log.w(LOG_TAG, "dispatchMessage replaced by attachSystemDataTransport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void attachSystemDataTransport(int associationId, InputStream in, OutputStream out) throws DeviceNotAssociatedException {
        SparseArray<Transport> sparseArray = this.mTransports;
        synchronized (sparseArray) {
            if (this.mTransports.contains(associationId)) {
                this.detachSystemDataTransport(associationId);
            }
            try {
                Transport transport = new Transport(associationId, in, out);
                this.mTransports.put(associationId, transport);
                transport.start();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to attach transport", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.DELIVER_COMPANION_MESSAGES")
    public void detachSystemDataTransport(int associationId) throws DeviceNotAssociatedException {
        SparseArray<Transport> sparseArray = this.mTransports;
        synchronized (sparseArray) {
            Transport transport = this.mTransports.get(associationId);
            if (transport != null) {
                this.mTransports.delete(associationId);
                transport.stop();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ASSOCIATE_COMPANION_DEVICES")
    public void associate(String packageName, MacAddress macAddress, byte[] certificate) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Objects.requireNonNull(packageName, "package name cannot be null");
        Objects.requireNonNull(macAddress, "mac address cannot be null");
        UserHandle user = Process.myUserHandle();
        try {
            this.mService.createAssociation(packageName, macAddress.toString(), user.getIdentifier(), certificate);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
    public void notifyDeviceAppeared(int associationId) {
        try {
            this.mService.notifyDeviceAppeared(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.REQUEST_COMPANION_SELF_MANAGED")
    public void notifyDeviceDisappeared(int associationId) {
        try {
            this.mService.notifyDeviceDisappeared(associationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public IntentSender buildPermissionTransferUserConsentIntent(int associationId) throws DeviceNotAssociatedException {
        try {
            PendingIntent pendingIntent = this.mService.buildPermissionTransferUserConsentIntent(this.mContext.getOpPackageName(), this.mContext.getUserId(), associationId);
            if (pendingIntent == null) {
                return null;
            }
            return pendingIntent.getIntentSender();
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void startSystemDataTransfer(int associationId) throws DeviceNotAssociatedException {
        try {
            this.mService.startSystemDataTransfer(this.mContext.getOpPackageName(), this.mContext.getUserId(), associationId, null);
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    public void startSystemDataTransfer(int associationId, Executor executor, OutcomeReceiver<Void, CompanionException> result) throws DeviceNotAssociatedException {
        try {
            this.mService.startSystemDataTransfer(this.mContext.getOpPackageName(), this.mContext.getUserId(), associationId, new SystemDataTransferCallbackProxy(executor, result));
        }
        catch (RemoteException e) {
            ExceptionUtils.propagateIfInstanceOf(e.getCause(), DeviceNotAssociatedException.class);
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isCompanionApplicationBound() {
        try {
            return this.mService.isCompanionApplicationBound(this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_COMPANION_DEVICES")
    public void enableSecureTransport(boolean enabled) {
        try {
            this.mService.enableSecureTransport(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private boolean checkFeaturePresent() {
        boolean featurePresent;
        boolean bl = featurePresent = this.mService != null;
        if (!featurePresent) {
            // empty if block
        }
        return featurePresent;
    }

    private static class AssociationRequestCallbackProxy
    extends IAssociationRequestCallback.Stub {
        private final Handler mHandler;
        private final Callback mCallback;
        private final Executor mExecutor;

        private AssociationRequestCallbackProxy(Executor executor, Callback callback) {
            this.mExecutor = executor;
            this.mHandler = null;
            this.mCallback = callback;
        }

        private AssociationRequestCallbackProxy(Handler handler, Callback callback) {
            this.mHandler = handler;
            this.mExecutor = null;
            this.mCallback = callback;
        }

        @Override
        public void onAssociationPending(PendingIntent pi) {
            this.execute(this.mCallback::onAssociationPending, pi.getIntentSender());
        }

        @Override
        public void onAssociationCreated(AssociationInfo association) {
            this.execute(this.mCallback::onAssociationCreated, association);
        }

        @Override
        public void onFailure(CharSequence error) throws RemoteException {
            this.execute(this.mCallback::onFailure, error);
        }

        private <T> void execute(Consumer<T> callback, T arg) {
            if (this.mExecutor != null) {
                this.mExecutor.execute(() -> callback.accept(arg));
            } else {
                this.mHandler.post(() -> callback.accept(arg));
            }
        }
    }

    public static abstract class Callback {
        @Deprecated
        public void onDeviceFound(IntentSender intentSender) {
        }

        public void onAssociationPending(IntentSender intentSender) {
            this.onDeviceFound(intentSender);
        }

        public void onAssociationCreated(AssociationInfo associationInfo) {
        }

        public abstract void onFailure(CharSequence var1);
    }

    private static class OnAssociationsChangedListenerProxy
    extends IOnAssociationsChangedListener.Stub {
        private final Executor mExecutor;
        private final OnAssociationsChangedListener mListener;

        private OnAssociationsChangedListenerProxy(Executor executor, OnAssociationsChangedListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onAssociationsChanged(List<AssociationInfo> associations) {
            this.mExecutor.execute(() -> this.mListener.onAssociationsChanged(associations));
        }
    }

    @SystemApi
    public static interface OnAssociationsChangedListener {
        public void onAssociationsChanged(List<AssociationInfo> var1);
    }

    private static class OnTransportsChangedListenerProxy
    extends IOnTransportsChangedListener.Stub {
        private final Executor mExecutor;
        private final OnTransportsChangedListener mListener;

        private OnTransportsChangedListenerProxy(Executor executor, OnTransportsChangedListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onTransportsChanged(List<AssociationInfo> associations) {
            this.mExecutor.execute(() -> this.mListener.onTransportsChanged(associations));
        }
    }

    public static interface OnTransportsChangedListener {
        public void onTransportsChanged(List<AssociationInfo> var1);
    }

    private static class OnMessageReceivedListenerProxy
    extends IOnMessageReceivedListener.Stub {
        private final Executor mExecutor;
        private final OnMessageReceivedListener mListener;

        private OnMessageReceivedListenerProxy(Executor executor, OnMessageReceivedListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onMessageReceived(int associationId, byte[] data) {
            this.mExecutor.execute(() -> this.mListener.onMessageReceived(associationId, data));
        }
    }

    public static interface OnMessageReceivedListener {
        public void onMessageReceived(int var1, byte[] var2);
    }

    private class Transport {
        private final int mAssociationId;
        private final InputStream mRemoteIn;
        private final OutputStream mRemoteOut;
        private InputStream mLocalIn;
        private OutputStream mLocalOut;
        private volatile boolean mStopped;

        public Transport(int associationId, InputStream remoteIn, OutputStream remoteOut) {
            this.mAssociationId = associationId;
            this.mRemoteIn = remoteIn;
            this.mRemoteOut = remoteOut;
        }

        public void start() throws IOException {
            ParcelFileDescriptor[] pair = ParcelFileDescriptor.createSocketPair();
            ParcelFileDescriptor localFd = pair[0];
            ParcelFileDescriptor remoteFd = pair[1];
            this.mLocalIn = new ParcelFileDescriptor.AutoCloseInputStream(localFd);
            this.mLocalOut = new ParcelFileDescriptor.AutoCloseOutputStream(localFd);
            try {
                CompanionDeviceManager.this.mService.attachSystemDataTransport(CompanionDeviceManager.this.mContext.getPackageName(), CompanionDeviceManager.this.mContext.getUserId(), this.mAssociationId, remoteFd);
            }
            catch (RemoteException e) {
                throw new IOException("Failed to configure transport", e);
            }
            new Thread(() -> {
                block2: {
                    try {
                        this.copyWithFlushing(this.mLocalIn, this.mRemoteOut);
                    }
                    catch (IOException e) {
                        if (this.mStopped) break block2;
                        Log.w(CompanionDeviceManager.LOG_TAG, "Trouble during outgoing transport", e);
                        this.stop();
                    }
                }
            }).start();
            new Thread(() -> {
                block2: {
                    try {
                        this.copyWithFlushing(this.mRemoteIn, this.mLocalOut);
                    }
                    catch (IOException e) {
                        if (this.mStopped) break block2;
                        Log.w(CompanionDeviceManager.LOG_TAG, "Trouble during incoming transport", e);
                        this.stop();
                    }
                }
            }).start();
        }

        public void stop() {
            this.mStopped = true;
            try {
                CompanionDeviceManager.this.mService.detachSystemDataTransport(CompanionDeviceManager.this.mContext.getPackageName(), CompanionDeviceManager.this.mContext.getUserId(), this.mAssociationId);
            }
            catch (RemoteException e) {
                Log.w(CompanionDeviceManager.LOG_TAG, "Failed to detach transport", e);
            }
            IoUtils.closeQuietly(this.mRemoteIn);
            IoUtils.closeQuietly(this.mRemoteOut);
            IoUtils.closeQuietly(this.mLocalIn);
            IoUtils.closeQuietly(this.mLocalOut);
        }

        private void copyWithFlushing(InputStream in, OutputStream out) throws IOException {
            int c;
            byte[] buffer = new byte[8192];
            while ((c = in.read(buffer)) != -1) {
                out.write(buffer, 0, c);
                out.flush();
            }
        }
    }

    private static class SystemDataTransferCallbackProxy
    extends ISystemDataTransferCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<Void, CompanionException> mCallback;

        private SystemDataTransferCallbackProxy(Executor executor, OutcomeReceiver<Void, CompanionException> callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onResult() {
            this.mExecutor.execute(() -> this.mCallback.onResult(null));
        }

        @Override
        public void onError(String error) {
            this.mExecutor.execute(() -> this.mCallback.onError(new CompanionException(error)));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataSyncTypes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResultCode {
    }
}

