/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.app.PendingIntent;
import android.companion.AssociationInfo;
import android.companion.AssociationRequest;
import android.companion.IAssociationRequestCallback;
import android.companion.IOnAssociationsChangedListener;
import android.companion.IOnMessageReceivedListener;
import android.companion.IOnTransportsChangedListener;
import android.companion.ISystemDataTransferCallback;
import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ICompanionDeviceManager
extends IInterface {
    public void associate(AssociationRequest var1, IAssociationRequestCallback var2, String var3, int var4) throws RemoteException;

    public List<AssociationInfo> getAssociations(String var1, int var2) throws RemoteException;

    public List<AssociationInfo> getAllAssociationsForUser(int var1) throws RemoteException;

    @Deprecated
    public void legacyDisassociate(String var1, String var2, int var3) throws RemoteException;

    public void disassociate(int var1) throws RemoteException;

    @Deprecated
    public boolean hasNotificationAccess(ComponentName var1) throws RemoteException;

    public PendingIntent requestNotificationAccess(ComponentName var1, int var2) throws RemoteException;

    @Deprecated
    public boolean isDeviceAssociatedForWifiConnection(String var1, String var2, int var3) throws RemoteException;

    public void registerDevicePresenceListenerService(String var1, String var2, int var3) throws RemoteException;

    public void unregisterDevicePresenceListenerService(String var1, String var2, int var3) throws RemoteException;

    @Deprecated
    public boolean canPairWithoutPrompt(String var1, String var2, int var3) throws RemoteException;

    @Deprecated
    public void createAssociation(String var1, String var2, int var3, byte[] var4) throws RemoteException;

    public void addOnAssociationsChangedListener(IOnAssociationsChangedListener var1, int var2) throws RemoteException;

    public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener var1, int var2) throws RemoteException;

    public void addOnTransportsChangedListener(IOnTransportsChangedListener var1) throws RemoteException;

    public void removeOnTransportsChangedListener(IOnTransportsChangedListener var1) throws RemoteException;

    public void sendMessage(int var1, byte[] var2, int[] var3) throws RemoteException;

    public void addOnMessageReceivedListener(int var1, IOnMessageReceivedListener var2) throws RemoteException;

    public void removeOnMessageReceivedListener(int var1, IOnMessageReceivedListener var2) throws RemoteException;

    public void notifyDeviceAppeared(int var1) throws RemoteException;

    public void notifyDeviceDisappeared(int var1) throws RemoteException;

    public PendingIntent buildPermissionTransferUserConsentIntent(String var1, int var2, int var3) throws RemoteException;

    public void startSystemDataTransfer(String var1, int var2, int var3, ISystemDataTransferCallback var4) throws RemoteException;

    public void attachSystemDataTransport(String var1, int var2, int var3, ParcelFileDescriptor var4) throws RemoteException;

    public void detachSystemDataTransport(String var1, int var2, int var3) throws RemoteException;

    public boolean isCompanionApplicationBound(String var1, int var2) throws RemoteException;

    public PendingIntent buildAssociationCancellationIntent(String var1, int var2) throws RemoteException;

    public void enableSystemDataSync(int var1, int var2) throws RemoteException;

    public void disableSystemDataSync(int var1, int var2) throws RemoteException;

    public void enableSecureTransport(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICompanionDeviceManager {
        public static final String DESCRIPTOR = "android.companion.ICompanionDeviceManager";
        static final int TRANSACTION_associate = 1;
        static final int TRANSACTION_getAssociations = 2;
        static final int TRANSACTION_getAllAssociationsForUser = 3;
        static final int TRANSACTION_legacyDisassociate = 4;
        static final int TRANSACTION_disassociate = 5;
        static final int TRANSACTION_hasNotificationAccess = 6;
        static final int TRANSACTION_requestNotificationAccess = 7;
        static final int TRANSACTION_isDeviceAssociatedForWifiConnection = 8;
        static final int TRANSACTION_registerDevicePresenceListenerService = 9;
        static final int TRANSACTION_unregisterDevicePresenceListenerService = 10;
        static final int TRANSACTION_canPairWithoutPrompt = 11;
        static final int TRANSACTION_createAssociation = 12;
        static final int TRANSACTION_addOnAssociationsChangedListener = 13;
        static final int TRANSACTION_removeOnAssociationsChangedListener = 14;
        static final int TRANSACTION_addOnTransportsChangedListener = 15;
        static final int TRANSACTION_removeOnTransportsChangedListener = 16;
        static final int TRANSACTION_sendMessage = 17;
        static final int TRANSACTION_addOnMessageReceivedListener = 18;
        static final int TRANSACTION_removeOnMessageReceivedListener = 19;
        static final int TRANSACTION_notifyDeviceAppeared = 20;
        static final int TRANSACTION_notifyDeviceDisappeared = 21;
        static final int TRANSACTION_buildPermissionTransferUserConsentIntent = 22;
        static final int TRANSACTION_startSystemDataTransfer = 23;
        static final int TRANSACTION_attachSystemDataTransport = 24;
        static final int TRANSACTION_detachSystemDataTransport = 25;
        static final int TRANSACTION_isCompanionApplicationBound = 26;
        static final int TRANSACTION_buildAssociationCancellationIntent = 27;
        static final int TRANSACTION_enableSystemDataSync = 28;
        static final int TRANSACTION_disableSystemDataSync = 29;
        static final int TRANSACTION_enableSecureTransport = 30;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICompanionDeviceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICompanionDeviceManager) {
                return (ICompanionDeviceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "associate";
                }
                case 2: {
                    return "getAssociations";
                }
                case 3: {
                    return "getAllAssociationsForUser";
                }
                case 4: {
                    return "legacyDisassociate";
                }
                case 5: {
                    return "disassociate";
                }
                case 6: {
                    return "hasNotificationAccess";
                }
                case 7: {
                    return "requestNotificationAccess";
                }
                case 8: {
                    return "isDeviceAssociatedForWifiConnection";
                }
                case 9: {
                    return "registerDevicePresenceListenerService";
                }
                case 10: {
                    return "unregisterDevicePresenceListenerService";
                }
                case 11: {
                    return "canPairWithoutPrompt";
                }
                case 12: {
                    return "createAssociation";
                }
                case 13: {
                    return "addOnAssociationsChangedListener";
                }
                case 14: {
                    return "removeOnAssociationsChangedListener";
                }
                case 15: {
                    return "addOnTransportsChangedListener";
                }
                case 16: {
                    return "removeOnTransportsChangedListener";
                }
                case 17: {
                    return "sendMessage";
                }
                case 18: {
                    return "addOnMessageReceivedListener";
                }
                case 19: {
                    return "removeOnMessageReceivedListener";
                }
                case 20: {
                    return "notifyDeviceAppeared";
                }
                case 21: {
                    return "notifyDeviceDisappeared";
                }
                case 22: {
                    return "buildPermissionTransferUserConsentIntent";
                }
                case 23: {
                    return "startSystemDataTransfer";
                }
                case 24: {
                    return "attachSystemDataTransport";
                }
                case 25: {
                    return "detachSystemDataTransport";
                }
                case 26: {
                    return "isCompanionApplicationBound";
                }
                case 27: {
                    return "buildAssociationCancellationIntent";
                }
                case 28: {
                    return "enableSystemDataSync";
                }
                case 29: {
                    return "disableSystemDataSync";
                }
                case 30: {
                    return "enableSecureTransport";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    AssociationRequest _arg0 = data.readTypedObject(AssociationRequest.CREATOR);
                    IAssociationRequestCallback _arg1 = IAssociationRequestCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.associate(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AssociationInfo> _result = this.getAssociations(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AssociationInfo> _result = this.getAllAssociationsForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.legacyDisassociate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disassociate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.hasNotificationAccess(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    PendingIntent _result = this.requestNotificationAccess(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDeviceAssociatedForWifiConnection(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerDevicePresenceListenerService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterDevicePresenceListenerService(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.canPairWithoutPrompt(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.createAssociation(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    IOnAssociationsChangedListener _arg0 = IOnAssociationsChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addOnAssociationsChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    IOnAssociationsChangedListener _arg0 = IOnAssociationsChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeOnAssociationsChangedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    IOnTransportsChangedListener _arg0 = IOnTransportsChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnTransportsChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IOnTransportsChangedListener _arg0 = IOnTransportsChangedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnTransportsChangedListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    int[] _arg2 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.sendMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    IOnMessageReceivedListener _arg1 = IOnMessageReceivedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addOnMessageReceivedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    IOnMessageReceivedListener _arg1 = IOnMessageReceivedListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeOnMessageReceivedListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyDeviceAppeared(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyDeviceDisappeared(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    PendingIntent _result = this.buildPermissionTransferUserConsentIntent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ISystemDataTransferCallback _arg3 = ISystemDataTransferCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startSystemDataTransfer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ParcelFileDescriptor _arg3 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.attachSystemDataTransport(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.detachSystemDataTransport(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isCompanionApplicationBound(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    PendingIntent _result = this.buildAssociationCancellationIntent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enableSystemDataSync(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableSystemDataSync(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.enableSecureTransport(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 29;
        }

        private static class Proxy
        implements ICompanionDeviceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associate(AssociationRequest request, IAssociationRequestCallback callback, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AssociationInfo> getAssociations(String callingPackage, int userId) throws RemoteException {
                ArrayList<AssociationInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AssociationInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AssociationInfo> getAllAssociationsForUser(int userId) throws RemoteException {
                ArrayList<AssociationInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AssociationInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void legacyDisassociate(String deviceMacAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceMacAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disassociate(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNotificationAccess(ComponentName component) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent requestNotificationAccess(ComponentName component, int userId) throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(component, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDeviceAssociatedForWifiConnection(String packageName, String macAddress, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(macAddress);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDevicePresenceListenerService(String deviceAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDevicePresenceListenerService(String deviceAddress, String callingPackage, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(deviceAddress);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(deviceMacAddress);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createAssociation(String packageName, String macAddress, int userId, byte[] certificate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(macAddress);
                    _data.writeInt(userId);
                    _data.writeByteArray(certificate);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnAssociationsChangedListener(IOnAssociationsChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnTransportsChangedListener(IOnTransportsChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnTransportsChangedListener(IOnTransportsChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMessage(int messageType, byte[] data, int[] associationIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageType);
                    _data.writeByteArray(data);
                    _data.writeIntArray(associationIds);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnMessageReceivedListener(int messageType, IOnMessageReceivedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageType);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnMessageReceivedListener(int messageType, IOnMessageReceivedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(messageType);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDeviceAppeared(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDeviceDisappeared(int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent buildPermissionTransferUserConsentIntent(String callingPackage, int userId, int associationId) throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSystemDataTransfer(String packageName, int userId, int associationId, ISystemDataTransferCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachSystemDataTransport(String packageName, int userId, int associationId, ParcelFileDescriptor fd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    _data.writeTypedObject(fd, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void detachSystemDataTransport(String packageName, int userId, int associationId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(associationId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCompanionApplicationBound(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PendingIntent buildAssociationCancellationIntent(String callingPackage, int userId) throws RemoteException {
                PendingIntent _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PendingIntent.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableSystemDataSync(int associationId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableSystemDataSync(int associationId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(associationId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableSecureTransport(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICompanionDeviceManager {
        @Override
        public void associate(AssociationRequest request, IAssociationRequestCallback callback, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public List<AssociationInfo> getAssociations(String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<AssociationInfo> getAllAssociationsForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void legacyDisassociate(String deviceMacAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void disassociate(int associationId) throws RemoteException {
        }

        @Override
        public boolean hasNotificationAccess(ComponentName component) throws RemoteException {
            return false;
        }

        @Override
        public PendingIntent requestNotificationAccess(ComponentName component, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isDeviceAssociatedForWifiConnection(String packageName, String macAddress, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void registerDevicePresenceListenerService(String deviceAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public void unregisterDevicePresenceListenerService(String deviceAddress, String callingPackage, int userId) throws RemoteException {
        }

        @Override
        public boolean canPairWithoutPrompt(String packageName, String deviceMacAddress, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void createAssociation(String packageName, String macAddress, int userId, byte[] certificate) throws RemoteException {
        }

        @Override
        public void addOnAssociationsChangedListener(IOnAssociationsChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void removeOnAssociationsChangedListener(IOnAssociationsChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void addOnTransportsChangedListener(IOnTransportsChangedListener listener) throws RemoteException {
        }

        @Override
        public void removeOnTransportsChangedListener(IOnTransportsChangedListener listener) throws RemoteException {
        }

        @Override
        public void sendMessage(int messageType, byte[] data, int[] associationIds) throws RemoteException {
        }

        @Override
        public void addOnMessageReceivedListener(int messageType, IOnMessageReceivedListener listener) throws RemoteException {
        }

        @Override
        public void removeOnMessageReceivedListener(int messageType, IOnMessageReceivedListener listener) throws RemoteException {
        }

        @Override
        public void notifyDeviceAppeared(int associationId) throws RemoteException {
        }

        @Override
        public void notifyDeviceDisappeared(int associationId) throws RemoteException {
        }

        @Override
        public PendingIntent buildPermissionTransferUserConsentIntent(String callingPackage, int userId, int associationId) throws RemoteException {
            return null;
        }

        @Override
        public void startSystemDataTransfer(String packageName, int userId, int associationId, ISystemDataTransferCallback callback) throws RemoteException {
        }

        @Override
        public void attachSystemDataTransport(String packageName, int userId, int associationId, ParcelFileDescriptor fd) throws RemoteException {
        }

        @Override
        public void detachSystemDataTransport(String packageName, int userId, int associationId) throws RemoteException {
        }

        @Override
        public boolean isCompanionApplicationBound(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public PendingIntent buildAssociationCancellationIntent(String callingPackage, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void enableSystemDataSync(int associationId, int flags) throws RemoteException {
        }

        @Override
        public void disableSystemDataSync(int associationId, int flags) throws RemoteException {
        }

        @Override
        public void enableSecureTransport(boolean enabled) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

