/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.companion.virtual.IVirtualDeviceIntentInterceptor;
import android.companion.virtual.audio.IAudioConfigChangedCallback;
import android.companion.virtual.audio.IAudioRoutingCallback;
import android.companion.virtual.sensor.VirtualSensor;
import android.companion.virtual.sensor.VirtualSensorEvent;
import android.content.IntentFilter;
import android.graphics.PointF;
import android.hardware.input.VirtualDpadConfig;
import android.hardware.input.VirtualKeyEvent;
import android.hardware.input.VirtualKeyboardConfig;
import android.hardware.input.VirtualMouseButtonEvent;
import android.hardware.input.VirtualMouseConfig;
import android.hardware.input.VirtualMouseRelativeEvent;
import android.hardware.input.VirtualMouseScrollEvent;
import android.hardware.input.VirtualNavigationTouchpadConfig;
import android.hardware.input.VirtualTouchEvent;
import android.hardware.input.VirtualTouchscreenConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.os.ResultReceiver;
import java.util.ArrayList;
import java.util.List;

public interface IVirtualDevice
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.IVirtualDevice";

    public int getAssociationId() throws RemoteException;

    public int getDeviceId() throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void close() throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void onAudioSessionStarting(int var1, IAudioRoutingCallback var2, IAudioConfigChangedCallback var3) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void onAudioSessionEnded() throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void createVirtualDpad(VirtualDpadConfig var1, IBinder var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void createVirtualKeyboard(VirtualKeyboardConfig var1, IBinder var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void createVirtualMouse(VirtualMouseConfig var1, IBinder var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void createVirtualTouchscreen(VirtualTouchscreenConfig var1, IBinder var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void createVirtualNavigationTouchpad(VirtualNavigationTouchpadConfig var1, IBinder var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void unregisterInputDevice(IBinder var1) throws RemoteException;

    public int getInputDeviceId(IBinder var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public boolean sendDpadKeyEvent(IBinder var1, VirtualKeyEvent var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public boolean sendKeyEvent(IBinder var1, VirtualKeyEvent var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public boolean sendButtonEvent(IBinder var1, VirtualMouseButtonEvent var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public boolean sendRelativeEvent(IBinder var1, VirtualMouseRelativeEvent var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public boolean sendScrollEvent(IBinder var1, VirtualMouseScrollEvent var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public boolean sendTouchEvent(IBinder var1, VirtualTouchEvent var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public List<VirtualSensor> getVirtualSensorList() throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public boolean sendSensorEvent(IBinder var1, VirtualSensorEvent var2) throws RemoteException;

    public void launchPendingIntent(int var1, PendingIntent var2, ResultReceiver var3) throws RemoteException;

    public PointF getCursorPosition(IBinder var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void setShowPointerIcon(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void registerIntentInterceptor(IVirtualDeviceIntentInterceptor var1, IntentFilter var2) throws RemoteException;

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void unregisterIntentInterceptor(IVirtualDeviceIntentInterceptor var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualDevice {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_getAssociationId = 1;
        static final int TRANSACTION_getDeviceId = 2;
        static final int TRANSACTION_close = 3;
        static final int TRANSACTION_onAudioSessionStarting = 4;
        static final int TRANSACTION_onAudioSessionEnded = 5;
        static final int TRANSACTION_createVirtualDpad = 6;
        static final int TRANSACTION_createVirtualKeyboard = 7;
        static final int TRANSACTION_createVirtualMouse = 8;
        static final int TRANSACTION_createVirtualTouchscreen = 9;
        static final int TRANSACTION_createVirtualNavigationTouchpad = 10;
        static final int TRANSACTION_unregisterInputDevice = 11;
        static final int TRANSACTION_getInputDeviceId = 12;
        static final int TRANSACTION_sendDpadKeyEvent = 13;
        static final int TRANSACTION_sendKeyEvent = 14;
        static final int TRANSACTION_sendButtonEvent = 15;
        static final int TRANSACTION_sendRelativeEvent = 16;
        static final int TRANSACTION_sendScrollEvent = 17;
        static final int TRANSACTION_sendTouchEvent = 18;
        static final int TRANSACTION_getVirtualSensorList = 19;
        static final int TRANSACTION_sendSensorEvent = 20;
        static final int TRANSACTION_launchPendingIntent = 21;
        static final int TRANSACTION_getCursorPosition = 22;
        static final int TRANSACTION_setShowPointerIcon = 23;
        static final int TRANSACTION_registerIntentInterceptor = 24;
        static final int TRANSACTION_unregisterIntentInterceptor = 25;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IVirtualDevice.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IVirtualDevice asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualDevice.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualDevice) {
                return (IVirtualDevice)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAssociationId";
                }
                case 2: {
                    return "getDeviceId";
                }
                case 3: {
                    return "close";
                }
                case 4: {
                    return "onAudioSessionStarting";
                }
                case 5: {
                    return "onAudioSessionEnded";
                }
                case 6: {
                    return "createVirtualDpad";
                }
                case 7: {
                    return "createVirtualKeyboard";
                }
                case 8: {
                    return "createVirtualMouse";
                }
                case 9: {
                    return "createVirtualTouchscreen";
                }
                case 10: {
                    return "createVirtualNavigationTouchpad";
                }
                case 11: {
                    return "unregisterInputDevice";
                }
                case 12: {
                    return "getInputDeviceId";
                }
                case 13: {
                    return "sendDpadKeyEvent";
                }
                case 14: {
                    return "sendKeyEvent";
                }
                case 15: {
                    return "sendButtonEvent";
                }
                case 16: {
                    return "sendRelativeEvent";
                }
                case 17: {
                    return "sendScrollEvent";
                }
                case 18: {
                    return "sendTouchEvent";
                }
                case 19: {
                    return "getVirtualSensorList";
                }
                case 20: {
                    return "sendSensorEvent";
                }
                case 21: {
                    return "launchPendingIntent";
                }
                case 22: {
                    return "getCursorPosition";
                }
                case 23: {
                    return "setShowPointerIcon";
                }
                case 24: {
                    return "registerIntentInterceptor";
                }
                case 25: {
                    return "unregisterIntentInterceptor";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualDevice.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _result = this.getAssociationId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    int _result = this.getDeviceId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    IAudioRoutingCallback _arg1 = IAudioRoutingCallback.Stub.asInterface(data.readStrongBinder());
                    IAudioConfigChangedCallback _arg2 = IAudioConfigChangedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onAudioSessionStarting(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.onAudioSessionEnded();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    VirtualDpadConfig _arg0 = data.readTypedObject(VirtualDpadConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createVirtualDpad(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    VirtualKeyboardConfig _arg0 = data.readTypedObject(VirtualKeyboardConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createVirtualKeyboard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    VirtualMouseConfig _arg0 = data.readTypedObject(VirtualMouseConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createVirtualMouse(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    VirtualTouchscreenConfig _arg0 = data.readTypedObject(VirtualTouchscreenConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createVirtualTouchscreen(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    VirtualNavigationTouchpadConfig _arg0 = data.readTypedObject(VirtualNavigationTouchpadConfig.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createVirtualNavigationTouchpad(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.unregisterInputDevice(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.getInputDeviceId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 13: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualKeyEvent _arg1 = data.readTypedObject(VirtualKeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendDpadKeyEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualKeyEvent _arg1 = data.readTypedObject(VirtualKeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendKeyEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualMouseButtonEvent _arg1 = data.readTypedObject(VirtualMouseButtonEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendButtonEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualMouseRelativeEvent _arg1 = data.readTypedObject(VirtualMouseRelativeEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendRelativeEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualMouseScrollEvent _arg1 = data.readTypedObject(VirtualMouseScrollEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendScrollEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualTouchEvent _arg1 = data.readTypedObject(VirtualTouchEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendTouchEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    List<VirtualSensor> _result = this.getVirtualSensorList();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    VirtualSensorEvent _arg1 = data.readTypedObject(VirtualSensorEvent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.sendSensorEvent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.launchPendingIntent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    PointF _result = this.getCursorPosition(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 23: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShowPointerIcon(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IVirtualDeviceIntentInterceptor _arg0 = IVirtualDeviceIntentInterceptor.Stub.asInterface(data.readStrongBinder());
                    IntentFilter _arg1 = data.readTypedObject(IntentFilter.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerIntentInterceptor(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    IVirtualDeviceIntentInterceptor _arg0 = IVirtualDeviceIntentInterceptor.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterIntentInterceptor(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void close_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onAudioSessionStarting_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onAudioSessionEnded_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void createVirtualDpad_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void createVirtualKeyboard_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void createVirtualMouse_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void createVirtualTouchscreen_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void createVirtualNavigationTouchpad_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterInputDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendDpadKeyEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendKeyEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendButtonEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendRelativeEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendScrollEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendTouchEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getVirtualSensorList_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void sendSensorEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setShowPointerIcon_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerIntentInterceptor_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterIntentInterceptor_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 24;
        }

        private static class Proxy
        implements IVirtualDevice {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualDevice.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAssociationId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioSessionStarting(int displayId, IAudioRoutingCallback routingCallback, IAudioConfigChangedCallback configChangedCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(routingCallback);
                    _data.writeStrongInterface(configChangedCallback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioSessionEnded() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createVirtualDpad(VirtualDpadConfig config, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createVirtualKeyboard(VirtualKeyboardConfig config, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createVirtualMouse(VirtualMouseConfig config, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createVirtualTouchscreen(VirtualTouchscreenConfig config, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createVirtualNavigationTouchpad(VirtualNavigationTouchpadConfig config, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterInputDevice(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInputDeviceId(IBinder token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendDpadKeyEvent(IBinder token, VirtualKeyEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendKeyEvent(IBinder token, VirtualKeyEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendButtonEvent(IBinder token, VirtualMouseButtonEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendRelativeEvent(IBinder token, VirtualMouseRelativeEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendScrollEvent(IBinder token, VirtualMouseScrollEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendTouchEvent(IBinder token, VirtualTouchEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<VirtualSensor> getVirtualSensorList() throws RemoteException {
                ArrayList<VirtualSensor> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(VirtualSensor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendSensorEvent(IBinder token, VirtualSensorEvent event) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void launchPendingIntent(int displayId, PendingIntent pendingIntent, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PointF getCursorPosition(IBinder token) throws RemoteException {
                PointF _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(PointF.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShowPointerIcon(boolean showPointerIcon) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeBoolean(showPointerIcon);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerIntentInterceptor(IVirtualDeviceIntentInterceptor intentInterceptor, IntentFilter filter) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongInterface(intentInterceptor);
                    _data.writeTypedObject(filter, 0);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterIntentInterceptor(IVirtualDeviceIntentInterceptor intentInterceptor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDevice.DESCRIPTOR);
                    _data.writeStrongInterface(intentInterceptor);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualDevice {
        @Override
        public int getAssociationId() throws RemoteException {
            return 0;
        }

        @Override
        public int getDeviceId() throws RemoteException {
            return 0;
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void onAudioSessionStarting(int displayId, IAudioRoutingCallback routingCallback, IAudioConfigChangedCallback configChangedCallback) throws RemoteException {
        }

        @Override
        public void onAudioSessionEnded() throws RemoteException {
        }

        @Override
        public void createVirtualDpad(VirtualDpadConfig config, IBinder token) throws RemoteException {
        }

        @Override
        public void createVirtualKeyboard(VirtualKeyboardConfig config, IBinder token) throws RemoteException {
        }

        @Override
        public void createVirtualMouse(VirtualMouseConfig config, IBinder token) throws RemoteException {
        }

        @Override
        public void createVirtualTouchscreen(VirtualTouchscreenConfig config, IBinder token) throws RemoteException {
        }

        @Override
        public void createVirtualNavigationTouchpad(VirtualNavigationTouchpadConfig config, IBinder token) throws RemoteException {
        }

        @Override
        public void unregisterInputDevice(IBinder token) throws RemoteException {
        }

        @Override
        public int getInputDeviceId(IBinder token) throws RemoteException {
            return 0;
        }

        @Override
        public boolean sendDpadKeyEvent(IBinder token, VirtualKeyEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendKeyEvent(IBinder token, VirtualKeyEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendButtonEvent(IBinder token, VirtualMouseButtonEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendRelativeEvent(IBinder token, VirtualMouseRelativeEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendScrollEvent(IBinder token, VirtualMouseScrollEvent event) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendTouchEvent(IBinder token, VirtualTouchEvent event) throws RemoteException {
            return false;
        }

        @Override
        public List<VirtualSensor> getVirtualSensorList() throws RemoteException {
            return null;
        }

        @Override
        public boolean sendSensorEvent(IBinder token, VirtualSensorEvent event) throws RemoteException {
            return false;
        }

        @Override
        public void launchPendingIntent(int displayId, PendingIntent pendingIntent, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public PointF getCursorPosition(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public void setShowPointerIcon(boolean showPointerIcon) throws RemoteException {
        }

        @Override
        public void registerIntentInterceptor(IVirtualDeviceIntentInterceptor intentInterceptor, IntentFilter filter) throws RemoteException {
        }

        @Override
        public void unregisterIntentInterceptor(IVirtualDeviceIntentInterceptor intentInterceptor) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

