/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IVirtualDeviceActivityListener
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.IVirtualDeviceActivityListener";

    public void onTopActivityChanged(int var1, ComponentName var2, int var3) throws RemoteException;

    public void onDisplayEmpty(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualDeviceActivityListener {
        static final int TRANSACTION_onTopActivityChanged = 1;
        static final int TRANSACTION_onDisplayEmpty = 2;

        public Stub() {
            this.attachInterface(this, IVirtualDeviceActivityListener.DESCRIPTOR);
        }

        public static IVirtualDeviceActivityListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualDeviceActivityListener.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualDeviceActivityListener) {
                return (IVirtualDeviceActivityListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTopActivityChanged";
                }
                case 2: {
                    return "onDisplayEmpty";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualDeviceActivityListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTopActivityChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDisplayEmpty(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IVirtualDeviceActivityListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualDeviceActivityListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTopActivityChanged(int displayId, ComponentName topActivity, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualDeviceActivityListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(topActivity, 0);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayEmpty(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualDeviceActivityListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualDeviceActivityListener {
        @Override
        public void onTopActivityChanged(int displayId, ComponentName topActivity, int userId) throws RemoteException {
        }

        @Override
        public void onDisplayEmpty(int displayId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

