/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IVirtualDeviceIntentInterceptor
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.IVirtualDeviceIntentInterceptor";

    public void onIntentIntercepted(Intent var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualDeviceIntentInterceptor {
        static final int TRANSACTION_onIntentIntercepted = 1;

        public Stub() {
            this.attachInterface(this, IVirtualDeviceIntentInterceptor.DESCRIPTOR);
        }

        public static IVirtualDeviceIntentInterceptor asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualDeviceIntentInterceptor.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualDeviceIntentInterceptor) {
                return (IVirtualDeviceIntentInterceptor)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onIntentIntercepted";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualDeviceIntentInterceptor.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Intent _arg0 = data.readTypedObject(Intent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onIntentIntercepted(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IVirtualDeviceIntentInterceptor {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualDeviceIntentInterceptor.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIntentIntercepted(Intent intent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualDeviceIntentInterceptor.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualDeviceIntentInterceptor {
        @Override
        public void onIntentIntercepted(Intent intent) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

