/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.IVirtualDeviceActivityListener;
import android.companion.virtual.IVirtualDeviceSoundEffectListener;
import android.companion.virtual.VirtualDevice;
import android.companion.virtual.VirtualDeviceParams;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplayConfig;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IVirtualDeviceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.IVirtualDeviceManager";

    public IVirtualDevice createVirtualDevice(IBinder var1, String var2, int var3, VirtualDeviceParams var4, IVirtualDeviceActivityListener var5, IVirtualDeviceSoundEffectListener var6) throws RemoteException;

    public List<VirtualDevice> getVirtualDevices() throws RemoteException;

    public int getDeviceIdForDisplayId(int var1) throws RemoteException;

    public boolean isValidVirtualDeviceId(int var1) throws RemoteException;

    public int getDevicePolicy(int var1, int var2) throws RemoteException;

    public int createVirtualDisplay(VirtualDisplayConfig var1, IVirtualDisplayCallback var2, IVirtualDevice var3, String var4) throws RemoteException;

    public int getAudioPlaybackSessionId(int var1) throws RemoteException;

    public int getAudioRecordingSessionId(int var1) throws RemoteException;

    public void playSoundEffect(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualDeviceManager {
        static final int TRANSACTION_createVirtualDevice = 1;
        static final int TRANSACTION_getVirtualDevices = 2;
        static final int TRANSACTION_getDeviceIdForDisplayId = 3;
        static final int TRANSACTION_isValidVirtualDeviceId = 4;
        static final int TRANSACTION_getDevicePolicy = 5;
        static final int TRANSACTION_createVirtualDisplay = 6;
        static final int TRANSACTION_getAudioPlaybackSessionId = 7;
        static final int TRANSACTION_getAudioRecordingSessionId = 8;
        static final int TRANSACTION_playSoundEffect = 9;

        public Stub() {
            this.attachInterface(this, IVirtualDeviceManager.DESCRIPTOR);
        }

        public static IVirtualDeviceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualDeviceManager.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualDeviceManager) {
                return (IVirtualDeviceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createVirtualDevice";
                }
                case 2: {
                    return "getVirtualDevices";
                }
                case 3: {
                    return "getDeviceIdForDisplayId";
                }
                case 4: {
                    return "isValidVirtualDeviceId";
                }
                case 5: {
                    return "getDevicePolicy";
                }
                case 6: {
                    return "createVirtualDisplay";
                }
                case 7: {
                    return "getAudioPlaybackSessionId";
                }
                case 8: {
                    return "getAudioRecordingSessionId";
                }
                case 9: {
                    return "playSoundEffect";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualDeviceManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    VirtualDeviceParams _arg3 = data.readTypedObject(VirtualDeviceParams.CREATOR);
                    IVirtualDeviceActivityListener _arg4 = IVirtualDeviceActivityListener.Stub.asInterface(data.readStrongBinder());
                    IVirtualDeviceSoundEffectListener _arg5 = IVirtualDeviceSoundEffectListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IVirtualDevice _result = this.createVirtualDevice(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    List<VirtualDevice> _result = this.getVirtualDevices();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDeviceIdForDisplayId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isValidVirtualDeviceId(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDevicePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    VirtualDisplayConfig _arg0 = data.readTypedObject(VirtualDisplayConfig.CREATOR);
                    IVirtualDisplayCallback _arg1 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    IVirtualDevice _arg2 = IVirtualDevice.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.createVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getAudioPlaybackSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getAudioRecordingSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playSoundEffect(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IVirtualDeviceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualDeviceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualDevice createVirtualDevice(IBinder token, String packageName, int associationId, VirtualDeviceParams params, IVirtualDeviceActivityListener activityListener, IVirtualDeviceSoundEffectListener soundEffectListener) throws RemoteException {
                IVirtualDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(packageName);
                    _data.writeInt(associationId);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(activityListener);
                    _data.writeStrongInterface(soundEffectListener);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<VirtualDevice> getVirtualDevices() throws RemoteException {
                ArrayList<VirtualDevice> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(VirtualDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceIdForDisplayId(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isValidVirtualDeviceId(int deviceId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDevicePolicy(int deviceId, int policyType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(policyType);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback, IVirtualDevice virtualDevice, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeTypedObject(virtualDisplayConfig, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeStrongInterface(virtualDevice);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAudioPlaybackSessionId(int deviceId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAudioRecordingSessionId(int deviceId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playSoundEffect(int deviceId, int effectType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(effectType);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualDeviceManager {
        @Override
        public IVirtualDevice createVirtualDevice(IBinder token, String packageName, int associationId, VirtualDeviceParams params, IVirtualDeviceActivityListener activityListener, IVirtualDeviceSoundEffectListener soundEffectListener) throws RemoteException {
            return null;
        }

        @Override
        public List<VirtualDevice> getVirtualDevices() throws RemoteException {
            return null;
        }

        @Override
        public int getDeviceIdForDisplayId(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isValidVirtualDeviceId(int deviceId) throws RemoteException {
            return false;
        }

        @Override
        public int getDevicePolicy(int deviceId, int policyType) throws RemoteException {
            return 0;
        }

        @Override
        public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback, IVirtualDevice virtualDevice, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public int getAudioPlaybackSessionId(int deviceId) throws RemoteException {
            return 0;
        }

        @Override
        public int getAudioRecordingSessionId(int deviceId) throws RemoteException {
            return 0;
        }

        @Override
        public void playSoundEffect(int deviceId, int effectType) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

