/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.app.PendingIntent;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.IVirtualDeviceActivityListener;
import android.companion.virtual.IVirtualDeviceIntentInterceptor;
import android.companion.virtual.IVirtualDeviceManager;
import android.companion.virtual.IVirtualDeviceSoundEffectListener;
import android.companion.virtual.VirtualDeviceManager;
import android.companion.virtual.VirtualDeviceParams;
import android.companion.virtual.audio.VirtualAudioDevice;
import android.companion.virtual.sensor.VirtualSensor;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.input.VirtualDpad;
import android.hardware.input.VirtualDpadConfig;
import android.hardware.input.VirtualKeyboard;
import android.hardware.input.VirtualKeyboardConfig;
import android.hardware.input.VirtualMouse;
import android.hardware.input.VirtualMouseConfig;
import android.hardware.input.VirtualNavigationTouchpad;
import android.hardware.input.VirtualNavigationTouchpadConfig;
import android.hardware.input.VirtualTouchscreen;
import android.hardware.input.VirtualTouchscreenConfig;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.IntConsumer;

public class VirtualDeviceInternal {
    private final Context mContext;
    private final IVirtualDeviceManager mService;
    private final IVirtualDevice mVirtualDevice;
    private final Object mActivityListenersLock = new Object();
    @GuardedBy(value={"mActivityListenersLock"})
    private final ArrayMap<VirtualDeviceManager.ActivityListener, ActivityListenerDelegate> mActivityListeners = new ArrayMap();
    private final Object mIntentInterceptorListenersLock = new Object();
    @GuardedBy(value={"mIntentInterceptorListenersLock"})
    private final ArrayMap<VirtualDeviceManager.IntentInterceptorCallback, IntentInterceptorDelegate> mIntentInterceptorListeners = new ArrayMap();
    private final Object mSoundEffectListenersLock = new Object();
    @GuardedBy(value={"mSoundEffectListenersLock"})
    private final ArrayMap<VirtualDeviceManager.SoundEffectListener, SoundEffectListenerDelegate> mSoundEffectListeners = new ArrayMap();
    private final IVirtualDeviceActivityListener mActivityListenerBinder = new IVirtualDeviceActivityListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTopActivityChanged(int displayId, ComponentName topActivity, int userId) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mActivityListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mActivityListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onTopActivityChanged(displayId, topActivity);
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onTopActivityChanged(displayId, topActivity, userId);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayEmpty(int displayId) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mActivityListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mActivityListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mActivityListeners.valueAt(i).onDisplayEmpty(displayId);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };
    private final IVirtualDeviceSoundEffectListener mSoundEffectListener = new IVirtualDeviceSoundEffectListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlaySoundEffect(int soundEffect) {
            long token = Binder.clearCallingIdentity();
            try {
                Object object = VirtualDeviceInternal.this.mSoundEffectListenersLock;
                synchronized (object) {
                    for (int i = 0; i < VirtualDeviceInternal.this.mSoundEffectListeners.size(); ++i) {
                        VirtualDeviceInternal.this.mSoundEffectListeners.valueAt(i).onPlaySoundEffect(soundEffect);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    };
    private VirtualAudioDevice mVirtualAudioDevice;

    VirtualDeviceInternal(IVirtualDeviceManager service, Context context, int associationId, VirtualDeviceParams params) throws RemoteException {
        this.mService = service;
        this.mContext = context.getApplicationContext();
        this.mVirtualDevice = service.createVirtualDevice(new Binder(), this.mContext.getPackageName(), associationId, params, this.mActivityListenerBinder, this.mSoundEffectListener);
    }

    int getDeviceId() {
        try {
            return this.mVirtualDevice.getDeviceId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    Context createContext() {
        try {
            return this.mContext.createDeviceContext(this.mVirtualDevice.getDeviceId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    List<VirtualSensor> getVirtualSensorList() {
        try {
            return this.mVirtualDevice.getVirtualSensorList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void launchPendingIntent(int displayId, PendingIntent pendingIntent, final Executor executor, final IntConsumer listener) {
        try {
            this.mVirtualDevice.launchPendingIntent(displayId, pendingIntent, new ResultReceiver(new Handler(Looper.getMainLooper())){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    super.onReceiveResult(resultCode, resultData);
                    executor.execute(() -> listener.accept(resultCode));
                }
            });
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    VirtualDisplay createVirtualDisplay(VirtualDisplayConfig config, Executor executor, VirtualDisplay.Callback callback) {
        int displayId;
        DisplayManagerGlobal.VirtualDisplayCallback callbackWrapper = new DisplayManagerGlobal.VirtualDisplayCallback(callback, executor);
        try {
            displayId = this.mService.createVirtualDisplay(config, callbackWrapper, this.mVirtualDevice, this.mContext.getPackageName());
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
        DisplayManagerGlobal displayManager = DisplayManagerGlobal.getInstance();
        return displayManager.createVirtualDisplayWrapper(config, callbackWrapper, displayId);
    }

    void close() {
        try {
            this.mVirtualDevice.close();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (this.mVirtualAudioDevice != null) {
            this.mVirtualAudioDevice.close();
            this.mVirtualAudioDevice = null;
        }
    }

    VirtualDpad createVirtualDpad(VirtualDpadConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualDpad:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualDpad(config, token);
            return new VirtualDpad(this.mVirtualDevice, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    VirtualKeyboard createVirtualKeyboard(VirtualKeyboardConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualKeyboard:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualKeyboard(config, token);
            return new VirtualKeyboard(this.mVirtualDevice, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    VirtualMouse createVirtualMouse(VirtualMouseConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualMouse:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualMouse(config, token);
            return new VirtualMouse(this.mVirtualDevice, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    VirtualTouchscreen createVirtualTouchscreen(VirtualTouchscreenConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualTouchscreen:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualTouchscreen(config, token);
            return new VirtualTouchscreen(this.mVirtualDevice, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    VirtualNavigationTouchpad createVirtualNavigationTouchpad(VirtualNavigationTouchpadConfig config) {
        try {
            Binder token = new Binder("android.hardware.input.VirtualNavigationTouchpad:" + config.getInputDeviceName());
            this.mVirtualDevice.createVirtualNavigationTouchpad(config, token);
            return new VirtualNavigationTouchpad(this.mVirtualDevice, token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    VirtualAudioDevice createVirtualAudioDevice(VirtualDisplay display, Executor executor, VirtualAudioDevice.AudioConfigurationChangeCallback callback) {
        if (this.mVirtualAudioDevice == null) {
            this.mVirtualAudioDevice = new VirtualAudioDevice(this.mContext, this.mVirtualDevice, display, executor, callback, () -> {
                this.mVirtualAudioDevice = null;
            });
        }
        return this.mVirtualAudioDevice;
    }

    void setShowPointerIcon(boolean showPointerIcon) {
        try {
            this.mVirtualDevice.setShowPointerIcon(showPointerIcon);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActivityListener(Executor executor, VirtualDeviceManager.ActivityListener listener) {
        ActivityListenerDelegate delegate = new ActivityListenerDelegate(Objects.requireNonNull(listener), Objects.requireNonNull(executor));
        Object object = this.mActivityListenersLock;
        synchronized (object) {
            this.mActivityListeners.put(listener, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActivityListener(VirtualDeviceManager.ActivityListener listener) {
        Object object = this.mActivityListenersLock;
        synchronized (object) {
            this.mActivityListeners.remove(Objects.requireNonNull(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSoundEffectListener(Executor executor, VirtualDeviceManager.SoundEffectListener soundEffectListener) {
        SoundEffectListenerDelegate delegate = new SoundEffectListenerDelegate(Objects.requireNonNull(executor), Objects.requireNonNull(soundEffectListener));
        Object object = this.mSoundEffectListenersLock;
        synchronized (object) {
            this.mSoundEffectListeners.put(soundEffectListener, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSoundEffectListener(VirtualDeviceManager.SoundEffectListener soundEffectListener) {
        Object object = this.mSoundEffectListenersLock;
        synchronized (object) {
            this.mSoundEffectListeners.remove(Objects.requireNonNull(soundEffectListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerIntentInterceptor(IntentFilter interceptorFilter, Executor executor, VirtualDeviceManager.IntentInterceptorCallback interceptorCallback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(interceptorFilter);
        Objects.requireNonNull(interceptorCallback);
        IntentInterceptorDelegate delegate = new IntentInterceptorDelegate(executor, interceptorCallback);
        try {
            this.mVirtualDevice.registerIntentInterceptor(delegate, interceptorFilter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Object object = this.mIntentInterceptorListenersLock;
        synchronized (object) {
            this.mIntentInterceptorListeners.put(interceptorCallback, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterIntentInterceptor(VirtualDeviceManager.IntentInterceptorCallback interceptorCallback) {
        IntentInterceptorDelegate delegate;
        Objects.requireNonNull(interceptorCallback);
        Object object = this.mIntentInterceptorListenersLock;
        synchronized (object) {
            delegate = this.mIntentInterceptorListeners.remove(interceptorCallback);
        }
        if (delegate != null) {
            try {
                this.mVirtualDevice.unregisterIntentInterceptor(delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private static class ActivityListenerDelegate {
        private final VirtualDeviceManager.ActivityListener mActivityListener;
        private final Executor mExecutor;

        ActivityListenerDelegate(VirtualDeviceManager.ActivityListener listener, Executor executor) {
            this.mActivityListener = listener;
            this.mExecutor = executor;
        }

        public void onTopActivityChanged(int displayId, ComponentName topActivity) {
            this.mExecutor.execute(() -> this.mActivityListener.onTopActivityChanged(displayId, topActivity));
        }

        public void onTopActivityChanged(int displayId, ComponentName topActivity, int userId) {
            this.mExecutor.execute(() -> this.mActivityListener.onTopActivityChanged(displayId, topActivity, userId));
        }

        public void onDisplayEmpty(int displayId) {
            this.mExecutor.execute(() -> this.mActivityListener.onDisplayEmpty(displayId));
        }
    }

    private static class SoundEffectListenerDelegate {
        private final VirtualDeviceManager.SoundEffectListener mSoundEffectListener;
        private final Executor mExecutor;

        private SoundEffectListenerDelegate(Executor executor, VirtualDeviceManager.SoundEffectListener soundEffectCallback) {
            this.mSoundEffectListener = soundEffectCallback;
            this.mExecutor = executor;
        }

        public void onPlaySoundEffect(int effectType) {
            this.mExecutor.execute(() -> this.mSoundEffectListener.onPlaySoundEffect(effectType));
        }
    }

    private static class IntentInterceptorDelegate
    extends IVirtualDeviceIntentInterceptor.Stub {
        private final VirtualDeviceManager.IntentInterceptorCallback mIntentInterceptorCallback;
        private final Executor mExecutor;

        private IntentInterceptorDelegate(Executor executor, VirtualDeviceManager.IntentInterceptorCallback interceptorCallback) {
            this.mExecutor = executor;
            this.mIntentInterceptorCallback = interceptorCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onIntentIntercepted(Intent intent) {
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mIntentInterceptorCallback.onIntentIntercepted(intent));
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }
}

