/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.companion.virtual.sensor.IVirtualSensorCallback;
import android.companion.virtual.sensor.VirtualSensor;
import android.companion.virtual.sensor.VirtualSensorCallback;
import android.companion.virtual.sensor.VirtualSensorConfig;
import android.companion.virtual.sensor.VirtualSensorDirectChannelCallback;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SharedMemory;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@SystemApi
public class VirtualDeviceParams
implements Parcelable {
    public static final int LOCK_STATE_DEFAULT = 0;
    public static final int LOCK_STATE_ALWAYS_UNLOCKED = 1;
    public static final int ACTIVITY_POLICY_DEFAULT_ALLOWED = 0;
    public static final int ACTIVITY_POLICY_DEFAULT_BLOCKED = 1;
    public static final int NAVIGATION_POLICY_DEFAULT_ALLOWED = 0;
    public static final int NAVIGATION_POLICY_DEFAULT_BLOCKED = 1;
    public static final int DEVICE_POLICY_DEFAULT = 0;
    public static final int DEVICE_POLICY_CUSTOM = 1;
    public static final int POLICY_TYPE_SENSORS = 0;
    public static final int POLICY_TYPE_AUDIO = 1;
    public static final int POLICY_TYPE_RECENTS = 2;
    private final int mLockState;
    private final ArraySet<UserHandle> mUsersWithMatchingAccounts;
    private final ArraySet<ComponentName> mAllowedCrossTaskNavigations;
    private final ArraySet<ComponentName> mBlockedCrossTaskNavigations;
    private final int mDefaultNavigationPolicy;
    private final ArraySet<ComponentName> mAllowedActivities;
    private final ArraySet<ComponentName> mBlockedActivities;
    private final int mDefaultActivityPolicy;
    private final String mName;
    private final SparseIntArray mDevicePolicies;
    private final List<VirtualSensorConfig> mVirtualSensorConfigs;
    private final IVirtualSensorCallback mVirtualSensorCallback;
    private final int mAudioPlaybackSessionId;
    private final int mAudioRecordingSessionId;
    public static final Parcelable.Creator<VirtualDeviceParams> CREATOR = new Parcelable.Creator<VirtualDeviceParams>(){

        @Override
        public VirtualDeviceParams createFromParcel(Parcel in) {
            return new VirtualDeviceParams(in);
        }

        public VirtualDeviceParams[] newArray(int size) {
            return new VirtualDeviceParams[size];
        }
    };

    private VirtualDeviceParams(int lockState, Set<UserHandle> usersWithMatchingAccounts, Set<ComponentName> allowedCrossTaskNavigations, Set<ComponentName> blockedCrossTaskNavigations, int defaultNavigationPolicy, Set<ComponentName> allowedActivities, Set<ComponentName> blockedActivities, int defaultActivityPolicy, String name, SparseIntArray devicePolicies, List<VirtualSensorConfig> virtualSensorConfigs, IVirtualSensorCallback virtualSensorCallback, int audioPlaybackSessionId, int audioRecordingSessionId) {
        this.mLockState = lockState;
        this.mUsersWithMatchingAccounts = new ArraySet(Objects.requireNonNull(usersWithMatchingAccounts));
        this.mAllowedCrossTaskNavigations = new ArraySet(Objects.requireNonNull(allowedCrossTaskNavigations));
        this.mBlockedCrossTaskNavigations = new ArraySet(Objects.requireNonNull(blockedCrossTaskNavigations));
        this.mDefaultNavigationPolicy = defaultNavigationPolicy;
        this.mAllowedActivities = new ArraySet(Objects.requireNonNull(allowedActivities));
        this.mBlockedActivities = new ArraySet(Objects.requireNonNull(blockedActivities));
        this.mDefaultActivityPolicy = defaultActivityPolicy;
        this.mName = name;
        this.mDevicePolicies = Objects.requireNonNull(devicePolicies);
        this.mVirtualSensorConfigs = Objects.requireNonNull(virtualSensorConfigs);
        this.mVirtualSensorCallback = virtualSensorCallback;
        this.mAudioPlaybackSessionId = audioPlaybackSessionId;
        this.mAudioRecordingSessionId = audioRecordingSessionId;
    }

    private VirtualDeviceParams(Parcel parcel) {
        this.mLockState = parcel.readInt();
        this.mUsersWithMatchingAccounts = parcel.readArraySet(null);
        this.mAllowedCrossTaskNavigations = parcel.readArraySet(null);
        this.mBlockedCrossTaskNavigations = parcel.readArraySet(null);
        this.mDefaultNavigationPolicy = parcel.readInt();
        this.mAllowedActivities = parcel.readArraySet(null);
        this.mBlockedActivities = parcel.readArraySet(null);
        this.mDefaultActivityPolicy = parcel.readInt();
        this.mName = parcel.readString8();
        this.mDevicePolicies = parcel.readSparseIntArray();
        this.mVirtualSensorConfigs = new ArrayList<VirtualSensorConfig>();
        parcel.readTypedList(this.mVirtualSensorConfigs, VirtualSensorConfig.CREATOR);
        this.mVirtualSensorCallback = IVirtualSensorCallback.Stub.asInterface(parcel.readStrongBinder());
        this.mAudioPlaybackSessionId = parcel.readInt();
        this.mAudioRecordingSessionId = parcel.readInt();
    }

    public int getLockState() {
        return this.mLockState;
    }

    public Set<UserHandle> getUsersWithMatchingAccounts() {
        return Collections.unmodifiableSet(this.mUsersWithMatchingAccounts);
    }

    public Set<ComponentName> getAllowedCrossTaskNavigations() {
        return Collections.unmodifiableSet(this.mAllowedCrossTaskNavigations);
    }

    public Set<ComponentName> getBlockedCrossTaskNavigations() {
        return Collections.unmodifiableSet(this.mBlockedCrossTaskNavigations);
    }

    public int getDefaultNavigationPolicy() {
        return this.mDefaultNavigationPolicy;
    }

    public Set<ComponentName> getAllowedActivities() {
        return Collections.unmodifiableSet(this.mAllowedActivities);
    }

    public Set<ComponentName> getBlockedActivities() {
        return Collections.unmodifiableSet(this.mBlockedActivities);
    }

    public int getDefaultActivityPolicy() {
        return this.mDefaultActivityPolicy;
    }

    public String getName() {
        return this.mName;
    }

    public int getDevicePolicy(int policyType) {
        return this.mDevicePolicies.get(policyType, 0);
    }

    public List<VirtualSensorConfig> getVirtualSensorConfigs() {
        return this.mVirtualSensorConfigs;
    }

    public IVirtualSensorCallback getVirtualSensorCallback() {
        return this.mVirtualSensorCallback;
    }

    public int getAudioPlaybackSessionId() {
        return this.mAudioPlaybackSessionId;
    }

    public int getAudioRecordingSessionId() {
        return this.mAudioRecordingSessionId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLockState);
        dest.writeArraySet(this.mUsersWithMatchingAccounts);
        dest.writeArraySet(this.mAllowedCrossTaskNavigations);
        dest.writeArraySet(this.mBlockedCrossTaskNavigations);
        dest.writeInt(this.mDefaultNavigationPolicy);
        dest.writeArraySet(this.mAllowedActivities);
        dest.writeArraySet(this.mBlockedActivities);
        dest.writeInt(this.mDefaultActivityPolicy);
        dest.writeString8(this.mName);
        dest.writeSparseIntArray(this.mDevicePolicies);
        dest.writeTypedList(this.mVirtualSensorConfigs);
        dest.writeStrongBinder(this.mVirtualSensorCallback != null ? this.mVirtualSensorCallback.asBinder() : null);
        dest.writeInt(this.mAudioPlaybackSessionId);
        dest.writeInt(this.mAudioRecordingSessionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualDeviceParams)) {
            return false;
        }
        VirtualDeviceParams that = (VirtualDeviceParams)o;
        int devicePoliciesCount = this.mDevicePolicies.size();
        if (devicePoliciesCount != that.mDevicePolicies.size()) {
            return false;
        }
        for (int i = 0; i < devicePoliciesCount; ++i) {
            if (this.mDevicePolicies.keyAt(i) != that.mDevicePolicies.keyAt(i)) {
                return false;
            }
            if (this.mDevicePolicies.valueAt(i) == that.mDevicePolicies.valueAt(i)) continue;
            return false;
        }
        return this.mLockState == that.mLockState && this.mUsersWithMatchingAccounts.equals(that.mUsersWithMatchingAccounts) && Objects.equals(this.mAllowedCrossTaskNavigations, that.mAllowedCrossTaskNavigations) && Objects.equals(this.mBlockedCrossTaskNavigations, that.mBlockedCrossTaskNavigations) && this.mDefaultNavigationPolicy == that.mDefaultNavigationPolicy && Objects.equals(this.mAllowedActivities, that.mAllowedActivities) && Objects.equals(this.mBlockedActivities, that.mBlockedActivities) && this.mDefaultActivityPolicy == that.mDefaultActivityPolicy && Objects.equals(this.mName, that.mName) && this.mAudioPlaybackSessionId == that.mAudioPlaybackSessionId && this.mAudioRecordingSessionId == that.mAudioRecordingSessionId;
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.mLockState, this.mUsersWithMatchingAccounts, this.mAllowedCrossTaskNavigations, this.mBlockedCrossTaskNavigations, this.mDefaultNavigationPolicy, this.mAllowedActivities, this.mBlockedActivities, this.mDefaultActivityPolicy, this.mName, this.mDevicePolicies, this.mAudioPlaybackSessionId, this.mAudioRecordingSessionId);
        for (int i = 0; i < this.mDevicePolicies.size(); ++i) {
            hashCode = 31 * hashCode + this.mDevicePolicies.keyAt(i);
            hashCode = 31 * hashCode + this.mDevicePolicies.valueAt(i);
        }
        return hashCode;
    }

    public String toString() {
        return "VirtualDeviceParams( mLockState=" + this.mLockState + " mUsersWithMatchingAccounts=" + this.mUsersWithMatchingAccounts + " mAllowedCrossTaskNavigations=" + this.mAllowedCrossTaskNavigations + " mBlockedCrossTaskNavigations=" + this.mBlockedCrossTaskNavigations + " mDefaultNavigationPolicy=" + this.mDefaultNavigationPolicy + " mAllowedActivities=" + this.mAllowedActivities + " mBlockedActivities=" + this.mBlockedActivities + " mDefaultActivityPolicy=" + this.mDefaultActivityPolicy + " mName=" + this.mName + " mDevicePolicies=" + this.mDevicePolicies + " mAudioPlaybackSessionId=" + this.mAudioPlaybackSessionId + " mAudioRecordingSessionId=" + this.mAudioRecordingSessionId + ")";
    }

    public static class Builder {
        private int mLockState = 0;
        private Set<UserHandle> mUsersWithMatchingAccounts = Collections.emptySet();
        private Set<ComponentName> mAllowedCrossTaskNavigations = Collections.emptySet();
        private Set<ComponentName> mBlockedCrossTaskNavigations = Collections.emptySet();
        private int mDefaultNavigationPolicy = 0;
        private boolean mDefaultNavigationPolicyConfigured = false;
        private Set<ComponentName> mBlockedActivities = Collections.emptySet();
        private Set<ComponentName> mAllowedActivities = Collections.emptySet();
        private int mDefaultActivityPolicy = 0;
        private boolean mDefaultActivityPolicyConfigured = false;
        private String mName;
        private SparseIntArray mDevicePolicies = new SparseIntArray();
        private int mAudioPlaybackSessionId = 0;
        private int mAudioRecordingSessionId = 0;
        private List<VirtualSensorConfig> mVirtualSensorConfigs = new ArrayList<VirtualSensorConfig>();
        private Executor mVirtualSensorCallbackExecutor;
        private VirtualSensorCallback mVirtualSensorCallback;
        private Executor mVirtualSensorDirectChannelCallbackExecutor;
        private VirtualSensorDirectChannelCallback mVirtualSensorDirectChannelCallback;

        @RequiresPermission(value="android.permission.ADD_ALWAYS_UNLOCKED_DISPLAY", conditional=true)
        public Builder setLockState(int lockState) {
            this.mLockState = lockState;
            return this;
        }

        public Builder setUsersWithMatchingAccounts(Set<UserHandle> usersWithMatchingAccounts) {
            this.mUsersWithMatchingAccounts = Objects.requireNonNull(usersWithMatchingAccounts);
            return this;
        }

        public Builder setAllowedCrossTaskNavigations(Set<ComponentName> allowedCrossTaskNavigations) {
            if (this.mDefaultNavigationPolicyConfigured && this.mDefaultNavigationPolicy != 1) {
                throw new IllegalArgumentException("Allowed cross task navigation and blocked task navigation cannot  both be set.");
            }
            this.mDefaultNavigationPolicy = 1;
            this.mDefaultNavigationPolicyConfigured = true;
            this.mAllowedCrossTaskNavigations = Objects.requireNonNull(allowedCrossTaskNavigations);
            return this;
        }

        public Builder setBlockedCrossTaskNavigations(Set<ComponentName> blockedCrossTaskNavigations) {
            if (this.mDefaultNavigationPolicyConfigured && this.mDefaultNavigationPolicy != 0) {
                throw new IllegalArgumentException("Allowed cross task navigation and blocked task navigation cannot  be set.");
            }
            this.mDefaultNavigationPolicy = 0;
            this.mDefaultNavigationPolicyConfigured = true;
            this.mBlockedCrossTaskNavigations = Objects.requireNonNull(blockedCrossTaskNavigations);
            return this;
        }

        public Builder setAllowedActivities(Set<ComponentName> allowedActivities) {
            if (this.mDefaultActivityPolicyConfigured && this.mDefaultActivityPolicy != 1) {
                throw new IllegalArgumentException("Allowed activities and Blocked activities cannot both be set.");
            }
            this.mDefaultActivityPolicy = 1;
            this.mDefaultActivityPolicyConfigured = true;
            this.mAllowedActivities = Objects.requireNonNull(allowedActivities);
            return this;
        }

        public Builder setBlockedActivities(Set<ComponentName> blockedActivities) {
            if (this.mDefaultActivityPolicyConfigured && this.mDefaultActivityPolicy != 0) {
                throw new IllegalArgumentException("Allowed activities and Blocked activities cannot both be set.");
            }
            this.mDefaultActivityPolicy = 0;
            this.mDefaultActivityPolicyConfigured = true;
            this.mBlockedActivities = Objects.requireNonNull(blockedActivities);
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevicePolicy(int policyType, int devicePolicy) {
            this.mDevicePolicies.put(policyType, devicePolicy);
            return this;
        }

        public Builder addVirtualSensorConfig(VirtualSensorConfig virtualSensorConfig) {
            this.mVirtualSensorConfigs.add(Objects.requireNonNull(virtualSensorConfig));
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setVirtualSensorCallback(Executor executor, VirtualSensorCallback callback) {
            this.mVirtualSensorCallbackExecutor = Objects.requireNonNull(executor);
            this.mVirtualSensorCallback = Objects.requireNonNull(callback);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setVirtualSensorDirectChannelCallback(Executor executor, VirtualSensorDirectChannelCallback callback) {
            this.mVirtualSensorDirectChannelCallbackExecutor = Objects.requireNonNull(executor);
            this.mVirtualSensorDirectChannelCallback = Objects.requireNonNull(callback);
            return this;
        }

        public Builder setAudioPlaybackSessionId(int playbackSessionId) {
            if (playbackSessionId < 0) {
                throw new IllegalArgumentException("Invalid playback audio session id");
            }
            this.mAudioPlaybackSessionId = playbackSessionId;
            return this;
        }

        public Builder setAudioRecordingSessionId(int recordingSessionId) {
            if (recordingSessionId < 0) {
                throw new IllegalArgumentException("Invalid recording audio session id");
            }
            this.mAudioRecordingSessionId = recordingSessionId;
            return this;
        }

        public VirtualDeviceParams build() {
            VirtualSensorCallbackDelegate virtualSensorCallbackDelegate = null;
            if (!this.mVirtualSensorConfigs.isEmpty()) {
                if (this.mDevicePolicies.get(0, 0) != 1) {
                    throw new IllegalArgumentException("DEVICE_POLICY_CUSTOM for POLICY_TYPE_SENSORS is required for creating virtual sensors.");
                }
                if (this.mVirtualSensorCallback == null) {
                    throw new IllegalArgumentException("VirtualSensorCallback is required for creating virtual sensors.");
                }
                for (int i = 0; i < this.mVirtualSensorConfigs.size(); ++i) {
                    if (this.mVirtualSensorConfigs.get(i).getDirectChannelTypesSupported() <= 0) continue;
                    if (this.mVirtualSensorDirectChannelCallback != null) break;
                    throw new IllegalArgumentException("VirtualSensorDirectChannelCallback is required for creating virtual sensors that support direct channel.");
                }
                virtualSensorCallbackDelegate = new VirtualSensorCallbackDelegate(this.mVirtualSensorCallbackExecutor, this.mVirtualSensorCallback, this.mVirtualSensorDirectChannelCallbackExecutor, this.mVirtualSensorDirectChannelCallback);
            }
            if ((this.mAudioPlaybackSessionId != 0 || this.mAudioRecordingSessionId != 0) && this.mDevicePolicies.get(1, 0) != 1) {
                throw new IllegalArgumentException("DEVICE_POLICY_CUSTOM for POLICY_TYPE_AUDIO is required for configuration of device-specific audio session ids.");
            }
            SparseArray<Set> sensorNameByType = new SparseArray<Set>();
            for (int i = 0; i < this.mVirtualSensorConfigs.size(); ++i) {
                VirtualSensorConfig config = this.mVirtualSensorConfigs.get(i);
                Set sensorNames = sensorNameByType.get(config.getType(), new ArraySet());
                if (!sensorNames.add(config.getName())) {
                    throw new IllegalArgumentException("Sensor names must be unique for a particular sensor type.");
                }
                sensorNameByType.put(config.getType(), sensorNames);
            }
            return new VirtualDeviceParams(this.mLockState, this.mUsersWithMatchingAccounts, this.mAllowedCrossTaskNavigations, this.mBlockedCrossTaskNavigations, this.mDefaultNavigationPolicy, this.mAllowedActivities, this.mBlockedActivities, this.mDefaultActivityPolicy, this.mName, this.mDevicePolicies, this.mVirtualSensorConfigs, virtualSensorCallbackDelegate, this.mAudioPlaybackSessionId, this.mAudioRecordingSessionId);
        }

        private static class VirtualSensorCallbackDelegate
        extends IVirtualSensorCallback.Stub {
            private final Executor mExecutor;
            private final VirtualSensorCallback mCallback;
            private final Executor mDirectChannelExecutor;
            private final VirtualSensorDirectChannelCallback mDirectChannelCallback;

            VirtualSensorCallbackDelegate(Executor executor, VirtualSensorCallback callback, Executor directChannelExecutor, VirtualSensorDirectChannelCallback directChannelCallback) {
                this.mExecutor = executor;
                this.mCallback = callback;
                this.mDirectChannelExecutor = directChannelExecutor;
                this.mDirectChannelCallback = directChannelCallback;
            }

            @Override
            public void onConfigurationChanged(VirtualSensor sensor, boolean enabled, int samplingPeriodMicros, int batchReportLatencyMicros) {
                Duration samplingPeriod = Duration.ofNanos(TimeUnit.MICROSECONDS.toNanos(samplingPeriodMicros));
                Duration batchReportingLatency = Duration.ofNanos(TimeUnit.MICROSECONDS.toNanos(batchReportLatencyMicros));
                this.mExecutor.execute(() -> this.mCallback.onConfigurationChanged(sensor, enabled, samplingPeriod, batchReportingLatency));
            }

            @Override
            public void onDirectChannelCreated(int channelHandle, SharedMemory sharedMemory) {
                if (this.mDirectChannelCallback != null && this.mDirectChannelExecutor != null) {
                    this.mDirectChannelExecutor.execute(() -> this.mDirectChannelCallback.onDirectChannelCreated(channelHandle, sharedMemory));
                }
            }

            @Override
            public void onDirectChannelDestroyed(int channelHandle) {
                if (this.mDirectChannelCallback != null && this.mDirectChannelExecutor != null) {
                    this.mDirectChannelExecutor.execute(() -> this.mDirectChannelCallback.onDirectChannelDestroyed(channelHandle));
                }
            }

            @Override
            public void onDirectChannelConfigured(int channelHandle, VirtualSensor sensor, int rateLevel, int reportToken) {
                if (this.mDirectChannelCallback != null && this.mDirectChannelExecutor != null) {
                    this.mDirectChannelExecutor.execute(() -> this.mDirectChannelCallback.onDirectChannelConfigured(channelHandle, sensor, rateLevel, reportToken));
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface PolicyType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface DevicePolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface NavigationPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface ActivityPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface LockState {
    }
}

