/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.audio;

import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IAudioConfigChangedCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.audio.IAudioConfigChangedCallback";

    public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> var1) throws RemoteException;

    public void onRecordingConfigChanged(List<AudioRecordingConfiguration> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAudioConfigChangedCallback {
        static final int TRANSACTION_onPlaybackConfigChanged = 1;
        static final int TRANSACTION_onRecordingConfigChanged = 2;

        public Stub() {
            this.attachInterface(this, IAudioConfigChangedCallback.DESCRIPTOR);
        }

        public static IAudioConfigChangedCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAudioConfigChangedCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IAudioConfigChangedCallback) {
                return (IAudioConfigChangedCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onPlaybackConfigChanged";
                }
                case 2: {
                    return "onRecordingConfigChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAudioConfigChangedCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ArrayList<AudioPlaybackConfiguration> _arg0 = data.createTypedArrayList(AudioPlaybackConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPlaybackConfigChanged(_arg0);
                    break;
                }
                case 2: {
                    ArrayList<AudioRecordingConfiguration> _arg0 = data.createTypedArrayList(AudioRecordingConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRecordingConfigChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IAudioConfigChangedCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAudioConfigChangedCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> configs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAudioConfigChangedCallback.DESCRIPTOR);
                    _data.writeTypedList(configs, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IAudioConfigChangedCallback.DESCRIPTOR);
                    _data.writeTypedList(configs, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAudioConfigChangedCallback {
        @Override
        public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> configs) throws RemoteException {
        }

        @Override
        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

