/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.audio;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.audio.AudioCapture;
import android.companion.virtual.audio.AudioInjection;
import android.companion.virtual.audio.VirtualAudioSession;
import android.content.Context;
import android.hardware.display.VirtualDisplay;
import android.media.AudioFormat;
import android.media.AudioPlaybackConfiguration;
import android.media.AudioRecordingConfiguration;
import android.os.RemoteException;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class VirtualAudioDevice
implements Closeable {
    private final Context mContext;
    private final IVirtualDevice mVirtualDevice;
    private final VirtualDisplay mVirtualDisplay;
    private final AudioConfigurationChangeCallback mCallback;
    private final Executor mExecutor;
    private final CloseListener mListener;
    private VirtualAudioSession mOngoingSession;

    public VirtualAudioDevice(Context context, IVirtualDevice virtualDevice, VirtualDisplay virtualDisplay, Executor executor, AudioConfigurationChangeCallback callback, CloseListener listener) {
        this.mContext = context;
        this.mVirtualDevice = virtualDevice;
        this.mVirtualDisplay = virtualDisplay;
        this.mExecutor = executor;
        this.mCallback = callback;
        this.mListener = listener;
    }

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public AudioInjection startAudioInjection(AudioFormat injectionFormat) {
        Objects.requireNonNull(injectionFormat, "injectionFormat must not be null");
        if (this.mOngoingSession != null && this.mOngoingSession.getAudioInjection() != null) {
            throw new IllegalStateException("Cannot start an audio injection while a session is ongoing. Call close() on this device first to end the previous session.");
        }
        if (this.mOngoingSession == null) {
            this.mOngoingSession = new VirtualAudioSession(this.mContext, this.mCallback, this.mExecutor);
        }
        try {
            this.mVirtualDevice.onAudioSessionStarting(this.mVirtualDisplay.getDisplay().getDisplayId(), this.mOngoingSession, this.mOngoingSession.getAudioConfigChangedListener());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return this.mOngoingSession.startAudioInjection(injectionFormat);
    }

    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public AudioCapture startAudioCapture(AudioFormat captureFormat) {
        Objects.requireNonNull(captureFormat, "captureFormat must not be null");
        if (this.mOngoingSession != null && this.mOngoingSession.getAudioCapture() != null) {
            throw new IllegalStateException("Cannot start an audio capture while a session is ongoing. Call close() on this device first to end the previous session.");
        }
        if (this.mOngoingSession == null) {
            this.mOngoingSession = new VirtualAudioSession(this.mContext, this.mCallback, this.mExecutor);
        }
        try {
            this.mVirtualDevice.onAudioSessionStarting(this.mVirtualDisplay.getDisplay().getDisplayId(), this.mOngoingSession, this.mOngoingSession.getAudioConfigChangedListener());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return this.mOngoingSession.startAudioCapture(captureFormat);
    }

    public AudioCapture getAudioCapture() {
        return this.mOngoingSession != null ? this.mOngoingSession.getAudioCapture() : null;
    }

    public AudioInjection getAudioInjection() {
        return this.mOngoingSession != null ? this.mOngoingSession.getAudioInjection() : null;
    }

    @Override
    @RequiresPermission(value="android.permission.MODIFY_AUDIO_ROUTING")
    public void close() {
        if (this.mOngoingSession != null) {
            this.mOngoingSession.close();
            this.mOngoingSession = null;
            try {
                this.mVirtualDevice.onAudioSessionEnded();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            if (this.mListener != null) {
                this.mListener.onClosed();
            }
        }
    }

    @SystemApi
    public static interface AudioConfigurationChangeCallback {
        public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> var1);

        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> var1);
    }

    public static interface CloseListener {
        public void onClosed();
    }
}

