/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.sensor;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.sensor.VirtualSensorEvent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

@SystemApi
public class VirtualSensor
implements Parcelable {
    private final int mHandle;
    private final int mType;
    private final String mName;
    private final IVirtualDevice mVirtualDevice;
    private final IBinder mToken;
    public static final Parcelable.Creator<VirtualSensor> CREATOR = new Parcelable.Creator<VirtualSensor>(){

        @Override
        public VirtualSensor createFromParcel(Parcel in) {
            return new VirtualSensor(in);
        }

        public VirtualSensor[] newArray(int size) {
            return new VirtualSensor[size];
        }
    };

    public VirtualSensor(int handle, int type, String name, IVirtualDevice virtualDevice, IBinder token) {
        this.mHandle = handle;
        this.mType = type;
        this.mName = name;
        this.mVirtualDevice = virtualDevice;
        this.mToken = token;
    }

    private VirtualSensor(Parcel parcel) {
        this.mHandle = parcel.readInt();
        this.mType = parcel.readInt();
        this.mName = parcel.readString8();
        this.mVirtualDevice = IVirtualDevice.Stub.asInterface(parcel.readStrongBinder());
        this.mToken = parcel.readStrongBinder();
    }

    public int getHandle() {
        return this.mHandle;
    }

    public int getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public int getDeviceId() {
        try {
            return this.mVirtualDevice.getDeviceId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mHandle);
        parcel.writeInt(this.mType);
        parcel.writeString8(this.mName);
        parcel.writeStrongBinder(this.mVirtualDevice.asBinder());
        parcel.writeStrongBinder(this.mToken);
    }

    @RequiresPermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public void sendEvent(VirtualSensorEvent event) {
        try {
            this.mVirtualDevice.sendSensorEvent(this.mToken, event);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

