/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.sensor;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class VirtualSensorConfig
implements Parcelable {
    private static final String TAG = "VirtualSensorConfig";
    private static final int DIRECT_REPORT_MASK = 896;
    private static final int DIRECT_REPORT_SHIFT = 7;
    private static final int DIRECT_CHANNEL_SHIFT = 10;
    private final int mType;
    private final String mName;
    private final String mVendor;
    private final float mMaximumRange;
    private final float mResolution;
    private final float mPower;
    private final int mMinDelay;
    private final int mMaxDelay;
    private final int mFlags;
    public static final Parcelable.Creator<VirtualSensorConfig> CREATOR = new Parcelable.Creator<VirtualSensorConfig>(){

        @Override
        public VirtualSensorConfig createFromParcel(Parcel source) {
            return new VirtualSensorConfig(source);
        }

        public VirtualSensorConfig[] newArray(int size) {
            return new VirtualSensorConfig[size];
        }
    };

    private VirtualSensorConfig(int type, String name, String vendor, float maximumRange, float resolution, float power, int minDelay, int maxDelay, int flags) {
        this.mType = type;
        this.mName = name;
        this.mVendor = vendor;
        this.mMaximumRange = maximumRange;
        this.mResolution = resolution;
        this.mPower = power;
        this.mMinDelay = minDelay;
        this.mMaxDelay = maxDelay;
        this.mFlags = flags;
    }

    private VirtualSensorConfig(Parcel parcel) {
        this.mType = parcel.readInt();
        this.mName = parcel.readString8();
        this.mVendor = parcel.readString8();
        this.mMaximumRange = parcel.readFloat();
        this.mResolution = parcel.readFloat();
        this.mPower = parcel.readFloat();
        this.mMinDelay = parcel.readInt();
        this.mMaxDelay = parcel.readInt();
        this.mFlags = parcel.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        parcel.writeString8(this.mName);
        parcel.writeString8(this.mVendor);
        parcel.writeFloat(this.mMaximumRange);
        parcel.writeFloat(this.mResolution);
        parcel.writeFloat(this.mPower);
        parcel.writeInt(this.mMinDelay);
        parcel.writeInt(this.mMaxDelay);
        parcel.writeInt(this.mFlags);
    }

    public int getType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public float getMaximumRange() {
        return this.mMaximumRange;
    }

    public float getResolution() {
        return this.mResolution;
    }

    public float getPower() {
        return this.mPower;
    }

    public int getMinDelay() {
        return this.mMinDelay;
    }

    public int getMaxDelay() {
        return this.mMaxDelay;
    }

    public int getHighestDirectReportRateLevel() {
        int rateLevel = (this.mFlags & 0x380) >> 7;
        return rateLevel <= 3 ? rateLevel : 3;
    }

    public int getDirectChannelTypesSupported() {
        int memoryTypes = 0;
        if ((this.mFlags & 0x400) > 0) {
            memoryTypes |= 1;
        }
        if ((this.mFlags & 0x800) > 0) {
            memoryTypes |= 2;
        }
        return memoryTypes;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public static class Builder {
        private static final int FLAG_MEMORY_FILE_DIRECT_CHANNEL_SUPPORTED = 1024;
        private final int mType;
        private final String mName;
        private String mVendor;
        private float mMaximumRange;
        private float mResolution;
        private float mPower;
        private int mMinDelay;
        private int mMaxDelay;
        private int mFlags;
        int mHighestDirectReportRateLevel;

        public Builder(int type, String name) {
            if (type <= 0) {
                throw new IllegalArgumentException("Virtual sensor type must be positive");
            }
            this.mType = type;
            this.mName = Objects.requireNonNull(name);
        }

        public VirtualSensorConfig build() {
            if (this.mHighestDirectReportRateLevel > 0) {
                if ((this.mFlags & 0x400) == 0) {
                    throw new IllegalArgumentException("Setting direct channel type is required for sensors with direct channel support.");
                }
                this.mFlags |= this.mHighestDirectReportRateLevel << 7;
            }
            if ((this.mFlags & 0x400) > 0 && this.mHighestDirectReportRateLevel == 0) {
                throw new IllegalArgumentException("Highest direct report rate level is required for sensors with direct channel support.");
            }
            return new VirtualSensorConfig(this.mType, this.mName, this.mVendor, this.mMaximumRange, this.mResolution, this.mPower, this.mMinDelay, this.mMaxDelay, this.mFlags);
        }

        public Builder setVendor(String vendor) {
            this.mVendor = vendor;
            return this;
        }

        public Builder setMaximumRange(float maximumRange) {
            this.mMaximumRange = maximumRange;
            return this;
        }

        public Builder setResolution(float resolution) {
            this.mResolution = resolution;
            return this;
        }

        public Builder setPower(float power) {
            this.mPower = power;
            return this;
        }

        public Builder setMinDelay(int minDelay) {
            this.mMinDelay = minDelay;
            return this;
        }

        public Builder setMaxDelay(int maxDelay) {
            this.mMaxDelay = maxDelay;
            return this;
        }

        public Builder setHighestDirectReportRateLevel(int rateLevel) {
            this.mHighestDirectReportRateLevel = rateLevel;
            return this;
        }

        public Builder setDirectChannelTypesSupported(int memoryTypes) {
            this.mFlags = (memoryTypes & 1) > 0 ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
            if ((memoryTypes & 0xFFFFFFFE) > 0) {
                throw new IllegalArgumentException("Only TYPE_MEMORY_FILE direct channels can be supported for virtual sensors.");
            }
            return this;
        }
    }
}

