/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.sensor;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;

@SystemApi
public class VirtualSensorEvent
implements Parcelable {
    private float[] mValues;
    private long mTimestampNanos;
    public static final Parcelable.Creator<VirtualSensorEvent> CREATOR = new Parcelable.Creator<VirtualSensorEvent>(){

        @Override
        public VirtualSensorEvent createFromParcel(Parcel source) {
            return new VirtualSensorEvent(source);
        }

        public VirtualSensorEvent[] newArray(int size) {
            return new VirtualSensorEvent[size];
        }
    };

    private VirtualSensorEvent(float[] values, long timestampNanos) {
        this.mValues = values;
        this.mTimestampNanos = timestampNanos;
    }

    private VirtualSensorEvent(Parcel parcel) {
        int valuesLength = parcel.readInt();
        this.mValues = new float[valuesLength];
        parcel.readFloatArray(this.mValues);
        this.mTimestampNanos = parcel.readLong();
    }

    @Override
    public void writeToParcel(Parcel parcel, int parcelableFlags) {
        parcel.writeInt(this.mValues.length);
        parcel.writeFloatArray(this.mValues);
        parcel.writeLong(this.mTimestampNanos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public float[] getValues() {
        return this.mValues;
    }

    public long getTimestampNanos() {
        return this.mTimestampNanos;
    }

    public static class Builder {
        private float[] mValues;
        private long mTimestampNanos = 0L;

        public Builder(float[] values) {
            this.mValues = values;
        }

        public VirtualSensorEvent build() {
            if (this.mValues == null || this.mValues.length == 0) {
                throw new IllegalArgumentException("Cannot build virtual sensor event with no values.");
            }
            if (this.mTimestampNanos <= 0L) {
                this.mTimestampNanos = SystemClock.elapsedRealtimeNanos();
            }
            return new VirtualSensorEvent(this.mValues, this.mTimestampNanos);
        }

        public Builder setTimestampNanos(long timestampNanos) {
            this.mTimestampNanos = timestampNanos;
            return this;
        }
    }
}

