/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ClipDescription;
import android.content.ComponentCallbacks2;
import android.content.ContentInterface;
import android.content.ContentProviderNative;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.LoggingContentInterface;
import android.content.OperationApplicationException;
import android.content.PermissionChecker;
import android.content.pm.PackageManager;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ICancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.ParcelableException;
import android.os.Process;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FrameworkStatsLog;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public abstract class ContentProvider
implements ContentInterface,
ComponentCallbacks2 {
    private static final String TAG = "ContentProvider";
    @UnsupportedAppUsage
    private Context mContext = null;
    private int mMyUid;
    @UnsupportedAppUsage
    private String mAuthority;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private String[] mAuthorities;
    @UnsupportedAppUsage
    private String mReadPermission;
    @UnsupportedAppUsage
    private String mWritePermission;
    @UnsupportedAppUsage
    private PathPermission[] mPathPermissions;
    private boolean mExported;
    private boolean mNoPerms;
    private boolean mSingleUser;
    private SparseBooleanArray mUsersRedirectedToOwnerForMedia = new SparseBooleanArray();
    private ThreadLocal<AttributionSource> mCallingAttributionSource;
    private Transport mTransport = new Transport();

    public static boolean isAuthorityRedirectedForCloneProfile(String authority) {
        return "media".equals(authority);
    }

    public ContentProvider() {
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public ContentProvider(Context context, String readPermission, String writePermission, PathPermission[] pathPermissions) {
        this.mContext = context;
        this.mReadPermission = readPermission;
        this.mWritePermission = writePermission;
        this.mPathPermissions = pathPermissions;
    }

    @UnsupportedAppUsage
    public static ContentProvider coerceToLocalContentProvider(IContentProvider abstractInterface) {
        if (abstractInterface instanceof Transport) {
            return ((Transport)abstractInterface).getContentProvider();
        }
        return null;
    }

    boolean checkUser(int pid, int uid, Context context) {
        int callingUserId = UserHandle.getUserId(uid);
        if (callingUserId == context.getUserId() || this.mSingleUser) {
            return true;
        }
        if (context.checkPermission("android.permission.INTERACT_ACROSS_USERS", pid, uid) == 0 || context.checkPermission("android.permission.INTERACT_ACROSS_USERS_FULL", pid, uid) == 0) {
            return true;
        }
        return this.isContentRedirectionAllowedForUser(callingUserId);
    }

    private boolean isContentRedirectionAllowedForUser(int incomingUserId) {
        if ("media".equals(this.mAuthority)) {
            UserHandle parent;
            int incomingUserIdIndex = this.mUsersRedirectedToOwnerForMedia.indexOfKey(incomingUserId);
            if (incomingUserIdIndex >= 0) {
                return this.mUsersRedirectedToOwnerForMedia.valueAt(incomingUserIdIndex);
            }
            UserManager um = this.mContext.getSystemService(UserManager.class);
            if (um != null && um.getUserProperties(UserHandle.of(incomingUserId)).isMediaSharedWithParent() && (parent = um.getProfileParent(UserHandle.of(incomingUserId))) != null && parent.equals(Process.myUserHandle())) {
                this.mUsersRedirectedToOwnerForMedia.put(incomingUserId, true);
                return true;
            }
            this.mUsersRedirectedToOwnerForMedia.put(incomingUserId, false);
            return false;
        }
        return false;
    }

    private int checkPermission(String permission2, AttributionSource attributionSource) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return 0;
        }
        return PermissionChecker.checkPermissionForDataDeliveryFromDataSource(this.getContext(), permission2, -1, new AttributionSource(this.getContext().getAttributionSource(), attributionSource), null);
    }

    protected int enforceReadPermissionInner(Uri uri, AttributionSource attributionSource) throws SecurityException {
        Uri userUri;
        Context context = this.getContext();
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        String missingPerm = null;
        int strongestResult = 0;
        if (UserHandle.isSameApp(uid, this.mMyUid)) {
            return 0;
        }
        if (this.mExported && this.checkUser(pid, uid, context)) {
            String componentPerm = this.getReadPermission();
            if (componentPerm != null) {
                int result = this.checkPermission(componentPerm, attributionSource);
                if (result == 0) {
                    return 0;
                }
                missingPerm = componentPerm;
                strongestResult = Math.max(strongestResult, result);
            }
            boolean allowDefaultRead = componentPerm == null;
            PathPermission[] pps = this.getPathPermissions();
            if (pps != null) {
                String path = uri.getPath();
                for (PathPermission pp : pps) {
                    String pathPerm = pp.getReadPermission();
                    if (pathPerm == null || !pp.match(path)) continue;
                    int result = this.checkPermission(pathPerm, attributionSource);
                    if (result == 0) {
                        return 0;
                    }
                    allowDefaultRead = false;
                    missingPerm = pathPerm;
                    strongestResult = Math.max(strongestResult, result);
                }
            }
            if (allowDefaultRead) {
                return 0;
            }
        }
        int callingUserId = UserHandle.getUserId(uid);
        Uri uri2 = userUri = this.mSingleUser && !UserHandle.isSameUser(this.mMyUid, uid) ? ContentProvider.maybeAddUserId(uri, callingUserId) : uri;
        if (context.checkUriPermission(userUri, pid, uid, 1) == 0) {
            return 0;
        }
        if (strongestResult == 1) {
            return 1;
        }
        String suffix = "android.permission.MANAGE_DOCUMENTS".equals(this.mReadPermission) ? " requires that you obtain access using ACTION_OPEN_DOCUMENT or related APIs" : (this.mExported ? " requires " + missingPerm + ", or grantUriPermission()" : " requires the provider be exported, or grantUriPermission()");
        throw new SecurityException("Permission Denial: reading " + this.getClass().getName() + " uri " + uri + " from pid=" + pid + ", uid=" + uid + suffix);
    }

    protected int enforceWritePermissionInner(Uri uri, AttributionSource attributionSource) throws SecurityException {
        Context context = this.getContext();
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        String missingPerm = null;
        int strongestResult = 0;
        if (UserHandle.isSameApp(uid, this.mMyUid)) {
            return 0;
        }
        if (this.mExported && this.checkUser(pid, uid, context)) {
            String componentPerm = this.getWritePermission();
            if (componentPerm != null) {
                int mode = this.checkPermission(componentPerm, attributionSource);
                if (mode == 0) {
                    return 0;
                }
                missingPerm = componentPerm;
                strongestResult = Math.max(strongestResult, mode);
            }
            boolean allowDefaultWrite = componentPerm == null;
            PathPermission[] pps = this.getPathPermissions();
            if (pps != null) {
                String path = uri.getPath();
                for (PathPermission pp : pps) {
                    String pathPerm = pp.getWritePermission();
                    if (pathPerm == null || !pp.match(path)) continue;
                    int mode = this.checkPermission(pathPerm, attributionSource);
                    if (mode == 0) {
                        return 0;
                    }
                    allowDefaultWrite = false;
                    missingPerm = pathPerm;
                    strongestResult = Math.max(strongestResult, mode);
                }
            }
            if (allowDefaultWrite) {
                return 0;
            }
        }
        if (context.checkUriPermission(uri, pid, uid, 2) == 0) {
            return 0;
        }
        if (strongestResult == 1) {
            return 1;
        }
        String failReason = this.mExported ? " requires " + missingPerm + ", or grantUriPermission()" : " requires the provider be exported, or grantUriPermission()";
        throw new SecurityException("Permission Denial: writing " + this.getClass().getName() + " uri " + uri + " from pid=" + pid + ", uid=" + uid + failReason);
    }

    public Context getContext() {
        return this.mContext;
    }

    public Context requireContext() {
        Context ctx = this.getContext();
        if (ctx == null) {
            throw new IllegalStateException("Cannot find context from the provider.");
        }
        return ctx;
    }

    private AttributionSource setCallingAttributionSource(AttributionSource attributionSource) {
        AttributionSource original = this.mCallingAttributionSource.get();
        this.mCallingAttributionSource.set(attributionSource);
        this.onCallingPackageChanged();
        return original;
    }

    public String getCallingPackage() {
        AttributionSource callingAttributionSource = this.getCallingAttributionSource();
        return callingAttributionSource != null ? callingAttributionSource.getPackageName() : null;
    }

    public AttributionSource getCallingAttributionSource() {
        AttributionSource attributionSource = this.mCallingAttributionSource.get();
        if (attributionSource != null) {
            this.mTransport.mAppOpsManager.checkPackage(Binder.getCallingUid(), attributionSource.getPackageName());
        }
        return attributionSource;
    }

    public String getCallingAttributionTag() {
        AttributionSource attributionSource = this.mCallingAttributionSource.get();
        if (attributionSource != null) {
            return attributionSource.getAttributionTag();
        }
        return null;
    }

    @Deprecated
    public String getCallingFeatureId() {
        return this.getCallingAttributionTag();
    }

    public String getCallingPackageUnchecked() {
        AttributionSource attributionSource = this.mCallingAttributionSource.get();
        if (attributionSource != null) {
            return attributionSource.getPackageName();
        }
        return null;
    }

    public void onCallingPackageChanged() {
    }

    public CallingIdentity clearCallingIdentity() {
        return new CallingIdentity(Binder.clearCallingIdentity(), this.setCallingAttributionSource(null));
    }

    public void restoreCallingIdentity(CallingIdentity identity) {
        Binder.restoreCallingIdentity(identity.binderToken);
        this.mCallingAttributionSource.set(identity.callingAttributionSource);
    }

    protected void setAuthorities(String authorities) {
        if (authorities != null) {
            if (authorities.indexOf(59) == -1) {
                this.mAuthority = authorities;
                this.mAuthorities = null;
            } else {
                this.mAuthority = null;
                this.mAuthorities = authorities.split(";");
            }
        }
    }

    protected boolean matchesOurAuthorities(String authority) {
        if (this.mAuthority != null) {
            return this.mAuthority.equals(authority);
        }
        if (this.mAuthorities != null) {
            int length = this.mAuthorities.length;
            for (int i = 0; i < length; ++i) {
                if (!this.mAuthorities[i].equals(authority)) continue;
                return true;
            }
        }
        return false;
    }

    protected void setReadPermission(String permission2) {
        this.mReadPermission = permission2;
    }

    public String getReadPermission() {
        return this.mReadPermission;
    }

    protected void setWritePermission(String permission2) {
        this.mWritePermission = permission2;
    }

    public String getWritePermission() {
        return this.mWritePermission;
    }

    protected void setPathPermissions(PathPermission[] permissions) {
        this.mPathPermissions = permissions;
    }

    public PathPermission[] getPathPermissions() {
        return this.mPathPermissions;
    }

    @UnsupportedAppUsage
    public void setAppOps(int readOp, int writeOp) {
        if (!this.mNoPerms) {
            this.mTransport.mReadOp = readOp;
            this.mTransport.mWriteOp = writeOp;
        }
    }

    public AppOpsManager getAppOpsManager() {
        return this.mTransport.mAppOpsManager;
    }

    public void setTransportLoggingEnabled(boolean enabled) {
        if (this.mTransport == null) {
            return;
        }
        this.mTransport.mInterface = enabled ? new LoggingContentInterface(this.getClass().getSimpleName(), this) : this;
    }

    public abstract boolean onCreate();

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
    }

    @Override
    public void onLowMemory() {
    }

    @Override
    public void onTrimMemory(int level) {
    }

    public abstract Cursor query(Uri var1, String[] var2, String var3, String[] var4, String var5);

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        return this.query(uri, projection, selection, selectionArgs, sortOrder);
    }

    @Override
    public Cursor query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        String sortClause = (queryArgs = queryArgs != null ? queryArgs : Bundle.EMPTY).getString("android:query-arg-sql-sort-order");
        if (sortClause == null && queryArgs.containsKey("android:query-arg-sort-columns")) {
            sortClause = ContentResolver.createSqlSortClause(queryArgs);
        }
        return this.query(uri, projection, queryArgs.getString("android:query-arg-sql-selection"), queryArgs.getStringArray("android:query-arg-sql-selection-args"), sortClause, cancellationSignal);
    }

    @Override
    public abstract String getType(Uri var1);

    public String getTypeAnonymous(Uri uri) {
        return this.getType(uri);
    }

    @Override
    public Uri canonicalize(Uri url) {
        return null;
    }

    @Override
    public Uri uncanonicalize(Uri url) {
        return url;
    }

    @Override
    public boolean refresh(Uri uri, Bundle extras, CancellationSignal cancellationSignal) {
        return false;
    }

    @Override
    @SystemApi
    public int checkUriPermission(Uri uri, int uid, int modeFlags) {
        return -1;
    }

    public Uri rejectInsert(Uri uri, ContentValues values) {
        return uri.buildUpon().appendPath("0").build();
    }

    public abstract Uri insert(Uri var1, ContentValues var2);

    @Override
    public Uri insert(Uri uri, ContentValues values, Bundle extras) {
        return this.insert(uri, values);
    }

    @Override
    public int bulkInsert(Uri uri, ContentValues[] values) {
        int numValues = values.length;
        for (int i = 0; i < numValues; ++i) {
            this.insert(uri, values[i]);
        }
        return numValues;
    }

    public abstract int delete(Uri var1, String var2, String[] var3);

    @Override
    public int delete(Uri uri, Bundle extras) {
        extras = extras != null ? extras : Bundle.EMPTY;
        return this.delete(uri, extras.getString("android:query-arg-sql-selection"), extras.getStringArray("android:query-arg-sql-selection-args"));
    }

    public abstract int update(Uri var1, ContentValues var2, String var3, String[] var4);

    @Override
    public int update(Uri uri, ContentValues values, Bundle extras) {
        extras = extras != null ? extras : Bundle.EMPTY;
        return this.update(uri, values, extras.getString("android:query-arg-sql-selection"), extras.getStringArray("android:query-arg-sql-selection-args"));
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        throw new FileNotFoundException("No files supported by provider at " + uri);
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        return this.openFile(uri, mode);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        ParcelFileDescriptor fd = this.openFile(uri, mode);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        return this.openAssetFile(uri, mode);
    }

    protected ParcelFileDescriptor openFileHelper(Uri uri, String mode) throws FileNotFoundException {
        int count;
        Cursor c = this.query(uri, new String[]{"_data"}, null, null, null);
        int n = count = c != null ? c.getCount() : 0;
        if (count != 1) {
            if (c != null) {
                c.close();
            }
            if (count == 0) {
                throw new FileNotFoundException("No entry for " + uri);
            }
            throw new FileNotFoundException("Multiple items at " + uri);
        }
        c.moveToFirst();
        int i = c.getColumnIndex("_data");
        String path = i >= 0 ? c.getString(i) : null;
        c.close();
        if (path == null) {
            throw new FileNotFoundException("Column _data not found.");
        }
        int modeBits = ParcelFileDescriptor.parseMode(mode);
        return ParcelFileDescriptor.open(new File(path), modeBits);
    }

    @Override
    public String[] getStreamTypes(Uri uri, String mimeTypeFilter) {
        return null;
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        if ("*/*".equals(mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        String baseType = this.getType(uri);
        if (baseType != null && ClipDescription.compareMimeTypes(baseType, mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        throw new FileNotFoundException("Can't open " + uri + " as type " + mimeTypeFilter);
    }

    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        return this.openTypedAssetFile(uri, mimeTypeFilter, opts);
    }

    public <T> ParcelFileDescriptor openPipeHelper(final Uri uri, final String mimeType, final Bundle opts, final T args, final PipeDataWriter<T> func) throws FileNotFoundException {
        try {
            final ParcelFileDescriptor[] fds = ParcelFileDescriptor.createPipe();
            AsyncTask<Object, Object, Object> task = new AsyncTask<Object, Object, Object>(){

                @Override
                protected Object doInBackground(Object ... params) {
                    func.writeDataToPipe(fds[1], uri, mimeType, opts, args);
                    try {
                        fds[1].close();
                    }
                    catch (IOException e) {
                        Log.w(ContentProvider.TAG, "Failure closing pipe", e);
                    }
                    return null;
                }
            };
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
            return fds[0];
        }
        catch (IOException e) {
            throw new FileNotFoundException("failure making pipe");
        }
    }

    protected boolean isTemporary() {
        return false;
    }

    @UnsupportedAppUsage
    public IContentProvider getIContentProvider() {
        return this.mTransport;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void attachInfoForTesting(Context context, ProviderInfo info) {
        this.attachInfo(context, info, true);
    }

    public void attachInfo(Context context, ProviderInfo info) {
        this.attachInfo(context, info, false);
    }

    private void attachInfo(Context context, ProviderInfo info, boolean testing) {
        this.mNoPerms = testing;
        this.mCallingAttributionSource = new ThreadLocal();
        if (this.mContext == null) {
            this.mContext = context;
            if (context != null && this.mTransport != null) {
                this.mTransport.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
            }
            this.mMyUid = Process.myUid();
            if (info != null) {
                this.setReadPermission(info.readPermission);
                this.setWritePermission(info.writePermission);
                this.setPathPermissions(info.pathPermissions);
                this.mExported = info.exported;
                this.mSingleUser = (info.flags & 0x40000000) != 0;
                this.setAuthorities(info.authority);
            }
            if (_Original_Build.IS_DEBUGGABLE) {
                this.setTransportLoggingEnabled(Log.isLoggable(this.getClass().getSimpleName(), 2));
            }
            this.onCreate();
        }
    }

    @Override
    public ContentProviderResult[] applyBatch(String authority, ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        return this.applyBatch(operations);
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        int numOperations = operations.size();
        ContentProviderResult[] results = new ContentProviderResult[numOperations];
        for (int i = 0; i < numOperations; ++i) {
            results[i] = operations.get(i).apply(this, results, i);
        }
        return results;
    }

    @Override
    public Bundle call(String authority, String method, String arg, Bundle extras) {
        return this.call(method, arg, extras);
    }

    public Bundle call(String method, String arg, Bundle extras) {
        return null;
    }

    public void shutdown() {
        Log.w(TAG, "implement ContentProvider shutdown() to make sure all database connections are gracefully shutdown");
    }

    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.println("nothing to dump");
    }

    private void validateIncomingAuthority(String authority) throws SecurityException {
        if (!this.matchesOurAuthorities(ContentProvider.getAuthorityWithoutUserId(authority))) {
            String message = "The authority " + authority + " does not match the one of the contentProvider: ";
            message = this.mAuthority != null ? message + this.mAuthority : message + Arrays.toString(this.mAuthorities);
            throw new SecurityException(message);
        }
    }

    @VisibleForTesting
    public Uri validateIncomingUri(Uri uri) throws SecurityException {
        int userId;
        String auth = uri.getAuthority();
        if (!this.mSingleUser && (userId = ContentProvider.getUserIdFromAuthority(auth, -2)) != -2 && userId != this.mContext.getUserId() && !this.isContentRedirectionAllowedForUser(userId)) {
            throw new SecurityException("trying to query a ContentProvider in user " + this.mContext.getUserId() + " with a uri belonging to user " + userId);
        }
        this.validateIncomingAuthority(auth);
        String encodedPath = uri.getEncodedPath();
        if (encodedPath != null && encodedPath.indexOf("//") != -1) {
            Uri normalized = uri.buildUpon().encodedPath(encodedPath.replaceAll("//+", "/")).build();
            Log.w(TAG, "Normalized " + uri + " to " + normalized + " to avoid possible security issues");
            return normalized;
        }
        return uri;
    }

    private Uri maybeGetUriWithoutUserId(Uri uri) {
        if (this.mSingleUser) {
            return uri;
        }
        return ContentProvider.getUriWithoutUserId(uri);
    }

    public static int getUserIdFromAuthority(String auth, int defaultUserId) {
        if (auth == null) {
            return defaultUserId;
        }
        int end = auth.lastIndexOf(64);
        if (end == -1) {
            return defaultUserId;
        }
        String userIdString = auth.substring(0, end);
        try {
            return Integer.parseInt(userIdString);
        }
        catch (NumberFormatException e) {
            Log.w(TAG, "Error parsing userId.", e);
            return -10000;
        }
    }

    public static int getUserIdFromAuthority(String auth) {
        return ContentProvider.getUserIdFromAuthority(auth, -2);
    }

    public static int getUserIdFromUri(Uri uri, int defaultUserId) {
        if (uri == null) {
            return defaultUserId;
        }
        return ContentProvider.getUserIdFromAuthority(uri.getAuthority(), defaultUserId);
    }

    public static int getUserIdFromUri(Uri uri) {
        return ContentProvider.getUserIdFromUri(uri, -2);
    }

    public static UserHandle getUserHandleFromUri(Uri uri) {
        return UserHandle.of(ContentProvider.getUserIdFromUri(uri, Process.myUserHandle().getIdentifier()));
    }

    public static String getAuthorityWithoutUserId(String auth) {
        if (auth == null) {
            return null;
        }
        int end = auth.lastIndexOf(64);
        return auth.substring(end + 1);
    }

    public static Uri getUriWithoutUserId(Uri uri) {
        if (uri == null) {
            return null;
        }
        Uri.Builder builder = uri.buildUpon();
        builder.authority(ContentProvider.getAuthorityWithoutUserId(uri.getAuthority()));
        return builder.build();
    }

    public static boolean uriHasUserId(Uri uri) {
        if (uri == null) {
            return false;
        }
        return !TextUtils.isEmpty(uri.getUserInfo());
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static Uri createContentUriForUser(Uri contentUri, UserHandle userHandle) {
        if (!"content".equals(contentUri.getScheme())) {
            throw new IllegalArgumentException(String.format("Given URI [%s] is not a content URI: ", contentUri));
        }
        int userId = userHandle.getIdentifier();
        if (ContentProvider.uriHasUserId(contentUri)) {
            if (String.valueOf(userId).equals(contentUri.getUserInfo())) {
                return contentUri;
            }
            throw new IllegalArgumentException(String.format("Given URI [%s] already has a user ID, different from given user handle [%s]", contentUri, userId));
        }
        Uri.Builder builder = contentUri.buildUpon();
        builder.encodedAuthority("" + userHandle.getIdentifier() + "@" + contentUri.getEncodedAuthority());
        return builder.build();
    }

    @UnsupportedAppUsage
    public static Uri maybeAddUserId(Uri uri, int userId) {
        if (uri == null) {
            return null;
        }
        if (userId != -2 && "content".equals(uri.getScheme()) && !ContentProvider.uriHasUserId(uri)) {
            Uri.Builder builder = uri.buildUpon();
            builder.encodedAuthority("" + userId + "@" + uri.getEncodedAuthority());
            return builder.build();
        }
        return uri;
    }

    private static void traceBegin(long traceTag, String methodName, String subInfo) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.traceBegin(traceTag, methodName + subInfo);
        }
    }

    class Transport
    extends ContentProviderNative {
        volatile AppOpsManager mAppOpsManager = null;
        volatile int mReadOp = -1;
        volatile int mWriteOp = -1;
        volatile ContentInterface mInterface = ContentProvider.this;

        Transport() {
        }

        ContentProvider getContentProvider() {
            return ContentProvider.this;
        }

        @Override
        public String getProviderName() {
            return this.getContentProvider().getClass().getName();
        }

        @Override
        public Cursor query(AttributionSource attributionSource, Uri uri, String[] projection, Bundle queryArgs, ICancellationSignal cancellationSignal) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            if (this.enforceReadPermission(attributionSource, uri = ContentProvider.this.maybeGetUriWithoutUserId(uri)) != 0) {
                Cursor cursor;
                if (projection != null) {
                    return new MatrixCursor(projection, 0);
                }
                AttributionSource original2 = ContentProvider.this.setCallingAttributionSource(attributionSource);
                try {
                    cursor = this.mInterface.query(uri, projection, queryArgs, CancellationSignal.fromTransport(cancellationSignal));
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                finally {
                    ContentProvider.this.setCallingAttributionSource(original2);
                }
                if (cursor == null) {
                    return null;
                }
                return new MatrixCursor(cursor.getColumnNames(), 0);
            }
            ContentProvider.traceBegin(0x100000L, "query: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                Cursor original2 = this.mInterface.query(uri, projection, queryArgs, CancellationSignal.fromTransport(cancellationSignal));
                return original2;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getType(AttributionSource attributionSource, Uri uri) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            uri = ContentProvider.this.maybeGetUriWithoutUserId(uri);
            ContentProvider.traceBegin(0x100000L, "getType: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                if (this.checkGetTypePermission(attributionSource, uri) == 0) {
                    String type;
                    Object origId;
                    if (ContentProvider.this.checkPermission("android.permission.GET_ANY_PROVIDER_TYPE", attributionSource) == 0) {
                        origId = this.getContentProvider().clearCallingIdentity();
                        try {
                            type = this.mInterface.getType(uri);
                        }
                        finally {
                            this.getContentProvider().restoreCallingIdentity((CallingIdentity)origId);
                        }
                    } else {
                        type = this.mInterface.getType(uri);
                    }
                    if (type != null) {
                        this.logGetTypeData(Binder.getCallingUid(), uri, type, true);
                    }
                    origId = type;
                    return origId;
                }
                int callingUid = Binder.getCallingUid();
                CallingIdentity origId = this.getContentProvider().clearCallingIdentity();
                try {
                    String type = ContentProvider.this.getTypeAnonymous(uri);
                    if (type != null) {
                        this.logGetTypeData(callingUid, uri, type, false);
                    }
                    String string2 = type;
                    this.getContentProvider().restoreCallingIdentity(origId);
                    return string2;
                }
                catch (Throwable throwable) {
                    try {
                        this.getContentProvider().restoreCallingIdentity(origId);
                        throw throwable;
                    }
                    catch (RemoteException e) {
                        throw e.rethrowAsRuntimeException();
                    }
                }
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        private void logGetTypeData(int callingUid, Uri uri, String type, boolean permissionCheckPassed) {
            int enumFrameworkPermission = 4;
            int enumCheckUriPermission = 5;
            if (permissionCheckPassed) {
                try {
                    Uri userUri;
                    ProviderInfo cpi = ContentProvider.this.mContext.getPackageManager().resolveContentProvider(uri.getAuthority(), PackageManager.ComponentInfoFlags.of(128L));
                    int callingUserId = UserHandle.getUserId(callingUid);
                    Uri uri2 = userUri = ContentProvider.this.mSingleUser && !UserHandle.isSameUser(ContentProvider.this.mMyUid, callingUid) ? ContentProvider.maybeAddUserId(uri, callingUserId) : uri;
                    if (cpi.forceUriPermissions && this.mInterface.checkUriPermission(uri, callingUid, 1) != 0 && ContentProvider.this.getContext().checkUriPermission(userUri, Binder.getCallingPid(), callingUid, 1) != 0) {
                        FrameworkStatsLog.write(564, 5, callingUid, uri.getAuthority(), type);
                    }
                }
                catch (Exception exception) {}
            } else {
                FrameworkStatsLog.write(564, 4, callingUid, uri.getAuthority(), type);
            }
        }

        @Override
        public void getTypeAsync(AttributionSource attributionSource, Uri uri, RemoteCallback callback) {
            Bundle result = new Bundle();
            try {
                result.putString("result", this.getType(attributionSource, uri));
            }
            catch (Exception e) {
                result.putParcelable("error", new ParcelableException(e));
            }
            callback.sendResult(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getTypeAnonymousAsync(Uri uri, RemoteCallback callback) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            uri = ContentProvider.this.maybeGetUriWithoutUserId(uri);
            ContentProvider.traceBegin(0x100000L, "getTypeAnonymous: ", uri.getAuthority());
            Bundle result = new Bundle();
            try {
                result.putString("result", ContentProvider.this.getTypeAnonymous(uri));
            }
            catch (Exception e) {
                result.putParcelable("error", new ParcelableException(e));
            }
            finally {
                callback.sendResult(result);
                Trace.traceEnd(0x100000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Uri insert(AttributionSource attributionSource, Uri uri, ContentValues initialValues, Bundle extras) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            int userId = ContentProvider.getUserIdFromUri(uri);
            if (this.enforceWritePermission(attributionSource, uri = ContentProvider.this.maybeGetUriWithoutUserId(uri)) != 0) {
                AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
                try {
                    Uri uri2 = ContentProvider.this.rejectInsert(uri, initialValues);
                    return uri2;
                }
                finally {
                    ContentProvider.this.setCallingAttributionSource(original);
                }
            }
            ContentProvider.traceBegin(0x100000L, "insert: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                Uri uri3 = ContentProvider.maybeAddUserId(this.mInterface.insert(uri, initialValues, extras), userId);
                return uri3;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public int bulkInsert(AttributionSource attributionSource, Uri uri, ContentValues[] initialValues) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            if (this.enforceWritePermission(attributionSource, uri = ContentProvider.this.maybeGetUriWithoutUserId(uri)) != 0) {
                return 0;
            }
            ContentProvider.traceBegin(0x100000L, "bulkInsert: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                int n = this.mInterface.bulkInsert(uri, initialValues);
                return n;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public ContentProviderResult[] applyBatch(AttributionSource attributionSource, String authority, ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
            ContentProvider.this.validateIncomingAuthority(authority);
            int numOperations = operations.size();
            int[] userIds = new int[numOperations];
            for (int i = 0; i < numOperations; ++i) {
                ContentProviderOperation operation = operations.get(i);
                Uri uri = operation.getUri();
                userIds[i] = ContentProvider.getUserIdFromUri(uri);
                uri = ContentProvider.this.validateIncomingUri(uri);
                uri = ContentProvider.this.maybeGetUriWithoutUserId(uri);
                if (!Objects.equals(operation.getUri(), uri)) {
                    operation = new ContentProviderOperation(operation, uri);
                    operations.set(i, operation);
                }
                AttributionSource accessAttributionSource = attributionSource;
                if (operation.isReadOperation() && this.enforceReadPermission(accessAttributionSource, uri) != 0) {
                    throw new OperationApplicationException("App op not allowed", 0);
                }
                if (!operation.isWriteOperation() || this.enforceWritePermission(accessAttributionSource, uri) == 0) continue;
                throw new OperationApplicationException("App op not allowed", 0);
            }
            ContentProvider.traceBegin(0x100000L, "applyBatch: ", authority);
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                ContentProviderResult[] results = this.mInterface.applyBatch(authority, operations);
                if (results != null) {
                    for (int i = 0; i < results.length; ++i) {
                        if (userIds[i] == -2) continue;
                        results[i] = new ContentProviderResult(results[i], userIds[i]);
                    }
                }
                ContentProviderResult[] contentProviderResultArray = results;
                return contentProviderResultArray;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public int delete(AttributionSource attributionSource, Uri uri, Bundle extras) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            if (this.enforceWritePermission(attributionSource, uri = ContentProvider.this.maybeGetUriWithoutUserId(uri)) != 0) {
                return 0;
            }
            ContentProvider.traceBegin(0x100000L, "delete: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                int n = this.mInterface.delete(uri, extras);
                return n;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public int update(AttributionSource attributionSource, Uri uri, ContentValues values, Bundle extras) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            if (this.enforceWritePermission(attributionSource, uri = ContentProvider.this.maybeGetUriWithoutUserId(uri)) != 0) {
                return 0;
            }
            ContentProvider.traceBegin(0x100000L, "update: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                int n = this.mInterface.update(uri, values, extras);
                return n;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public ParcelFileDescriptor openFile(AttributionSource attributionSource, Uri uri, String mode, ICancellationSignal cancellationSignal) throws FileNotFoundException {
            uri = ContentProvider.this.validateIncomingUri(uri);
            uri = ContentProvider.this.maybeGetUriWithoutUserId(uri);
            this.enforceFilePermission(attributionSource, uri, mode);
            ContentProvider.traceBegin(0x100000L, "openFile: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                ParcelFileDescriptor parcelFileDescriptor = this.mInterface.openFile(uri, mode, CancellationSignal.fromTransport(cancellationSignal));
                return parcelFileDescriptor;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public AssetFileDescriptor openAssetFile(AttributionSource attributionSource, Uri uri, String mode, ICancellationSignal cancellationSignal) throws FileNotFoundException {
            uri = ContentProvider.this.validateIncomingUri(uri);
            uri = ContentProvider.this.maybeGetUriWithoutUserId(uri);
            this.enforceFilePermission(attributionSource, uri, mode);
            ContentProvider.traceBegin(0x100000L, "openAssetFile: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                AssetFileDescriptor assetFileDescriptor = this.mInterface.openAssetFile(uri, mode, CancellationSignal.fromTransport(cancellationSignal));
                return assetFileDescriptor;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public Bundle call(AttributionSource attributionSource, String authority, String method, String arg, Bundle extras) {
            ContentProvider.this.validateIncomingAuthority(authority);
            Bundle.setDefusable(extras, true);
            ContentProvider.traceBegin(0x100000L, "call: ", authority);
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                Bundle bundle = this.mInterface.call(authority, method, arg, extras);
                return bundle;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public String[] getStreamTypes(AttributionSource attributionSource, Uri uri, String mimeTypeFilter) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            uri = ContentProvider.this.maybeGetUriWithoutUserId(uri);
            ContentProvider.traceBegin(0x100000L, "getStreamTypes: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                String[] stringArray = this.mInterface.getStreamTypes(uri, mimeTypeFilter);
                return stringArray;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public AssetFileDescriptor openTypedAssetFile(AttributionSource attributionSource, Uri uri, String mimeType, Bundle opts, ICancellationSignal cancellationSignal) throws FileNotFoundException {
            Bundle.setDefusable(opts, true);
            uri = ContentProvider.this.validateIncomingUri(uri);
            uri = ContentProvider.this.maybeGetUriWithoutUserId(uri);
            this.enforceFilePermission(attributionSource, uri, "r");
            ContentProvider.traceBegin(0x100000L, "openTypedAssetFile: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                AssetFileDescriptor assetFileDescriptor = this.mInterface.openTypedAssetFile(uri, mimeType, opts, CancellationSignal.fromTransport(cancellationSignal));
                return assetFileDescriptor;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public ICancellationSignal createCancellationSignal() {
            return CancellationSignal.createTransport();
        }

        @Override
        public Uri canonicalize(AttributionSource attributionSource, Uri uri) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            int userId = ContentProvider.getUserIdFromUri(uri);
            if (this.enforceReadPermission(attributionSource, uri = ContentProvider.getUriWithoutUserId(uri)) != 0) {
                return null;
            }
            ContentProvider.traceBegin(0x100000L, "canonicalize: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                Uri uri2 = ContentProvider.maybeAddUserId(this.mInterface.canonicalize(uri), userId);
                return uri2;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public void canonicalizeAsync(AttributionSource attributionSource, Uri uri, RemoteCallback callback) {
            Bundle result = new Bundle();
            try {
                result.putParcelable("result", this.canonicalize(attributionSource, uri));
            }
            catch (Exception e) {
                result.putParcelable("error", new ParcelableException(e));
            }
            callback.sendResult(result);
        }

        @Override
        public Uri uncanonicalize(AttributionSource attributionSource, Uri uri) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            int userId = ContentProvider.getUserIdFromUri(uri);
            if (this.enforceReadPermission(attributionSource, uri = ContentProvider.getUriWithoutUserId(uri)) != 0) {
                return null;
            }
            ContentProvider.traceBegin(0x100000L, "uncanonicalize: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                Uri uri2 = ContentProvider.maybeAddUserId(this.mInterface.uncanonicalize(uri), userId);
                return uri2;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public void uncanonicalizeAsync(AttributionSource attributionSource, Uri uri, RemoteCallback callback) {
            Bundle result = new Bundle();
            try {
                result.putParcelable("result", this.uncanonicalize(attributionSource, uri));
            }
            catch (Exception e) {
                result.putParcelable("error", new ParcelableException(e));
            }
            callback.sendResult(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean refresh(AttributionSource attributionSource, Uri uri, Bundle extras, ICancellationSignal cancellationSignal) throws RemoteException {
            uri = ContentProvider.this.validateIncomingUri(uri);
            if (this.enforceReadPermission(attributionSource, uri = ContentProvider.getUriWithoutUserId(uri)) != 0) {
                return false;
            }
            ContentProvider.traceBegin(0x100000L, "refresh: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                boolean bl = this.mInterface.refresh(uri, extras, CancellationSignal.fromTransport(cancellationSignal));
                return bl;
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        @Override
        public int checkUriPermission(AttributionSource attributionSource, Uri uri, int uid, int modeFlags) {
            uri = ContentProvider.this.validateIncomingUri(uri);
            uri = ContentProvider.this.maybeGetUriWithoutUserId(uri);
            ContentProvider.traceBegin(0x100000L, "checkUriPermission: ", uri.getAuthority());
            AttributionSource original = ContentProvider.this.setCallingAttributionSource(attributionSource);
            try {
                int n = this.mInterface.checkUriPermission(uri, uid, modeFlags);
                return n;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            finally {
                ContentProvider.this.setCallingAttributionSource(original);
                Trace.traceEnd(0x100000L);
            }
        }

        private void enforceFilePermission(AttributionSource attributionSource, Uri uri, String mode) throws FileNotFoundException, SecurityException {
            if (mode != null && mode.indexOf(119) != -1 ? this.enforceWritePermission(attributionSource, uri) != 0 : this.enforceReadPermission(attributionSource, uri) != 0) {
                throw new FileNotFoundException("App op not allowed");
            }
        }

        private int enforceReadPermission(AttributionSource attributionSource, Uri uri) throws SecurityException {
            int result = ContentProvider.this.enforceReadPermissionInner(uri, attributionSource);
            if (result != 0) {
                return result;
            }
            if (ContentProvider.this.mTransport.mReadOp != -1 && ContentProvider.this.mTransport.mReadOp != AppOpsManager.permissionToOpCode(ContentProvider.this.mReadPermission)) {
                return PermissionChecker.checkOpForDataDelivery(ContentProvider.this.getContext(), AppOpsManager.opToPublicName(ContentProvider.this.mTransport.mReadOp), attributionSource, null);
            }
            return 0;
        }

        private int enforceWritePermission(AttributionSource attributionSource, Uri uri) throws SecurityException {
            int result = ContentProvider.this.enforceWritePermissionInner(uri, attributionSource);
            if (result != 0) {
                return result;
            }
            if (ContentProvider.this.mTransport.mWriteOp != -1 && ContentProvider.this.mTransport.mWriteOp != AppOpsManager.permissionToOpCode(ContentProvider.this.mWritePermission)) {
                return PermissionChecker.checkOpForDataDelivery(ContentProvider.this.getContext(), AppOpsManager.opToPublicName(ContentProvider.this.mTransport.mWriteOp), attributionSource, null);
            }
            return 0;
        }

        private int checkGetTypePermission(AttributionSource attributionSource, Uri uri) {
            int callingUid = Binder.getCallingUid();
            if (UserHandle.getAppId(callingUid) == 1000 || ContentProvider.this.checkPermission("android.permission.GET_ANY_PROVIDER_TYPE", attributionSource) == 0) {
                return 0;
            }
            try {
                return this.enforceReadPermission(attributionSource, uri);
            }
            catch (SecurityException e) {
                return 2;
            }
        }
    }

    public class CallingIdentity {
        public final long binderToken;
        public final AttributionSource callingAttributionSource;

        public CallingIdentity(long binderToken, AttributionSource attributionSource) {
            this.binderToken = binderToken;
            this.callingAttributionSource = attributionSource;
        }
    }

    public static interface PipeDataWriter<T> {
        public void writeDataToPipe(ParcelFileDescriptor var1, Uri var2, String var3, Bundle var4, T var5);
    }
}

