/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.IOnPrimaryClipChangedListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IClipboard
extends IInterface {
    public void setPrimaryClip(ClipData var1, String var2, String var3, int var4, int var5) throws RemoteException;

    public void setPrimaryClipAsPackage(ClipData var1, String var2, String var3, int var4, int var5, String var6) throws RemoteException;

    public void clearPrimaryClip(String var1, String var2, int var3, int var4) throws RemoteException;

    public ClipData getPrimaryClip(String var1, String var2, int var3, int var4) throws RemoteException;

    public ClipDescription getPrimaryClipDescription(String var1, String var2, int var3, int var4) throws RemoteException;

    public boolean hasPrimaryClip(String var1, String var2, int var3, int var4) throws RemoteException;

    public void addPrimaryClipChangedListener(IOnPrimaryClipChangedListener var1, String var2, String var3, int var4, int var5) throws RemoteException;

    public void removePrimaryClipChangedListener(IOnPrimaryClipChangedListener var1, String var2, String var3, int var4, int var5) throws RemoteException;

    public boolean hasClipboardText(String var1, String var2, int var3, int var4) throws RemoteException;

    public String getPrimaryClipSource(String var1, String var2, int var3, int var4) throws RemoteException;

    public boolean areClipboardAccessNotificationsEnabledForUser(int var1) throws RemoteException;

    public void setClipboardAccessNotificationsEnabledForUser(boolean var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IClipboard {
        public static final String DESCRIPTOR = "android.content.IClipboard";
        static final int TRANSACTION_setPrimaryClip = 1;
        static final int TRANSACTION_setPrimaryClipAsPackage = 2;
        static final int TRANSACTION_clearPrimaryClip = 3;
        static final int TRANSACTION_getPrimaryClip = 4;
        static final int TRANSACTION_getPrimaryClipDescription = 5;
        static final int TRANSACTION_hasPrimaryClip = 6;
        static final int TRANSACTION_addPrimaryClipChangedListener = 7;
        static final int TRANSACTION_removePrimaryClipChangedListener = 8;
        static final int TRANSACTION_hasClipboardText = 9;
        static final int TRANSACTION_getPrimaryClipSource = 10;
        static final int TRANSACTION_areClipboardAccessNotificationsEnabledForUser = 11;
        static final int TRANSACTION_setClipboardAccessNotificationsEnabledForUser = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IClipboard asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IClipboard) {
                return (IClipboard)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setPrimaryClip";
                }
                case 2: {
                    return "setPrimaryClipAsPackage";
                }
                case 3: {
                    return "clearPrimaryClip";
                }
                case 4: {
                    return "getPrimaryClip";
                }
                case 5: {
                    return "getPrimaryClipDescription";
                }
                case 6: {
                    return "hasPrimaryClip";
                }
                case 7: {
                    return "addPrimaryClipChangedListener";
                }
                case 8: {
                    return "removePrimaryClipChangedListener";
                }
                case 9: {
                    return "hasClipboardText";
                }
                case 10: {
                    return "getPrimaryClipSource";
                }
                case 11: {
                    return "areClipboardAccessNotificationsEnabledForUser";
                }
                case 12: {
                    return "setClipboardAccessNotificationsEnabledForUser";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ClipData _arg0 = data.readTypedObject(ClipData.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setPrimaryClip(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    ClipData _arg0 = data.readTypedObject(ClipData.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    this.setPrimaryClipAsPackage(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearPrimaryClip(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    ClipData _result = this.getPrimaryClip(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    ClipDescription _result = this.getPrimaryClipDescription(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasPrimaryClip(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    IOnPrimaryClipChangedListener _arg0 = IOnPrimaryClipChangedListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addPrimaryClipChangedListener(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IOnPrimaryClipChangedListener _arg0 = IOnPrimaryClipChangedListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removePrimaryClipChangedListener(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasClipboardText(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getPrimaryClipSource(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.areClipboardAccessNotificationsEnabledForUser(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setClipboardAccessNotificationsEnabledForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IClipboard {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrimaryClip(ClipData clip, String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(clip, 0);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPrimaryClipAsPackage(ClipData clip, String callingPackage, String attributionTag, int userId, int deviceId, String sourcePackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(clip, 0);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    _data.writeString(sourcePackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearPrimaryClip(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClipData getPrimaryClip(String pkg, String attributionTag, int userId, int deviceId) throws RemoteException {
                ClipData _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkg);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ClipData.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClipDescription getPrimaryClipDescription(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
                ClipDescription _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ClipDescription.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasPrimaryClip(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPrimaryClipChangedListener(IOnPrimaryClipChangedListener listener, String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePrimaryClipChangedListener(IOnPrimaryClipChangedListener listener, String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasClipboardText(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPrimaryClipSource(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(attributionTag);
                    _data.writeInt(userId);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areClipboardAccessNotificationsEnabledForUser(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setClipboardAccessNotificationsEnabledForUser(boolean enable, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IClipboard {
        @Override
        public void setPrimaryClip(ClipData clip, String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
        }

        @Override
        public void setPrimaryClipAsPackage(ClipData clip, String callingPackage, String attributionTag, int userId, int deviceId, String sourcePackage) throws RemoteException {
        }

        @Override
        public void clearPrimaryClip(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
        }

        @Override
        public ClipData getPrimaryClip(String pkg, String attributionTag, int userId, int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public ClipDescription getPrimaryClipDescription(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean hasPrimaryClip(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
            return false;
        }

        @Override
        public void addPrimaryClipChangedListener(IOnPrimaryClipChangedListener listener, String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
        }

        @Override
        public void removePrimaryClipChangedListener(IOnPrimaryClipChangedListener listener, String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
        }

        @Override
        public boolean hasClipboardText(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
            return false;
        }

        @Override
        public String getPrimaryClipSource(String callingPackage, String attributionTag, int userId, int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean areClipboardAccessNotificationsEnabledForUser(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setClipboardAccessNotificationsEnabledForUser(boolean enable, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

