/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.ISyncStatusObserver;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncRequest;
import android.content.SyncStatusInfo;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IContentService
extends IInterface {
    public void unregisterContentObserver(IContentObserver var1) throws RemoteException;

    public void registerContentObserver(Uri var1, boolean var2, IContentObserver var3, int var4, int var5) throws RemoteException;

    public void notifyChange(Uri[] var1, IContentObserver var2, boolean var3, int var4, int var5, int var6, String var7) throws RemoteException;

    public void requestSync(Account var1, String var2, Bundle var3, String var4) throws RemoteException;

    public void sync(SyncRequest var1, String var2) throws RemoteException;

    public void syncAsUser(SyncRequest var1, int var2, String var3) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/content/IContentService.aidl:64:1:64:69")
    public void cancelSync(Account var1, String var2, ComponentName var3) throws RemoteException;

    public void cancelSyncAsUser(Account var1, String var2, ComponentName var3, int var4) throws RemoteException;

    public void cancelRequest(SyncRequest var1) throws RemoteException;

    public boolean getSyncAutomatically(Account var1, String var2) throws RemoteException;

    public boolean getSyncAutomaticallyAsUser(Account var1, String var2, int var3) throws RemoteException;

    public void setSyncAutomatically(Account var1, String var2, boolean var3) throws RemoteException;

    public void setSyncAutomaticallyAsUser(Account var1, String var2, boolean var3, int var4) throws RemoteException;

    public List<PeriodicSync> getPeriodicSyncs(Account var1, String var2, ComponentName var3) throws RemoteException;

    public void addPeriodicSync(Account var1, String var2, Bundle var3, long var4) throws RemoteException;

    public void removePeriodicSync(Account var1, String var2, Bundle var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/content/IContentService.aidl:122:1:122:25")
    public int getIsSyncable(Account var1, String var2) throws RemoteException;

    public int getIsSyncableAsUser(Account var1, String var2, int var3) throws RemoteException;

    public void setIsSyncable(Account var1, String var2, int var3) throws RemoteException;

    public void setIsSyncableAsUser(Account var1, String var2, int var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/content/IContentService.aidl:133:1:133:25")
    public void setMasterSyncAutomatically(boolean var1) throws RemoteException;

    public void setMasterSyncAutomaticallyAsUser(boolean var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/content/IContentService.aidl:137:1:137:25")
    public boolean getMasterSyncAutomatically() throws RemoteException;

    public boolean getMasterSyncAutomaticallyAsUser(int var1) throws RemoteException;

    public List<SyncInfo> getCurrentSyncs() throws RemoteException;

    public List<SyncInfo> getCurrentSyncsAsUser(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/content/IContentService.aidl:148:1:148:25")
    public SyncAdapterType[] getSyncAdapterTypes() throws RemoteException;

    public SyncAdapterType[] getSyncAdapterTypesAsUser(int var1) throws RemoteException;

    public String[] getSyncAdapterPackagesForAuthorityAsUser(String var1, int var2) throws RemoteException;

    public String getSyncAdapterPackageAsUser(String var1, String var2, int var3) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/content/IContentService.aidl:163:1:163:69")
    public boolean isSyncActive(Account var1, String var2, ComponentName var3) throws RemoteException;

    public SyncStatusInfo getSyncStatus(Account var1, String var2, ComponentName var3) throws RemoteException;

    public SyncStatusInfo getSyncStatusAsUser(Account var1, String var2, ComponentName var3, int var4) throws RemoteException;

    public boolean isSyncPending(Account var1, String var2, ComponentName var3) throws RemoteException;

    public boolean isSyncPendingAsUser(Account var1, String var2, ComponentName var3, int var4) throws RemoteException;

    public void addStatusChangeListener(int var1, ISyncStatusObserver var2) throws RemoteException;

    public void removeStatusChangeListener(ISyncStatusObserver var1) throws RemoteException;

    public void putCache(String var1, Uri var2, Bundle var3, int var4) throws RemoteException;

    public Bundle getCache(String var1, Uri var2, int var3) throws RemoteException;

    public void resetTodayStats() throws RemoteException;

    public void onDbCorruption(String var1, String var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContentService {
        public static final String DESCRIPTOR = "android.content.IContentService";
        static final int TRANSACTION_unregisterContentObserver = 1;
        static final int TRANSACTION_registerContentObserver = 2;
        static final int TRANSACTION_notifyChange = 3;
        static final int TRANSACTION_requestSync = 4;
        static final int TRANSACTION_sync = 5;
        static final int TRANSACTION_syncAsUser = 6;
        static final int TRANSACTION_cancelSync = 7;
        static final int TRANSACTION_cancelSyncAsUser = 8;
        static final int TRANSACTION_cancelRequest = 9;
        static final int TRANSACTION_getSyncAutomatically = 10;
        static final int TRANSACTION_getSyncAutomaticallyAsUser = 11;
        static final int TRANSACTION_setSyncAutomatically = 12;
        static final int TRANSACTION_setSyncAutomaticallyAsUser = 13;
        static final int TRANSACTION_getPeriodicSyncs = 14;
        static final int TRANSACTION_addPeriodicSync = 15;
        static final int TRANSACTION_removePeriodicSync = 16;
        static final int TRANSACTION_getIsSyncable = 17;
        static final int TRANSACTION_getIsSyncableAsUser = 18;
        static final int TRANSACTION_setIsSyncable = 19;
        static final int TRANSACTION_setIsSyncableAsUser = 20;
        static final int TRANSACTION_setMasterSyncAutomatically = 21;
        static final int TRANSACTION_setMasterSyncAutomaticallyAsUser = 22;
        static final int TRANSACTION_getMasterSyncAutomatically = 23;
        static final int TRANSACTION_getMasterSyncAutomaticallyAsUser = 24;
        static final int TRANSACTION_getCurrentSyncs = 25;
        static final int TRANSACTION_getCurrentSyncsAsUser = 26;
        static final int TRANSACTION_getSyncAdapterTypes = 27;
        static final int TRANSACTION_getSyncAdapterTypesAsUser = 28;
        static final int TRANSACTION_getSyncAdapterPackagesForAuthorityAsUser = 29;
        static final int TRANSACTION_getSyncAdapterPackageAsUser = 30;
        static final int TRANSACTION_isSyncActive = 31;
        static final int TRANSACTION_getSyncStatus = 32;
        static final int TRANSACTION_getSyncStatusAsUser = 33;
        static final int TRANSACTION_isSyncPending = 34;
        static final int TRANSACTION_isSyncPendingAsUser = 35;
        static final int TRANSACTION_addStatusChangeListener = 36;
        static final int TRANSACTION_removeStatusChangeListener = 37;
        static final int TRANSACTION_putCache = 38;
        static final int TRANSACTION_getCache = 39;
        static final int TRANSACTION_resetTodayStats = 40;
        static final int TRANSACTION_onDbCorruption = 41;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IContentService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IContentService) {
                return (IContentService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "unregisterContentObserver";
                }
                case 2: {
                    return "registerContentObserver";
                }
                case 3: {
                    return "notifyChange";
                }
                case 4: {
                    return "requestSync";
                }
                case 5: {
                    return "sync";
                }
                case 6: {
                    return "syncAsUser";
                }
                case 7: {
                    return "cancelSync";
                }
                case 8: {
                    return "cancelSyncAsUser";
                }
                case 9: {
                    return "cancelRequest";
                }
                case 10: {
                    return "getSyncAutomatically";
                }
                case 11: {
                    return "getSyncAutomaticallyAsUser";
                }
                case 12: {
                    return "setSyncAutomatically";
                }
                case 13: {
                    return "setSyncAutomaticallyAsUser";
                }
                case 14: {
                    return "getPeriodicSyncs";
                }
                case 15: {
                    return "addPeriodicSync";
                }
                case 16: {
                    return "removePeriodicSync";
                }
                case 17: {
                    return "getIsSyncable";
                }
                case 18: {
                    return "getIsSyncableAsUser";
                }
                case 19: {
                    return "setIsSyncable";
                }
                case 20: {
                    return "setIsSyncableAsUser";
                }
                case 21: {
                    return "setMasterSyncAutomatically";
                }
                case 22: {
                    return "setMasterSyncAutomaticallyAsUser";
                }
                case 23: {
                    return "getMasterSyncAutomatically";
                }
                case 24: {
                    return "getMasterSyncAutomaticallyAsUser";
                }
                case 25: {
                    return "getCurrentSyncs";
                }
                case 26: {
                    return "getCurrentSyncsAsUser";
                }
                case 27: {
                    return "getSyncAdapterTypes";
                }
                case 28: {
                    return "getSyncAdapterTypesAsUser";
                }
                case 29: {
                    return "getSyncAdapterPackagesForAuthorityAsUser";
                }
                case 30: {
                    return "getSyncAdapterPackageAsUser";
                }
                case 31: {
                    return "isSyncActive";
                }
                case 32: {
                    return "getSyncStatus";
                }
                case 33: {
                    return "getSyncStatusAsUser";
                }
                case 34: {
                    return "isSyncPending";
                }
                case 35: {
                    return "isSyncPendingAsUser";
                }
                case 36: {
                    return "addStatusChangeListener";
                }
                case 37: {
                    return "removeStatusChangeListener";
                }
                case 38: {
                    return "putCache";
                }
                case 39: {
                    return "getCache";
                }
                case 40: {
                    return "resetTodayStats";
                }
                case 41: {
                    return "onDbCorruption";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IContentObserver _arg0 = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterContentObserver(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    IContentObserver _arg2 = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerContentObserver(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    Uri[] _arg0 = data.createTypedArray(Uri.CREATOR);
                    IContentObserver _arg1 = IContentObserver.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    String _arg6 = data.readString();
                    data.enforceNoDataAvail();
                    this.notifyChange(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.requestSync(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    SyncRequest _arg0 = data.readTypedObject(SyncRequest.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.sync(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    SyncRequest _arg0 = data.readTypedObject(SyncRequest.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.syncAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.cancelSync(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancelSyncAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    SyncRequest _arg0 = data.readTypedObject(SyncRequest.CREATOR);
                    data.enforceNoDataAvail();
                    this.cancelRequest(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.getSyncAutomatically(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 11: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.getSyncAutomaticallyAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSyncAutomatically(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSyncAutomaticallyAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    List<PeriodicSync> _result = this.getPeriodicSyncs(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 15: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    long _arg3 = data.readLong();
                    data.enforceNoDataAvail();
                    this.addPeriodicSync(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.removePeriodicSync(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getIsSyncable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 18: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getIsSyncableAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 19: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setIsSyncable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setIsSyncableAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMasterSyncAutomatically(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setMasterSyncAutomaticallyAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    boolean _result = this.getMasterSyncAutomatically();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.getMasterSyncAutomaticallyAsUser(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    List<SyncInfo> _result = this.getCurrentSyncs();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<SyncInfo> _result = this.getCurrentSyncsAsUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 27: {
                    Parcelable[] _result = this.getSyncAdapterTypes();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Parcelable[] _result = this.getSyncAdapterTypesAsUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    String[] _result = this.getSyncAdapterPackagesForAuthorityAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    String _result = this.getSyncAdapterPackageAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 31: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isSyncActive(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    SyncStatusInfo _result = this.getSyncStatus(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 33: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    SyncStatusInfo _result = this.getSyncStatusAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 34: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isSyncPending(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    Account _arg0 = data.readTypedObject(Account.CREATOR);
                    String _arg1 = data.readString();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSyncPendingAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    ISyncStatusObserver _arg1 = ISyncStatusObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addStatusChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    ISyncStatusObserver _arg0 = ISyncStatusObserver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeStatusChangeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.putCache(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    Uri _arg1 = data.readTypedObject(Uri.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    Bundle _result = this.getCache(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 40: {
                    this.resetTodayStats();
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.onDbCorruption(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 40;
        }

        private static class Proxy
        implements IContentService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterContentObserver(IContentObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(observer);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerContentObserver(Uri uri, boolean notifyForDescendants, IContentObserver observer, int userHandle, int targetSdkVersion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uri, 0);
                    _data.writeBoolean(notifyForDescendants);
                    _data.writeStrongInterface(observer);
                    _data.writeInt(userHandle);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyChange(Uri[] uris, IContentObserver observer, boolean observerWantsSelfNotifications, int flags, int userHandle, int targetSdkVersion, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray(uris, 0);
                    _data.writeStrongInterface(observer);
                    _data.writeBoolean(observerWantsSelfNotifications);
                    _data.writeInt(flags);
                    _data.writeInt(userHandle);
                    _data.writeInt(targetSdkVersion);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestSync(Account account, String authority, Bundle extras, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authority);
                    _data.writeTypedObject(extras, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sync(SyncRequest request, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void syncAsUser(SyncRequest request, int userId, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(userId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelSync(Account account, String authority, ComponentName cname) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authority);
                    _data.writeTypedObject(cname, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelSyncAsUser(Account account, String authority, ComponentName cname, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authority);
                    _data.writeTypedObject(cname, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelRequest(SyncRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSyncAutomatically(Account account, String providerName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSyncAutomaticallyAsUser(Account account, String providerName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSyncAutomatically(Account account, String providerName, boolean sync) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeBoolean(sync);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSyncAutomaticallyAsUser(Account account, String providerName, boolean sync, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeBoolean(sync);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PeriodicSync> getPeriodicSyncs(Account account, String providerName, ComponentName cname) throws RemoteException {
                ArrayList<PeriodicSync> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeTypedObject(cname, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PeriodicSync.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPeriodicSync(Account account, String providerName, Bundle extras, long pollFrequency) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeTypedObject(extras, 0);
                    _data.writeLong(pollFrequency);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePeriodicSync(Account account, String providerName, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeTypedObject(extras, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getIsSyncable(Account account, String providerName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getIsSyncableAsUser(Account account, String providerName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIsSyncable(Account account, String providerName, int syncable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeInt(syncable);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIsSyncableAsUser(Account account, String providerName, int syncable, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(providerName);
                    _data.writeInt(syncable);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMasterSyncAutomatically(boolean flag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(flag);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMasterSyncAutomaticallyAsUser(boolean flag, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(flag);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getMasterSyncAutomatically() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getMasterSyncAutomaticallyAsUser(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SyncInfo> getCurrentSyncs() throws RemoteException {
                ArrayList<SyncInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SyncInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SyncInfo> getCurrentSyncsAsUser(int userId) throws RemoteException {
                ArrayList<SyncInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SyncInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncAdapterType[] getSyncAdapterTypes() throws RemoteException {
                SyncAdapterType[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(SyncAdapterType.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncAdapterType[] getSyncAdapterTypesAsUser(int userId) throws RemoteException {
                SyncAdapterType[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(SyncAdapterType.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getSyncAdapterPackagesForAuthorityAsUser(String authority, int userId) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(authority);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSyncAdapterPackageAsUser(String accountType, String authority, int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(accountType);
                    _data.writeString(authority);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSyncActive(Account account, String authority, ComponentName cname) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authority);
                    _data.writeTypedObject(cname, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncStatusInfo getSyncStatus(Account account, String authority, ComponentName cname) throws RemoteException {
                SyncStatusInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authority);
                    _data.writeTypedObject(cname, 0);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SyncStatusInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SyncStatusInfo getSyncStatusAsUser(Account account, String authority, ComponentName cname, int userId) throws RemoteException {
                SyncStatusInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authority);
                    _data.writeTypedObject(cname, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SyncStatusInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSyncPending(Account account, String authority, ComponentName cname) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authority);
                    _data.writeTypedObject(cname, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSyncPendingAsUser(Account account, String authority, ComponentName cname, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(account, 0);
                    _data.writeString(authority);
                    _data.writeTypedObject(cname, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addStatusChangeListener(int mask, ISyncStatusObserver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(mask);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeStatusChangeListener(ISyncStatusObserver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void putCache(String packageName, Uri key, Bundle value, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(key, 0);
                    _data.writeTypedObject(value, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getCache(String packageName, Uri key, int userId) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(key, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetTodayStats() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDbCorruption(String tag, String message, String stacktrace) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag);
                    _data.writeString(message);
                    _data.writeString(stacktrace);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContentService {
        @Override
        public void unregisterContentObserver(IContentObserver observer) throws RemoteException {
        }

        @Override
        public void registerContentObserver(Uri uri, boolean notifyForDescendants, IContentObserver observer, int userHandle, int targetSdkVersion) throws RemoteException {
        }

        @Override
        public void notifyChange(Uri[] uris, IContentObserver observer, boolean observerWantsSelfNotifications, int flags, int userHandle, int targetSdkVersion, String callingPackage) throws RemoteException {
        }

        @Override
        public void requestSync(Account account, String authority, Bundle extras, String callingPackage) throws RemoteException {
        }

        @Override
        public void sync(SyncRequest request, String callingPackage) throws RemoteException {
        }

        @Override
        public void syncAsUser(SyncRequest request, int userId, String callingPackage) throws RemoteException {
        }

        @Override
        public void cancelSync(Account account, String authority, ComponentName cname) throws RemoteException {
        }

        @Override
        public void cancelSyncAsUser(Account account, String authority, ComponentName cname, int userId) throws RemoteException {
        }

        @Override
        public void cancelRequest(SyncRequest request) throws RemoteException {
        }

        @Override
        public boolean getSyncAutomatically(Account account, String providerName) throws RemoteException {
            return false;
        }

        @Override
        public boolean getSyncAutomaticallyAsUser(Account account, String providerName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setSyncAutomatically(Account account, String providerName, boolean sync) throws RemoteException {
        }

        @Override
        public void setSyncAutomaticallyAsUser(Account account, String providerName, boolean sync, int userId) throws RemoteException {
        }

        @Override
        public List<PeriodicSync> getPeriodicSyncs(Account account, String providerName, ComponentName cname) throws RemoteException {
            return null;
        }

        @Override
        public void addPeriodicSync(Account account, String providerName, Bundle extras, long pollFrequency) throws RemoteException {
        }

        @Override
        public void removePeriodicSync(Account account, String providerName, Bundle extras) throws RemoteException {
        }

        @Override
        public int getIsSyncable(Account account, String providerName) throws RemoteException {
            return 0;
        }

        @Override
        public int getIsSyncableAsUser(Account account, String providerName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void setIsSyncable(Account account, String providerName, int syncable) throws RemoteException {
        }

        @Override
        public void setIsSyncableAsUser(Account account, String providerName, int syncable, int userId) throws RemoteException {
        }

        @Override
        public void setMasterSyncAutomatically(boolean flag) throws RemoteException {
        }

        @Override
        public void setMasterSyncAutomaticallyAsUser(boolean flag, int userId) throws RemoteException {
        }

        @Override
        public boolean getMasterSyncAutomatically() throws RemoteException {
            return false;
        }

        @Override
        public boolean getMasterSyncAutomaticallyAsUser(int userId) throws RemoteException {
            return false;
        }

        @Override
        public List<SyncInfo> getCurrentSyncs() throws RemoteException {
            return null;
        }

        @Override
        public List<SyncInfo> getCurrentSyncsAsUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public SyncAdapterType[] getSyncAdapterTypes() throws RemoteException {
            return null;
        }

        @Override
        public SyncAdapterType[] getSyncAdapterTypesAsUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String[] getSyncAdapterPackagesForAuthorityAsUser(String authority, int userId) throws RemoteException {
            return null;
        }

        @Override
        public String getSyncAdapterPackageAsUser(String accountType, String authority, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSyncActive(Account account, String authority, ComponentName cname) throws RemoteException {
            return false;
        }

        @Override
        public SyncStatusInfo getSyncStatus(Account account, String authority, ComponentName cname) throws RemoteException {
            return null;
        }

        @Override
        public SyncStatusInfo getSyncStatusAsUser(Account account, String authority, ComponentName cname, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSyncPending(Account account, String authority, ComponentName cname) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSyncPendingAsUser(Account account, String authority, ComponentName cname, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void addStatusChangeListener(int mask, ISyncStatusObserver callback) throws RemoteException {
        }

        @Override
        public void removeStatusChangeListener(ISyncStatusObserver callback) throws RemoteException {
        }

        @Override
        public void putCache(String packageName, Uri key, Bundle value, int userId) throws RemoteException {
        }

        @Override
        public Bundle getCache(String packageName, Uri key, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void resetTodayStats() throws RemoteException {
        }

        @Override
        public void onDbCorruption(String tag, String message, String stacktrace) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

