/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ISyncContext;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISyncServiceAdapter
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/content/ISyncServiceAdapter.aidl:38:1:38:25")
    public void startSync(ISyncContext var1, Bundle var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/content/ISyncServiceAdapter.aidl:44:1:44:25")
    public void cancelSync(ISyncContext var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISyncServiceAdapter {
        public static final String DESCRIPTOR = "android.content.ISyncServiceAdapter";
        static final int TRANSACTION_startSync = 1;
        static final int TRANSACTION_cancelSync = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISyncServiceAdapter asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISyncServiceAdapter) {
                return (ISyncServiceAdapter)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startSync";
                }
                case 2: {
                    return "cancelSync";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ISyncContext _arg0 = ISyncContext.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.startSync(_arg0, _arg1);
                    break;
                }
                case 2: {
                    ISyncContext _arg0 = ISyncContext.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.cancelSync(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ISyncServiceAdapter {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSync(ISyncContext syncContext, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(syncContext);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelSync(ISyncContext syncContext) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(syncContext);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISyncServiceAdapter {
        @Override
        public void startSync(ISyncContext syncContext, Bundle extras) throws RemoteException {
        }

        @Override
        public void cancelSync(ISyncContext syncContext) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

