/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.content.om.OverlayIdentifier;
import android.os.FabricatedOverlayInternal;
import android.os.FabricatedOverlayInternalEntry;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import com.android.internal.content.om.OverlayManagerImpl;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Objects;

public class FabricatedOverlay {
    final FabricatedOverlayInternal mOverlay;

    public OverlayIdentifier getIdentifier() {
        return new OverlayIdentifier(this.mOverlay.packageName, TextUtils.nullIfEmpty(this.mOverlay.overlayName));
    }

    private static FabricatedOverlayInternal generateFabricatedOverlayInternal(String owningPackage, String overlayName, String targetPackageName, String targetOverlayable, ArrayList<FabricatedOverlayInternalEntry> entries) {
        FabricatedOverlayInternal overlay = new FabricatedOverlayInternal();
        overlay.packageName = owningPackage;
        overlay.overlayName = overlayName;
        overlay.targetPackageName = targetPackageName;
        overlay.targetOverlayable = TextUtils.emptyIfNull(targetOverlayable);
        overlay.entries = new ArrayList<FabricatedOverlayInternalEntry>();
        overlay.entries.addAll(entries);
        return overlay;
    }

    private FabricatedOverlay(FabricatedOverlayInternal overlay) {
        this.mOverlay = overlay;
    }

    public FabricatedOverlay(String overlayName, String targetPackage) {
        this(FabricatedOverlay.generateFabricatedOverlayInternal("", OverlayManagerImpl.checkOverlayNameValid(overlayName), Preconditions.checkStringNotEmpty(targetPackage, "'targetPackage' must not be empty nor null"), null, new ArrayList<FabricatedOverlayInternalEntry>()));
    }

    public void setTargetOverlayable(String targetOverlayable) {
        this.mOverlay.targetOverlayable = TextUtils.emptyIfNull(targetOverlayable);
    }

    public String getTargetOverlayable() {
        return this.mOverlay.targetOverlayable;
    }

    private static String ensureValidResourceName(String name) {
        Objects.requireNonNull(name);
        int slashIndex = name.indexOf(47);
        int colonIndex = name.indexOf(58);
        Preconditions.checkArgument(slashIndex >= 0 && colonIndex != 0 && slashIndex - colonIndex > 2, "\"%s\" is invalid resource name", name);
        return name;
    }

    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(String resourceName, int dataType, int value, String configuration) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.dataType = Preconditions.checkArgumentInRange(dataType, 16, 31, "dataType");
        entry.data = value;
        entry.configuration = configuration;
        return entry;
    }

    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(String resourceName, int dataType, String value, String configuration) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.dataType = Preconditions.checkArgumentInRange(dataType, 3, 6, "dataType");
        entry.stringData = Objects.requireNonNull(value);
        entry.configuration = configuration;
        return entry;
    }

    private static FabricatedOverlayInternalEntry generateFabricatedOverlayInternalEntry(String resourceName, ParcelFileDescriptor parcelFileDescriptor, String configuration) {
        FabricatedOverlayInternalEntry entry = new FabricatedOverlayInternalEntry();
        entry.resourceName = resourceName;
        entry.binaryData = Objects.requireNonNull(parcelFileDescriptor);
        entry.configuration = configuration;
        return entry;
    }

    public void setResourceValue(String resourceName, int dataType, int value, String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dataType, value, configuration));
    }

    public void setResourceValue(String resourceName, int dataType, String value, String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dataType, value, configuration));
    }

    public void setResourceValue(String resourceName, ParcelFileDescriptor value, String configuration) {
        FabricatedOverlay.ensureValidResourceName(resourceName);
        this.mOverlay.entries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, value, configuration));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringTypeOverlayResource {
    }

    public static class Builder {
        private final String mOwningPackage;
        private final String mName;
        private final String mTargetPackage;
        private String mTargetOverlayable = "";
        private final ArrayList<FabricatedOverlayInternalEntry> mEntries = new ArrayList();

        public Builder(String owningPackage, String name, String targetPackage) {
            Preconditions.checkStringNotEmpty(owningPackage, "'owningPackage' must not be empty nor null");
            Preconditions.checkStringNotEmpty(name, "'name'' must not be empty nor null");
            Preconditions.checkStringNotEmpty(targetPackage, "'targetPackage' must not be empty nor null");
            this.mOwningPackage = owningPackage;
            this.mName = name;
            this.mTargetPackage = targetPackage;
        }

        public Builder setTargetOverlayable(String targetOverlayable) {
            this.mTargetOverlayable = TextUtils.emptyIfNull(targetOverlayable);
            return this;
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        public Builder setResourceValue(String resourceName, int dataType, int value) {
            return this.setResourceValue(resourceName, dataType, value, null);
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        public Builder setResourceValue(String resourceName, int dataType, int value, String configuration) {
            FabricatedOverlay.ensureValidResourceName(resourceName);
            this.mEntries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dataType, value, configuration));
            return this;
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        public Builder setResourceValue(String resourceName, int dataType, String value) {
            return this.setResourceValue(resourceName, dataType, value, null);
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        public Builder setResourceValue(String resourceName, int dataType, String value, String configuration) {
            FabricatedOverlay.ensureValidResourceName(resourceName);
            this.mEntries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, dataType, value, configuration));
            return this;
        }

        @Deprecated(since="Please use FabricatedOverlay#setResourceValue instead")
        public Builder setResourceValue(String resourceName, ParcelFileDescriptor value, String configuration) {
            FabricatedOverlay.ensureValidResourceName(resourceName);
            this.mEntries.add(FabricatedOverlay.generateFabricatedOverlayInternalEntry(resourceName, value, configuration));
            return this;
        }

        public FabricatedOverlay build() {
            return new FabricatedOverlay(FabricatedOverlay.generateFabricatedOverlayInternal(this.mOwningPackage, this.mName, this.mTargetPackage, this.mTargetOverlayable, this.mEntries));
        }
    }
}

