/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class OverlayIdentifier
implements Parcelable {
    private final String mPackageName;
    private final String mOverlayName;
    public static final Parcelable.Creator<OverlayIdentifier> CREATOR = new Parcelable.Creator<OverlayIdentifier>(){

        public OverlayIdentifier[] newArray(int size) {
            return new OverlayIdentifier[size];
        }

        @Override
        public OverlayIdentifier createFromParcel(Parcel in) {
            return new OverlayIdentifier(in);
        }
    };

    public OverlayIdentifier(String packageName, String overlayName) {
        this.mPackageName = packageName;
        this.mOverlayName = overlayName;
    }

    public OverlayIdentifier(String packageName) {
        this.mPackageName = packageName;
        this.mOverlayName = null;
    }

    public String toString() {
        return this.mOverlayName == null ? this.mPackageName : this.mPackageName + ":" + this.mOverlayName;
    }

    public static OverlayIdentifier fromString(String text) {
        String[] parts = text.split(":", 2);
        if (parts.length == 2) {
            return new OverlayIdentifier(parts[0], parts[1]);
        }
        return new OverlayIdentifier(parts[0]);
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getOverlayName() {
        return this.mOverlayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverlayIdentifier that = (OverlayIdentifier)o;
        return Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mOverlayName, that.mOverlayName);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mOverlayName);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mPackageName != null) {
            flg = (byte)(flg | 1);
        }
        if (this.mOverlayName != null) {
            flg = (byte)(flg | 2);
        }
        dest.writeByte(flg);
        if (this.mPackageName != null) {
            dest.writeString(this.mPackageName);
        }
        if (this.mOverlayName != null) {
            dest.writeString(this.mOverlayName);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    OverlayIdentifier(Parcel in) {
        byte flg = in.readByte();
        String packageName = (flg & 1) == 0 ? null : in.readString();
        String overlayName = (flg & 2) == 0 ? null : in.readString();
        this.mPackageName = packageName;
        this.mOverlayName = overlayName;
    }

    @Deprecated
    private void __metadata() {
    }
}

