/*
 * Decompiled with CFR 0.152.
 */
package android.content.om;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.om.FabricatedOverlay;
import android.content.om.OverlayIdentifier;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class OverlayManagerTransaction
implements Parcelable {
    private final List<Request> mRequests;
    private final boolean mSelfTargeting;
    public static final Parcelable.Creator<OverlayManagerTransaction> CREATOR = new Parcelable.Creator<OverlayManagerTransaction>(){

        @Override
        public OverlayManagerTransaction createFromParcel(Parcel source) {
            return new OverlayManagerTransaction(source);
        }

        public OverlayManagerTransaction[] newArray(int size) {
            return new OverlayManagerTransaction[size];
        }
    };

    private OverlayManagerTransaction(List<Request> requests, boolean selfTargeting) {
        Objects.requireNonNull(requests);
        if (requests.contains(null)) {
            throw new IllegalArgumentException("null request");
        }
        this.mRequests = requests;
        this.mSelfTargeting = selfTargeting;
    }

    public static OverlayManagerTransaction newInstance() {
        return new OverlayManagerTransaction(new ArrayList<Request>(), true);
    }

    private OverlayManagerTransaction(Parcel source) {
        int size = source.readInt();
        this.mRequests = new ArrayList<Request>(size);
        for (int i = 0; i < size; ++i) {
            int request = source.readInt();
            OverlayIdentifier overlay = source.readParcelable(null, OverlayIdentifier.class);
            int userId = source.readInt();
            Bundle extras = source.readBundle(null);
            this.mRequests.add(new Request(request, overlay, userId, extras));
        }
        this.mSelfTargeting = false;
    }

    @SystemApi(client=SystemApi.Client.SYSTEM_SERVER)
    @SuppressLint(value={"ReferencesHidden"})
    public Iterator<Request> getRequests() {
        return this.mRequests.iterator();
    }

    public String toString() {
        return String.format("OverlayManagerTransaction { mRequests = %s }", this.mRequests);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int size = this.mRequests.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Request req = this.mRequests.get(i);
            dest.writeInt(req.type);
            dest.writeParcelable(req.overlay, flags);
            dest.writeInt(req.userId);
            dest.writeBundle(req.extras);
        }
    }

    private static Request generateRegisterFabricatedOverlayRequest(FabricatedOverlay overlay) {
        Objects.requireNonNull(overlay);
        Bundle extras = new Bundle();
        extras.putParcelable("fabricated_overlay", overlay.mOverlay);
        return new Request(2, overlay.getIdentifier(), -1, extras);
    }

    private static Request generateUnRegisterFabricatedOverlayRequest(OverlayIdentifier overlayIdentifier) {
        Objects.requireNonNull(overlayIdentifier);
        return new Request(3, overlayIdentifier, -1);
    }

    public void registerFabricatedOverlay(FabricatedOverlay overlay) {
        this.mRequests.add(OverlayManagerTransaction.generateRegisterFabricatedOverlayRequest(overlay));
    }

    public void unregisterFabricatedOverlay(OverlayIdentifier overlay) {
        this.mRequests.add(OverlayManagerTransaction.generateUnRegisterFabricatedOverlayRequest(overlay));
    }

    boolean isSelfTargeting() {
        return this.mSelfTargeting;
    }

    @SystemApi(client=SystemApi.Client.SYSTEM_SERVER)
    public static class Request {
        public static final int TYPE_SET_ENABLED = 0;
        public static final int TYPE_SET_DISABLED = 1;
        public static final int TYPE_REGISTER_FABRICATED = 2;
        public static final int TYPE_UNREGISTER_FABRICATED = 3;
        public static final String BUNDLE_FABRICATED_OVERLAY = "fabricated_overlay";
        public final int type;
        public final OverlayIdentifier overlay;
        public final int userId;
        @SuppressLint(value={"NullableCollection"})
        public final Bundle extras;

        public Request(int type, OverlayIdentifier overlay, int userId) {
            this(type, overlay, userId, null);
        }

        public Request(int type, OverlayIdentifier overlay, int userId, Bundle extras) {
            this.type = type;
            this.overlay = overlay;
            this.userId = userId;
            this.extras = extras;
        }

        public String toString() {
            return String.format(Locale.US, "Request{type=0x%02x (%s), overlay=%s, userId=%d}", this.type, this.typeToString(), this.overlay, this.userId);
        }

        public String typeToString() {
            switch (this.type) {
                case 0: {
                    return "TYPE_SET_ENABLED";
                }
                case 1: {
                    return "TYPE_SET_DISABLED";
                }
                case 2: {
                    return "TYPE_REGISTER_FABRICATED";
                }
                case 3: {
                    return "TYPE_UNREGISTER_FABRICATED";
                }
            }
            return String.format("TYPE_UNKNOWN (0x%02x)", this.type);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface RequestType {
        }
    }

    public static class Builder {
        private final List<Request> mRequests = new ArrayList<Request>();

        public Builder setEnabled(OverlayIdentifier overlay, boolean enable) {
            return this.setEnabled(overlay, enable, UserHandle.myUserId());
        }

        public Builder setEnabled(OverlayIdentifier overlay, boolean enable, int userId) {
            Preconditions.checkNotNull(overlay);
            int type = enable ? 0 : 1;
            this.mRequests.add(new Request(type, overlay, userId));
            return this;
        }

        public Builder registerFabricatedOverlay(FabricatedOverlay overlay) {
            this.mRequests.add(OverlayManagerTransaction.generateRegisterFabricatedOverlayRequest(overlay));
            return this;
        }

        public Builder unregisterFabricatedOverlay(OverlayIdentifier overlay) {
            this.mRequests.add(OverlayManagerTransaction.generateUnRegisterFabricatedOverlayRequest(overlay));
            return this;
        }

        public OverlayManagerTransaction build() {
            return new OverlayManagerTransaction(this.mRequests, false);
        }
    }
}

