/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.DataLoaderParamsParcel;
import android.content.pm.IDataLoader;
import android.content.pm.IDataLoaderStatusListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDataLoaderManager
extends IInterface {
    public static final String DESCRIPTOR = "android.content.pm.IDataLoaderManager";

    public boolean bindToDataLoader(int var1, DataLoaderParamsParcel var2, long var3, IDataLoaderStatusListener var5) throws RemoteException;

    public IDataLoader getDataLoader(int var1) throws RemoteException;

    public void unbindFromDataLoader(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDataLoaderManager {
        static final int TRANSACTION_bindToDataLoader = 1;
        static final int TRANSACTION_getDataLoader = 2;
        static final int TRANSACTION_unbindFromDataLoader = 3;

        public Stub() {
            this.attachInterface(this, IDataLoaderManager.DESCRIPTOR);
        }

        public static IDataLoaderManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDataLoaderManager.DESCRIPTOR);
            if (iin != null && iin instanceof IDataLoaderManager) {
                return (IDataLoaderManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "bindToDataLoader";
                }
                case 2: {
                    return "getDataLoader";
                }
                case 3: {
                    return "unbindFromDataLoader";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDataLoaderManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    DataLoaderParamsParcel _arg1 = data.readTypedObject(DataLoaderParamsParcel.CREATOR);
                    long _arg2 = data.readLong();
                    IDataLoaderStatusListener _arg3 = IDataLoaderStatusListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.bindToDataLoader(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    IDataLoader _result = this.getDataLoader(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unbindFromDataLoader(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IDataLoaderManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDataLoaderManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean bindToDataLoader(int id2, DataLoaderParamsParcel params, long bindDelayMs, IDataLoaderStatusListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataLoaderManager.DESCRIPTOR);
                    _data.writeInt(id2);
                    _data.writeTypedObject(params, 0);
                    _data.writeLong(bindDelayMs);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IDataLoader getDataLoader(int dataLoaderId) throws RemoteException {
                IDataLoader _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataLoaderManager.DESCRIPTOR);
                    _data.writeInt(dataLoaderId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = IDataLoader.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unbindFromDataLoader(int dataLoaderId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IDataLoaderManager.DESCRIPTOR);
                    _data.writeInt(dataLoaderId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDataLoaderManager {
        @Override
        public boolean bindToDataLoader(int id2, DataLoaderParamsParcel params, long bindDelayMs, IDataLoaderStatusListener listener) throws RemoteException {
            return false;
        }

        @Override
        public IDataLoader getDataLoader(int dataLoaderId) throws RemoteException {
            return null;
        }

        @Override
        public void unbindFromDataLoader(int dataLoaderId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

