/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherActivityInfoInternal;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.UserHandle;

public class LauncherActivityInfo {
    private final PackageManager mPm;
    private final LauncherActivityInfoInternal mInternal;

    LauncherActivityInfo(Context context, LauncherActivityInfoInternal internal) {
        this.mPm = context.getPackageManager();
        this.mInternal = internal;
    }

    public ComponentName getComponentName() {
        return this.mInternal.getComponentName();
    }

    public UserHandle getUser() {
        return this.mInternal.getUser();
    }

    public CharSequence getLabel() {
        return this.getActivityInfo().loadLabel(this.mPm);
    }

    public float getLoadingProgress() {
        return this.mInternal.getIncrementalStatesInfo().getProgress();
    }

    public Drawable getIcon(int density) {
        int iconRes = this.getActivityInfo().getIconResource();
        Drawable icon = null;
        if (density != 0 && iconRes != 0) {
            try {
                Resources resources = this.mPm.getResourcesForApplication(this.getActivityInfo().applicationInfo);
                icon = resources.getDrawableForDensity(iconRes, density);
            }
            catch (PackageManager.NameNotFoundException | Resources.NotFoundException exception) {
                // empty catch block
            }
        }
        if (icon == null) {
            icon = this.getActivityInfo().loadIcon(this.mPm);
        }
        return icon;
    }

    public int getApplicationFlags() {
        return this.getActivityInfo().flags;
    }

    public ActivityInfo getActivityInfo() {
        return this.mInternal.getActivityInfo();
    }

    public ApplicationInfo getApplicationInfo() {
        return this.getActivityInfo().applicationInfo;
    }

    public long getFirstInstallTime() {
        try {
            return this.mPm.getPackageInfo((String)this.getActivityInfo().packageName, (int)8192).firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            return 0L;
        }
    }

    public String getName() {
        return this.getActivityInfo().name;
    }

    public Drawable getBadgedIcon(int density) {
        Drawable originalIcon = this.getIcon(density);
        return this.mPm.getUserBadgedIcon(originalIcon, this.mInternal.getUser());
    }
}

