/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Environment;
import android.os.FileUtils;
import android.os.SystemProperties;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;

public class PackagePartitions {
    public static final int PARTITION_SYSTEM = 0;
    public static final int PARTITION_VENDOR = 1;
    public static final int PARTITION_ODM = 2;
    public static final int PARTITION_OEM = 3;
    public static final int PARTITION_PRODUCT = 4;
    public static final int PARTITION_SYSTEM_EXT = 5;
    private static final ArrayList<SystemPartition> SYSTEM_PARTITIONS = new ArrayList<SystemPartition>(Arrays.asList(new SystemPartition(Environment.getRootDirectory(), 0, "system", true, false), new SystemPartition(Environment.getVendorDirectory(), 1, "vendor", true, true), new SystemPartition(Environment.getOdmDirectory(), 2, "odm", true, true), new SystemPartition(Environment.getOemDirectory(), 3, "oem", false, true), new SystemPartition(Environment.getProductDirectory(), 4, "product", true, true), new SystemPartition(Environment.getSystemExtDirectory(), 5, "system_ext", true, true)));
    public static final String FINGERPRINT = PackagePartitions.getFingerprint();

    public static <T> ArrayList<T> getOrderedPartitions(Function<SystemPartition, T> producer) {
        ArrayList<T> out = new ArrayList<T>();
        int n = SYSTEM_PARTITIONS.size();
        for (int i = 0; i < n; ++i) {
            T v = producer.apply(SYSTEM_PARTITIONS.get(i));
            if (v == null) continue;
            out.add(v);
        }
        return out;
    }

    private static File canonicalize(File path) {
        try {
            return path.getCanonicalFile();
        }
        catch (IOException e) {
            return path;
        }
    }

    private static String getFingerprint() {
        String[] digestProperties = new String[SYSTEM_PARTITIONS.size() + 1];
        for (int i = 0; i < SYSTEM_PARTITIONS.size(); ++i) {
            String partitionName = SYSTEM_PARTITIONS.get(i).getName();
            digestProperties[i] = "ro." + partitionName + ".build.fingerprint";
        }
        digestProperties[PackagePartitions.SYSTEM_PARTITIONS.size()] = "ro.build.fingerprint";
        return SystemProperties.digestOf(digestProperties);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static class SystemPartition {
        public final int type;
        private final String mName;
        private final DeferredCanonicalFile mFolder;
        private final DeferredCanonicalFile mAppFolder;
        private final DeferredCanonicalFile mPrivAppFolder;
        private final DeferredCanonicalFile mOverlayFolder;
        private final File mNonConicalFolder;

        private SystemPartition(File folder, int type, String name, boolean containsPrivApp, boolean containsOverlay) {
            this.type = type;
            this.mName = name;
            this.mFolder = new DeferredCanonicalFile(folder);
            this.mAppFolder = new DeferredCanonicalFile(folder, "app");
            this.mPrivAppFolder = containsPrivApp ? new DeferredCanonicalFile(folder, "priv-app") : null;
            this.mOverlayFolder = containsOverlay ? new DeferredCanonicalFile(folder, "overlay") : null;
            this.mNonConicalFolder = folder;
        }

        public SystemPartition(SystemPartition original) {
            this.type = original.type;
            this.mName = original.mName;
            this.mFolder = new DeferredCanonicalFile(original.mFolder.getFile());
            this.mAppFolder = original.mAppFolder;
            this.mPrivAppFolder = original.mPrivAppFolder;
            this.mOverlayFolder = original.mOverlayFolder;
            this.mNonConicalFolder = original.mNonConicalFolder;
        }

        public SystemPartition(File rootFolder, SystemPartition partition) {
            this(rootFolder, partition.type, partition.mName, partition.mPrivAppFolder != null, partition.mOverlayFolder != null);
        }

        public String getName() {
            return this.mName;
        }

        public File getFolder() {
            return this.mFolder.getFile();
        }

        public File getNonConicalFolder() {
            return this.mNonConicalFolder;
        }

        public File getAppFolder() {
            return this.mAppFolder == null ? null : this.mAppFolder.getFile();
        }

        public File getPrivAppFolder() {
            return this.mPrivAppFolder == null ? null : this.mPrivAppFolder.getFile();
        }

        public File getOverlayFolder() {
            return this.mOverlayFolder == null ? null : this.mOverlayFolder.getFile();
        }

        public boolean containsPath(String path) {
            return this.containsFile(new File(path));
        }

        public boolean containsFile(File file) {
            return FileUtils.contains(this.mFolder.getFile(), PackagePartitions.canonicalize(file));
        }

        public boolean containsPrivApp(File scanFile) {
            return this.mPrivAppFolder != null && FileUtils.contains(this.mPrivAppFolder.getFile(), PackagePartitions.canonicalize(scanFile));
        }

        public boolean containsApp(File scanFile) {
            return this.mAppFolder != null && FileUtils.contains(this.mAppFolder.getFile(), PackagePartitions.canonicalize(scanFile));
        }

        public boolean containsOverlay(File scanFile) {
            return this.mOverlayFolder != null && FileUtils.contains(this.mOverlayFolder.getFile(), PackagePartitions.canonicalize(scanFile));
        }
    }

    private static class DeferredCanonicalFile {
        private boolean mIsCanonical = false;
        private File mFile;

        private DeferredCanonicalFile(File dir) {
            this.mFile = dir;
        }

        private DeferredCanonicalFile(File dir, String fileName) {
            this.mFile = new File(dir, fileName);
        }

        private File getFile() {
            if (!this.mIsCanonical) {
                this.mFile = PackagePartitions.canonicalize(this.mFile);
                this.mIsCanonical = true;
            }
            return this.mFile;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PartitionType {
    }
}

