/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.RequiresPermission;
import android.content.pm.ComponentInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Printer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ServiceInfo
extends ComponentInfo
implements Parcelable {
    public String permission;
    public static final int FLAG_STOP_WITH_TASK = 1;
    public static final int FLAG_ISOLATED_PROCESS = 2;
    public static final int FLAG_EXTERNAL_SERVICE = 4;
    public static final int FLAG_USE_APP_ZYGOTE = 8;
    public static final int FLAG_ALLOW_SHARED_ISOLATED_PROCESS = 16;
    public static final int FLAG_VISIBLE_TO_INSTANT_APP = 0x100000;
    public static final int FLAG_SINGLE_USER = 0x40000000;
    public int flags;
    @Deprecated
    public static final int FOREGROUND_SERVICE_TYPE_NONE = 0;
    @RequiresPermission(value="android.permission.FOREGROUND_SERVICE_DATA_SYNC", conditional=true)
    public static final int FOREGROUND_SERVICE_TYPE_DATA_SYNC = 1;
    @RequiresPermission(value="android.permission.FOREGROUND_SERVICE_MEDIA_PLAYBACK", conditional=true)
    public static final int FOREGROUND_SERVICE_TYPE_MEDIA_PLAYBACK = 2;
    @RequiresPermission(allOf={"android.permission.FOREGROUND_SERVICE_PHONE_CALL"}, anyOf={"android.permission.MANAGE_OWN_CALLS"}, conditional=true)
    public static final int FOREGROUND_SERVICE_TYPE_PHONE_CALL = 4;
    @RequiresPermission(allOf={"android.permission.FOREGROUND_SERVICE_LOCATION"}, anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"}, conditional=true)
    public static final int FOREGROUND_SERVICE_TYPE_LOCATION = 8;
    @RequiresPermission(allOf={"android.permission.FOREGROUND_SERVICE_CONNECTED_DEVICE"}, anyOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_SCAN", "android.permission.CHANGE_NETWORK_STATE", "android.permission.CHANGE_WIFI_STATE", "android.permission.CHANGE_WIFI_MULTICAST_STATE", "android.permission.NFC", "android.permission.TRANSMIT_IR", "android.permission.UWB_RANGING"}, conditional=true)
    public static final int FOREGROUND_SERVICE_TYPE_CONNECTED_DEVICE = 16;
    @RequiresPermission(value="android.permission.FOREGROUND_SERVICE_MEDIA_PROJECTION", conditional=true)
    public static final int FOREGROUND_SERVICE_TYPE_MEDIA_PROJECTION = 32;
    @RequiresPermission(allOf={"android.permission.FOREGROUND_SERVICE_CAMERA"}, anyOf={"android.permission.CAMERA"}, conditional=true)
    public static final int FOREGROUND_SERVICE_TYPE_CAMERA = 64;
    @RequiresPermission(allOf={"android.permission.FOREGROUND_SERVICE_MICROPHONE"}, anyOf={"android.permission.CAPTURE_AUDIO_OUTPUT", "android.permission.RECORD_AUDIO"}, conditional=true)
    public static final int FOREGROUND_SERVICE_TYPE_MICROPHONE = 128;
    @RequiresPermission(allOf={"android.permission.FOREGROUND_SERVICE_HEALTH"}, anyOf={"android.permission.ACTIVITY_RECOGNITION", "android.permission.BODY_SENSORS", "android.permission.HIGH_SAMPLING_RATE_SENSORS"})
    public static final int FOREGROUND_SERVICE_TYPE_HEALTH = 256;
    @RequiresPermission(value="android.permission.FOREGROUND_SERVICE_REMOTE_MESSAGING")
    public static final int FOREGROUND_SERVICE_TYPE_REMOTE_MESSAGING = 512;
    @RequiresPermission(value="android.permission.FOREGROUND_SERVICE_SYSTEM_EXEMPTED")
    public static final int FOREGROUND_SERVICE_TYPE_SYSTEM_EXEMPTED = 1024;
    public static final int FOREGROUND_SERVICE_TYPE_SHORT_SERVICE = 2048;
    @RequiresPermission(value="android.permission.FOREGROUND_SERVICE_FILE_MANAGEMENT")
    public static final int FOREGROUND_SERVICE_TYPE_FILE_MANAGEMENT = 4096;
    @RequiresPermission(value="android.permission.FOREGROUND_SERVICE_SPECIAL_USE")
    public static final int FOREGROUND_SERVICE_TYPE_SPECIAL_USE = 0x40000000;
    public static final int FOREGROUND_SERVICE_TYPES_MAX_INDEX = 30;
    public static final int FOREGROUND_SERVICE_TYPE_MANIFEST = -1;
    public int mForegroundServiceType = 0;
    public static final Parcelable.Creator<ServiceInfo> CREATOR = new Parcelable.Creator<ServiceInfo>(){

        @Override
        public ServiceInfo createFromParcel(Parcel source) {
            return new ServiceInfo(source);
        }

        public ServiceInfo[] newArray(int size) {
            return new ServiceInfo[size];
        }
    };

    public ServiceInfo() {
    }

    public ServiceInfo(ServiceInfo orig) {
        super(orig);
        this.permission = orig.permission;
        this.flags = orig.flags;
        this.mForegroundServiceType = orig.mForegroundServiceType;
    }

    public int getForegroundServiceType() {
        return this.mForegroundServiceType;
    }

    public void dump(Printer pw, String prefix) {
        this.dump(pw, prefix, 3);
    }

    void dump(Printer pw, String prefix, int dumpFlags) {
        super.dumpFront(pw, prefix);
        pw.println(prefix + "permission=" + this.permission);
        pw.println(prefix + "flags=0x" + Integer.toHexString(this.flags));
        super.dumpBack(pw, prefix, dumpFlags);
    }

    public String toString() {
        return "ServiceInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "}";
    }

    public static String foregroundServiceTypeToLabel(int type) {
        switch (type) {
            case -1: {
                return "manifest";
            }
            case 0: {
                return "none";
            }
            case 1: {
                return "dataSync";
            }
            case 2: {
                return "mediaPlayback";
            }
            case 4: {
                return "phoneCall";
            }
            case 8: {
                return "location";
            }
            case 16: {
                return "connectedDevice";
            }
            case 32: {
                return "mediaProjection";
            }
            case 64: {
                return "camera";
            }
            case 128: {
                return "microphone";
            }
            case 256: {
                return "health";
            }
            case 512: {
                return "remoteMessaging";
            }
            case 1024: {
                return "systemExempted";
            }
            case 2048: {
                return "shortService";
            }
            case 4096: {
                return "fileManagement";
            }
            case 0x40000000: {
                return "specialUse";
            }
        }
        return "unknown";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        super.writeToParcel(dest, parcelableFlags);
        dest.writeString8(this.permission);
        dest.writeInt(this.flags);
        dest.writeInt(this.mForegroundServiceType);
    }

    private ServiceInfo(Parcel source) {
        super(source);
        this.permission = source.readString8();
        this.flags = source.readInt();
        this.mForegroundServiceType = source.readInt();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ForegroundServiceType {
    }
}

