/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.DebugUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class UserInfo
implements Parcelable {
    @Deprecated
    @UnsupportedAppUsage
    public static final int FLAG_PRIMARY = 1;
    public static final int FLAG_ADMIN = 2;
    @Deprecated
    public static final int FLAG_GUEST = 4;
    @Deprecated
    public static final int FLAG_RESTRICTED = 8;
    public static final int FLAG_INITIALIZED = 16;
    @Deprecated
    public static final int FLAG_MANAGED_PROFILE = 32;
    public static final int FLAG_DISABLED = 64;
    public static final int FLAG_QUIET_MODE = 128;
    public static final int FLAG_EPHEMERAL = 256;
    @Deprecated
    public static final int FLAG_DEMO = 512;
    public static final int FLAG_FULL = 1024;
    public static final int FLAG_SYSTEM = 2048;
    public static final int FLAG_PROFILE = 4096;
    public static final int FLAG_EPHEMERAL_ON_CREATE = 8192;
    public static final int FLAG_MAIN = 16384;
    public static final int FLAG_FOR_TESTING = 32768;
    public static final int NO_PROFILE_GROUP_ID = -10000;
    @UnsupportedAppUsage
    public int id;
    @UnsupportedAppUsage
    public int serialNumber;
    @UnsupportedAppUsage
    public String name;
    @UnsupportedAppUsage
    public String iconPath;
    @UnsupportedAppUsage
    public int flags;
    @UnsupportedAppUsage
    public long creationTime;
    @UnsupportedAppUsage
    public long lastLoggedInTime;
    public String lastLoggedInFingerprint;
    public String userType;
    @UnsupportedAppUsage
    public int profileGroupId;
    public int restrictedProfileParentId;
    public int profileBadge;
    @UnsupportedAppUsage
    public boolean partial;
    @UnsupportedAppUsage
    public boolean guestToRemove;
    public boolean preCreated;
    public boolean convertedFromPreCreated;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<UserInfo> CREATOR = new Parcelable.Creator<UserInfo>(){

        @Override
        public UserInfo createFromParcel(Parcel source) {
            return new UserInfo(source);
        }

        public UserInfo[] newArray(int size) {
            return new UserInfo[size];
        }
    };

    @UnsupportedAppUsage
    public UserInfo(int id2, String name, int flags) {
        this(id2, name, null, flags);
    }

    @UnsupportedAppUsage
    public UserInfo(int id2, String name, String iconPath, int flags) {
        this(id2, name, iconPath, flags, UserInfo.getDefaultUserType(flags));
    }

    public UserInfo(int id2, String name, String iconPath, int flags, String userType) {
        this.id = id2;
        this.name = name;
        this.flags = flags;
        this.userType = userType;
        this.iconPath = iconPath;
        this.profileGroupId = -10000;
        this.restrictedProfileParentId = -10000;
    }

    public static String getDefaultUserType(int userInfoFlag) {
        if ((userInfoFlag & 0x800) != 0) {
            throw new IllegalArgumentException("Cannot getDefaultUserType for flags " + Integer.toHexString(userInfoFlag) + " because it corresponds to a SYSTEM user type.");
        }
        int supportedFlagTypes = 556;
        switch (userInfoFlag & 0x22C) {
            case 0: {
                return "android.os.usertype.full.SECONDARY";
            }
            case 4: {
                return "android.os.usertype.full.GUEST";
            }
            case 8: {
                return "android.os.usertype.full.RESTRICTED";
            }
            case 32: {
                return "android.os.usertype.profile.MANAGED";
            }
            case 512: {
                return "android.os.usertype.full.DEMO";
            }
        }
        throw new IllegalArgumentException("Cannot getDefaultUserType for flags " + Integer.toHexString(userInfoFlag) + " because it doesn't correspond to a valid user type.");
    }

    @Deprecated
    @UnsupportedAppUsage
    public boolean isPrimary() {
        return (this.flags & 1) == 1;
    }

    @UnsupportedAppUsage
    public boolean isAdmin() {
        return (this.flags & 2) == 2;
    }

    @UnsupportedAppUsage
    public boolean isGuest() {
        return UserManager.isUserTypeGuest(this.userType);
    }

    @UnsupportedAppUsage
    public boolean isRestricted() {
        return UserManager.isUserTypeRestricted(this.userType);
    }

    public boolean isProfile() {
        return (this.flags & 0x1000) != 0;
    }

    @UnsupportedAppUsage
    public boolean isManagedProfile() {
        return UserManager.isUserTypeManagedProfile(this.userType);
    }

    public boolean isCloneProfile() {
        return UserManager.isUserTypeCloneProfile(this.userType);
    }

    @UnsupportedAppUsage
    public boolean isEnabled() {
        return (this.flags & 0x40) != 64;
    }

    public boolean isQuietModeEnabled() {
        return (this.flags & 0x80) == 128;
    }

    public boolean isEphemeral() {
        return (this.flags & 0x100) == 256;
    }

    public boolean isForTesting() {
        return (this.flags & 0x8000) == 32768;
    }

    public boolean isInitialized() {
        return (this.flags & 0x10) == 16;
    }

    public boolean isDemo() {
        return UserManager.isUserTypeDemo(this.userType) || (this.flags & 0x200) != 0;
    }

    public boolean isFull() {
        return (this.flags & 0x400) == 1024;
    }

    public boolean isMain() {
        return (this.flags & 0x4000) == 16384;
    }

    public boolean supportsSwitchTo() {
        if (this.partial || !this.isEnabled()) {
            return false;
        }
        if (this.preCreated) {
            return false;
        }
        return this.isFull() || this.canSwitchToHeadlessSystemUser();
    }

    private boolean canSwitchToHeadlessSystemUser() {
        return "android.os.usertype.system.HEADLESS".equals(this.userType) && Resources.getSystem().getBoolean(17891407);
    }

    @Deprecated
    public boolean supportsSwitchToByUser() {
        return this.supportsSwitchTo();
    }

    public boolean canHaveProfile() {
        if (this.isProfile() || this.isGuest() || this.isRestricted()) {
            return false;
        }
        return this.isMain();
    }

    @Deprecated
    @VisibleForTesting
    public UserInfo() {
    }

    public UserInfo(UserInfo orig) {
        this.name = orig.name;
        this.iconPath = orig.iconPath;
        this.id = orig.id;
        this.flags = orig.flags;
        this.userType = orig.userType;
        this.serialNumber = orig.serialNumber;
        this.creationTime = orig.creationTime;
        this.lastLoggedInTime = orig.lastLoggedInTime;
        this.lastLoggedInFingerprint = orig.lastLoggedInFingerprint;
        this.partial = orig.partial;
        this.preCreated = orig.preCreated;
        this.convertedFromPreCreated = orig.convertedFromPreCreated;
        this.profileGroupId = orig.profileGroupId;
        this.restrictedProfileParentId = orig.restrictedProfileParentId;
        this.guestToRemove = orig.guestToRemove;
        this.profileBadge = orig.profileBadge;
    }

    @UnsupportedAppUsage
    public UserHandle getUserHandle() {
        return UserHandle.of(this.id);
    }

    public String toString() {
        return "UserInfo{" + this.id + ":" + this.name + ":" + Integer.toHexString(this.flags) + "}";
    }

    public String toFullString() {
        return "UserInfo[id=" + this.id + ", name=" + this.name + ", type=" + this.userType + ", flags=" + UserInfo.flagsToString(this.flags) + (this.preCreated ? " (pre-created)" : "") + (this.convertedFromPreCreated ? " (converted)" : "") + (this.partial ? " (partial)" : "") + "]";
    }

    public static String flagsToString(int flags) {
        return DebugUtils.flagsToString(UserInfo.class, "FLAG_", flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeInt(this.id);
        dest.writeString8(this.name);
        dest.writeString8(this.iconPath);
        dest.writeInt(this.flags);
        dest.writeString8(this.userType);
        dest.writeInt(this.serialNumber);
        dest.writeLong(this.creationTime);
        dest.writeLong(this.lastLoggedInTime);
        dest.writeString8(this.lastLoggedInFingerprint);
        dest.writeBoolean(this.partial);
        dest.writeBoolean(this.preCreated);
        dest.writeInt(this.profileGroupId);
        dest.writeBoolean(this.guestToRemove);
        dest.writeInt(this.restrictedProfileParentId);
        dest.writeInt(this.profileBadge);
    }

    private UserInfo(Parcel source) {
        this.id = source.readInt();
        this.name = source.readString8();
        this.iconPath = source.readString8();
        this.flags = source.readInt();
        this.userType = source.readString8();
        this.serialNumber = source.readInt();
        this.creationTime = source.readLong();
        this.lastLoggedInTime = source.readLong();
        this.lastLoggedInFingerprint = source.readString8();
        this.partial = source.readBoolean();
        this.preCreated = source.readBoolean();
        this.profileGroupId = source.readInt();
        this.guestToRemove = source.readBoolean();
        this.restrictedProfileParentId = source.readInt();
        this.profileBadge = source.readInt();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserInfoFlag {
    }
}

