/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.util.SparseArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import java.util.Objects;
import java.util.Random;
import libcore.util.EmptyArray;

public class UserPackage {
    private static final boolean ENABLE_CACHING = true;
    @VisibleForTesting
    static final int MAX_NUM_CACHED_ENTRIES_PER_USER = 1000;
    public final int userId;
    public final String packageName;
    private static final Object sCacheLock = new Object();
    @GuardedBy(value={"sCacheLock"})
    private static final SparseArrayMap<String, UserPackage> sCache = new SparseArrayMap();
    @GuardedBy(value={"sCacheLock"})
    private static int[] sUserIds = EmptyArray.INT;

    private UserPackage(int userId, String packageName) {
        this.userId = userId;
        this.packageName = packageName;
    }

    public String toString() {
        return "<" + this.userId + ">" + this.packageName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UserPackage) {
            UserPackage other = (UserPackage)obj;
            return this.userId == other.userId && Objects.equals(this.packageName, other.packageName);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.userId;
        result = 31 * result + this.packageName.hashCode();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserPackage of(int userId, String packageName) {
        Object object = sCacheLock;
        synchronized (object) {
            if (!ArrayUtils.contains(sUserIds, userId)) {
                return new UserPackage(userId, packageName);
            }
            UserPackage up = sCache.get(userId, packageName);
            if (up == null) {
                UserPackage.maybePurgeRandomEntriesLocked(userId);
                packageName = packageName.intern();
                up = new UserPackage(userId, packageName);
                sCache.add(userId, packageName, up);
            }
            return up;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromCache(int userId, String packageName) {
        Object object = sCacheLock;
        synchronized (object) {
            sCache.delete(userId, packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValidUserIds(int[] userIds) {
        userIds = (int[])userIds.clone();
        Object object = sCacheLock;
        synchronized (object) {
            sUserIds = userIds;
            for (int u = sCache.numMaps() - 1; u >= 0; --u) {
                int userId = sCache.keyAt(u);
                if (ArrayUtils.contains(userIds, userId)) continue;
                sCache.deleteAt(u);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static int numEntriesForUser(int userId) {
        Object object = sCacheLock;
        synchronized (object) {
            return sCache.numElementsForKey(userId);
        }
    }

    @GuardedBy(value={"sCacheLock"})
    private static void maybePurgeRandomEntriesLocked(int userId) {
        int uIdx = sCache.indexOfKey(userId);
        if (uIdx < 0) {
            return;
        }
        int numCached = sCache.numElementsForKeyAt(uIdx);
        if (numCached < 1000) {
            return;
        }
        Random rand = new Random();
        int numToPurge = Math.max(1, 10);
        for (int i = 0; i < numToPurge && numCached > 0; ++i) {
            int removeIdx = rand.nextInt(numCached--);
            sCache.deleteAt(uIdx, removeIdx);
        }
    }
}

