/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.xmlpull.v1.XmlPullParserException;

@SystemApi
public class UserProperties
implements Parcelable {
    private static final String LOG_TAG = UserProperties.class.getSimpleName();
    private static final String ATTR_SHOW_IN_LAUNCHER = "showInLauncher";
    private static final String ATTR_START_WITH_PARENT = "startWithParent";
    private static final String ATTR_SHOW_IN_SETTINGS = "showInSettings";
    private static final String ATTR_INHERIT_DEVICE_POLICY = "inheritDevicePolicy";
    private static final String ATTR_USE_PARENTS_CONTACTS = "useParentsContacts";
    private static final String ATTR_UPDATE_CROSS_PROFILE_INTENT_FILTERS_ON_OTA = "updateCrossProfileIntentFiltersOnOTA";
    private static final String ATTR_CROSS_PROFILE_INTENT_FILTER_ACCESS_CONTROL = "crossProfileIntentFilterAccessControl";
    private static final String ATTR_CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY = "crossProfileIntentResolutionStrategy";
    private static final String ATTR_MEDIA_SHARED_WITH_PARENT = "mediaSharedWithParent";
    private static final String ATTR_CREDENTIAL_SHAREABLE_WITH_PARENT = "credentialShareableWithParent";
    private static final String ATTR_DELETE_APP_WITH_PARENT = "deleteAppWithParent";
    private static final int INDEX_SHOW_IN_LAUNCHER = 0;
    private static final int INDEX_START_WITH_PARENT = 1;
    private static final int INDEX_SHOW_IN_SETTINGS = 2;
    private static final int INDEX_INHERIT_DEVICE_POLICY = 3;
    private static final int INDEX_USE_PARENTS_CONTACTS = 4;
    private static final int INDEX_UPDATE_CROSS_PROFILE_INTENT_FILTERS_ON_OTA = 5;
    private static final int INDEX_CROSS_PROFILE_INTENT_FILTER_ACCESS_CONTROL = 6;
    private static final int INDEX_CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY = 7;
    private static final int INDEX_MEDIA_SHARED_WITH_PARENT = 8;
    private static final int INDEX_CREDENTIAL_SHAREABLE_WITH_PARENT = 9;
    private static final int INDEX_DELETE_APP_WITH_PARENT = 10;
    private long mPropertiesPresent = 0L;
    public static final int SHOW_IN_LAUNCHER_WITH_PARENT = 0;
    public static final int SHOW_IN_LAUNCHER_SEPARATE = 1;
    public static final int SHOW_IN_LAUNCHER_NO = 2;
    public static final int SHOW_IN_SETTINGS_WITH_PARENT = 0;
    public static final int SHOW_IN_SETTINGS_SEPARATE = 1;
    public static final int SHOW_IN_SETTINGS_NO = 2;
    public static final int INHERIT_DEVICE_POLICY_NO = 0;
    public static final int INHERIT_DEVICE_POLICY_FROM_PARENT = 1;
    private final UserProperties mDefaultProperties;
    public static final int CROSS_PROFILE_INTENT_FILTER_ACCESS_LEVEL_ALL = 0;
    public static final int CROSS_PROFILE_INTENT_FILTER_ACCESS_LEVEL_SYSTEM = 10;
    public static final int CROSS_PROFILE_INTENT_FILTER_ACCESS_LEVEL_SYSTEM_ADD_ONLY = 20;
    public static final int CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY_DEFAULT = 0;
    public static final int CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY_NO_FILTERING = 1;
    private int mShowInLauncher;
    private int mShowInSettings;
    private boolean mStartWithParent;
    private boolean mDeleteAppWithParent;
    private int mInheritDevicePolicy;
    private boolean mUseParentsContacts;
    private boolean mMediaSharedWithParent;
    private boolean mCredentialShareableWithParent;
    private boolean mUpdateCrossProfileIntentFiltersOnOTA;
    private int mCrossProfileIntentFilterAccessControl;
    private int mCrossProfileIntentResolutionStrategy;
    public static final Parcelable.Creator<UserProperties> CREATOR = new Parcelable.Creator<UserProperties>(){

        @Override
        public UserProperties createFromParcel(Parcel source) {
            return new UserProperties(source);
        }

        public UserProperties[] newArray(int size) {
            return new UserProperties[size];
        }
    };

    public UserProperties(UserProperties defaultProperties) {
        this.mDefaultProperties = defaultProperties;
        this.mPropertiesPresent = 0L;
    }

    public UserProperties(UserProperties orig, boolean exposeAllFields, boolean hasManagePermission, boolean hasQueryOrManagePermission) {
        if (orig.mDefaultProperties == null) {
            throw new IllegalArgumentException("Attempting to copy a non-original UserProperties.");
        }
        this.mDefaultProperties = null;
        if (exposeAllFields) {
            this.setStartWithParent(orig.getStartWithParent());
            this.setInheritDevicePolicy(orig.getInheritDevicePolicy());
            this.setUpdateCrossProfileIntentFiltersOnOTA(orig.getUpdateCrossProfileIntentFiltersOnOTA());
            this.setCrossProfileIntentFilterAccessControl(orig.getCrossProfileIntentFilterAccessControl());
            this.setCrossProfileIntentResolutionStrategy(orig.getCrossProfileIntentResolutionStrategy());
            this.setDeleteAppWithParent(orig.getDeleteAppWithParent());
        }
        if (hasManagePermission) {
            this.setShowInSettings(orig.getShowInSettings());
            this.setUseParentsContacts(orig.getUseParentsContacts());
        }
        if (hasQueryOrManagePermission) {
            // empty if block
        }
        this.setShowInLauncher(orig.getShowInLauncher());
        this.setMediaSharedWithParent(orig.isMediaSharedWithParent());
        this.setCredentialShareableWithParent(orig.isCredentialShareableWithParent());
    }

    private boolean isPresent(long index) {
        return (this.mPropertiesPresent & 1L << (int)index) != 0L;
    }

    private void setPresent(long index) {
        this.mPropertiesPresent |= 1L << (int)index;
    }

    @VisibleForTesting
    public long getPropertiesPresent() {
        return this.mPropertiesPresent;
    }

    public int getShowInLauncher() {
        if (this.isPresent(0L)) {
            return this.mShowInLauncher;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mShowInLauncher;
        }
        throw new SecurityException("You don't have permission to query showInLauncher");
    }

    public void setShowInLauncher(int val) {
        this.mShowInLauncher = val;
        this.setPresent(0L);
    }

    public int getShowInSettings() {
        if (this.isPresent(2L)) {
            return this.mShowInSettings;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mShowInSettings;
        }
        throw new SecurityException("You don't have permission to query mShowInSettings");
    }

    public void setShowInSettings(int val) {
        this.mShowInSettings = val;
        this.setPresent(2L);
    }

    public boolean getStartWithParent() {
        if (this.isPresent(1L)) {
            return this.mStartWithParent;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mStartWithParent;
        }
        throw new SecurityException("You don't have permission to query startWithParent");
    }

    public void setStartWithParent(boolean val) {
        this.mStartWithParent = val;
        this.setPresent(1L);
    }

    public boolean getDeleteAppWithParent() {
        if (this.isPresent(10L)) {
            return this.mDeleteAppWithParent;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mDeleteAppWithParent;
        }
        throw new SecurityException("You don't have permission to query deleteAppWithParent");
    }

    public void setDeleteAppWithParent(boolean val) {
        this.mDeleteAppWithParent = val;
        this.setPresent(10L);
    }

    public int getInheritDevicePolicy() {
        if (this.isPresent(3L)) {
            return this.mInheritDevicePolicy;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mInheritDevicePolicy;
        }
        throw new SecurityException("You don't have permission to query inheritDevicePolicy");
    }

    public void setInheritDevicePolicy(int val) {
        this.mInheritDevicePolicy = val;
        this.setPresent(3L);
    }

    public boolean getUseParentsContacts() {
        if (this.isPresent(4L)) {
            return this.mUseParentsContacts;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mUseParentsContacts;
        }
        throw new SecurityException("You don't have permission to query useParentsContacts");
    }

    public void setUseParentsContacts(boolean val) {
        this.mUseParentsContacts = val;
        this.setPresent(4L);
    }

    public boolean getUpdateCrossProfileIntentFiltersOnOTA() {
        if (this.isPresent(5L)) {
            return this.mUpdateCrossProfileIntentFiltersOnOTA;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mUpdateCrossProfileIntentFiltersOnOTA;
        }
        throw new SecurityException("You don't have permission to query updateCrossProfileIntentFiltersOnOTA");
    }

    public void setUpdateCrossProfileIntentFiltersOnOTA(boolean val) {
        this.mUpdateCrossProfileIntentFiltersOnOTA = val;
        this.setPresent(5L);
    }

    public boolean isMediaSharedWithParent() {
        if (this.isPresent(8L)) {
            return this.mMediaSharedWithParent;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mMediaSharedWithParent;
        }
        throw new SecurityException("You don't have permission to query mediaSharedWithParent");
    }

    public void setMediaSharedWithParent(boolean val) {
        this.mMediaSharedWithParent = val;
        this.setPresent(8L);
    }

    public boolean isCredentialShareableWithParent() {
        if (this.isPresent(9L)) {
            return this.mCredentialShareableWithParent;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mCredentialShareableWithParent;
        }
        throw new SecurityException("You don't have permission to query credentialShareableWithParent");
    }

    public void setCredentialShareableWithParent(boolean val) {
        this.mCredentialShareableWithParent = val;
        this.setPresent(9L);
    }

    public int getCrossProfileIntentFilterAccessControl() {
        if (this.isPresent(6L)) {
            return this.mCrossProfileIntentFilterAccessControl;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mCrossProfileIntentFilterAccessControl;
        }
        throw new SecurityException("You don't have permission to query crossProfileIntentFilterAccessControl");
    }

    public void setCrossProfileIntentFilterAccessControl(int val) {
        this.mCrossProfileIntentFilterAccessControl = val;
        this.setPresent(6L);
    }

    public int getCrossProfileIntentResolutionStrategy() {
        if (this.isPresent(7L)) {
            return this.mCrossProfileIntentResolutionStrategy;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mCrossProfileIntentResolutionStrategy;
        }
        throw new SecurityException("You don't have permission to query crossProfileIntentResolutionStrategy");
    }

    public void setCrossProfileIntentResolutionStrategy(int val) {
        this.mCrossProfileIntentResolutionStrategy = val;
        this.setPresent(7L);
    }

    public String toString() {
        return "UserProperties{mPropertiesPresent=" + Long.toBinaryString(this.mPropertiesPresent) + ", mShowInLauncher=" + this.getShowInLauncher() + ", mStartWithParent=" + this.getStartWithParent() + ", mShowInSettings=" + this.getShowInSettings() + ", mInheritDevicePolicy=" + this.getInheritDevicePolicy() + ", mUseParentsContacts=" + this.getUseParentsContacts() + ", mUpdateCrossProfileIntentFiltersOnOTA=" + this.getUpdateCrossProfileIntentFiltersOnOTA() + ", mCrossProfileIntentFilterAccessControl=" + this.getCrossProfileIntentFilterAccessControl() + ", mCrossProfileIntentResolutionStrategy=" + this.getCrossProfileIntentResolutionStrategy() + ", mMediaSharedWithParent=" + this.isMediaSharedWithParent() + ", mCredentialShareableWithParent=" + this.isCredentialShareableWithParent() + ", mDeleteAppWithParent=" + this.getDeleteAppWithParent() + "}";
    }

    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "UserProperties:");
        pw.println(prefix + "    mPropertiesPresent=" + Long.toBinaryString(this.mPropertiesPresent));
        pw.println(prefix + "    mShowInLauncher=" + this.getShowInLauncher());
        pw.println(prefix + "    mStartWithParent=" + this.getStartWithParent());
        pw.println(prefix + "    mShowInSettings=" + this.getShowInSettings());
        pw.println(prefix + "    mInheritDevicePolicy=" + this.getInheritDevicePolicy());
        pw.println(prefix + "    mUseParentsContacts=" + this.getUseParentsContacts());
        pw.println(prefix + "    mUpdateCrossProfileIntentFiltersOnOTA=" + this.getUpdateCrossProfileIntentFiltersOnOTA());
        pw.println(prefix + "    mCrossProfileIntentFilterAccessControl=" + this.getCrossProfileIntentFilterAccessControl());
        pw.println(prefix + "    mCrossProfileIntentResolutionStrategy=" + this.getCrossProfileIntentResolutionStrategy());
        pw.println(prefix + "    mMediaSharedWithParent=" + this.isMediaSharedWithParent());
        pw.println(prefix + "    mCredentialShareableWithParent=" + this.isCredentialShareableWithParent());
        pw.println(prefix + "    mDeleteAppWithParent=" + this.getDeleteAppWithParent());
    }

    public UserProperties(TypedXmlPullParser parser, UserProperties defaultUserPropertiesReference) throws IOException, XmlPullParserException {
        this(defaultUserPropertiesReference);
        this.updateFromXml(parser);
    }

    public void updateFromXml(TypedXmlPullParser parser) throws IOException, XmlPullParserException {
        int attributeCount = parser.getAttributeCount();
        block26: for (int i = 0; i < attributeCount; ++i) {
            String attributeName;
            switch (attributeName = parser.getAttributeName(i)) {
                case "showInLauncher": {
                    this.setShowInLauncher(parser.getAttributeInt(i));
                    continue block26;
                }
                case "startWithParent": {
                    this.setStartWithParent(parser.getAttributeBoolean(i));
                    continue block26;
                }
                case "showInSettings": {
                    this.setShowInSettings(parser.getAttributeInt(i));
                    continue block26;
                }
                case "inheritDevicePolicy": {
                    this.setInheritDevicePolicy(parser.getAttributeInt(i));
                    continue block26;
                }
                case "useParentsContacts": {
                    this.setUseParentsContacts(parser.getAttributeBoolean(i));
                    continue block26;
                }
                case "updateCrossProfileIntentFiltersOnOTA": {
                    this.setUpdateCrossProfileIntentFiltersOnOTA(parser.getAttributeBoolean(i));
                    continue block26;
                }
                case "crossProfileIntentFilterAccessControl": {
                    this.setCrossProfileIntentFilterAccessControl(parser.getAttributeInt(i));
                    continue block26;
                }
                case "crossProfileIntentResolutionStrategy": {
                    this.setCrossProfileIntentResolutionStrategy(parser.getAttributeInt(i));
                    continue block26;
                }
                case "mediaSharedWithParent": {
                    this.setMediaSharedWithParent(parser.getAttributeBoolean(i));
                    continue block26;
                }
                case "credentialShareableWithParent": {
                    this.setCredentialShareableWithParent(parser.getAttributeBoolean(i));
                    continue block26;
                }
                case "deleteAppWithParent": {
                    this.setDeleteAppWithParent(parser.getAttributeBoolean(i));
                    continue block26;
                }
                default: {
                    Slog.w(LOG_TAG, "Skipping unknown property " + attributeName);
                }
            }
        }
    }

    public void writeToXml(TypedXmlSerializer serializer) throws IOException, XmlPullParserException {
        if (this.isPresent(0L)) {
            serializer.attributeInt(null, ATTR_SHOW_IN_LAUNCHER, this.mShowInLauncher);
        }
        if (this.isPresent(1L)) {
            serializer.attributeBoolean(null, ATTR_START_WITH_PARENT, this.mStartWithParent);
        }
        if (this.isPresent(2L)) {
            serializer.attributeInt(null, ATTR_SHOW_IN_SETTINGS, this.mShowInSettings);
        }
        if (this.isPresent(3L)) {
            serializer.attributeInt(null, ATTR_INHERIT_DEVICE_POLICY, this.mInheritDevicePolicy);
        }
        if (this.isPresent(4L)) {
            serializer.attributeBoolean(null, ATTR_USE_PARENTS_CONTACTS, this.mUseParentsContacts);
        }
        if (this.isPresent(5L)) {
            serializer.attributeBoolean(null, ATTR_UPDATE_CROSS_PROFILE_INTENT_FILTERS_ON_OTA, this.mUpdateCrossProfileIntentFiltersOnOTA);
        }
        if (this.isPresent(6L)) {
            serializer.attributeInt(null, ATTR_CROSS_PROFILE_INTENT_FILTER_ACCESS_CONTROL, this.mCrossProfileIntentFilterAccessControl);
        }
        if (this.isPresent(7L)) {
            serializer.attributeInt(null, ATTR_CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY, this.mCrossProfileIntentResolutionStrategy);
        }
        if (this.isPresent(8L)) {
            serializer.attributeBoolean(null, ATTR_MEDIA_SHARED_WITH_PARENT, this.mMediaSharedWithParent);
        }
        if (this.isPresent(9L)) {
            serializer.attributeBoolean(null, ATTR_CREDENTIAL_SHAREABLE_WITH_PARENT, this.mCredentialShareableWithParent);
        }
        if (this.isPresent(10L)) {
            serializer.attributeBoolean(null, ATTR_DELETE_APP_WITH_PARENT, this.mDeleteAppWithParent);
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeLong(this.mPropertiesPresent);
        dest.writeInt(this.mShowInLauncher);
        dest.writeBoolean(this.mStartWithParent);
        dest.writeInt(this.mShowInSettings);
        dest.writeInt(this.mInheritDevicePolicy);
        dest.writeBoolean(this.mUseParentsContacts);
        dest.writeBoolean(this.mUpdateCrossProfileIntentFiltersOnOTA);
        dest.writeInt(this.mCrossProfileIntentFilterAccessControl);
        dest.writeInt(this.mCrossProfileIntentResolutionStrategy);
        dest.writeBoolean(this.mMediaSharedWithParent);
        dest.writeBoolean(this.mCredentialShareableWithParent);
        dest.writeBoolean(this.mDeleteAppWithParent);
    }

    private UserProperties(Parcel source) {
        this.mDefaultProperties = null;
        this.mPropertiesPresent = source.readLong();
        this.mShowInLauncher = source.readInt();
        this.mStartWithParent = source.readBoolean();
        this.mShowInSettings = source.readInt();
        this.mInheritDevicePolicy = source.readInt();
        this.mUseParentsContacts = source.readBoolean();
        this.mUpdateCrossProfileIntentFiltersOnOTA = source.readBoolean();
        this.mCrossProfileIntentFilterAccessControl = source.readInt();
        this.mCrossProfileIntentResolutionStrategy = source.readInt();
        this.mMediaSharedWithParent = source.readBoolean();
        this.mCredentialShareableWithParent = source.readBoolean();
        this.mDeleteAppWithParent = source.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private UserProperties(int showInLauncher, boolean startWithParent, int showInSettings, int inheritDevicePolicy, boolean useParentsContacts, boolean updateCrossProfileIntentFiltersOnOTA, int crossProfileIntentFilterAccessControl, int crossProfileIntentResolutionStrategy, boolean mediaSharedWithParent, boolean credentialShareableWithParent, boolean deleteAppWithParent) {
        this.mDefaultProperties = null;
        this.setShowInLauncher(showInLauncher);
        this.setStartWithParent(startWithParent);
        this.setShowInSettings(showInSettings);
        this.setInheritDevicePolicy(inheritDevicePolicy);
        this.setUseParentsContacts(useParentsContacts);
        this.setUpdateCrossProfileIntentFiltersOnOTA(updateCrossProfileIntentFiltersOnOTA);
        this.setCrossProfileIntentFilterAccessControl(crossProfileIntentFilterAccessControl);
        this.setCrossProfileIntentResolutionStrategy(crossProfileIntentResolutionStrategy);
        this.setMediaSharedWithParent(mediaSharedWithParent);
        this.setCredentialShareableWithParent(credentialShareableWithParent);
        this.setDeleteAppWithParent(deleteAppWithParent);
    }

    public static class Builder {
        private int mShowInLauncher = 0;
        private boolean mStartWithParent = false;
        private int mShowInSettings = 0;
        private int mInheritDevicePolicy = 0;
        private boolean mUseParentsContacts = false;
        private boolean mUpdateCrossProfileIntentFiltersOnOTA = false;
        private int mCrossProfileIntentFilterAccessControl = 0;
        private int mCrossProfileIntentResolutionStrategy = 0;
        private boolean mMediaSharedWithParent = false;
        private boolean mCredentialShareableWithParent = false;
        private boolean mDeleteAppWithParent = false;

        public Builder setShowInLauncher(int showInLauncher) {
            this.mShowInLauncher = showInLauncher;
            return this;
        }

        public Builder setStartWithParent(boolean startWithParent) {
            this.mStartWithParent = startWithParent;
            return this;
        }

        public Builder setShowInSettings(int showInSettings) {
            this.mShowInSettings = showInSettings;
            return this;
        }

        public Builder setInheritDevicePolicy(int inheritRestrictionsDevicePolicy) {
            this.mInheritDevicePolicy = inheritRestrictionsDevicePolicy;
            return this;
        }

        public Builder setUseParentsContacts(boolean useParentsContacts) {
            this.mUseParentsContacts = useParentsContacts;
            return this;
        }

        public Builder setUpdateCrossProfileIntentFiltersOnOTA(boolean updateCrossProfileIntentFiltersOnOTA) {
            this.mUpdateCrossProfileIntentFiltersOnOTA = updateCrossProfileIntentFiltersOnOTA;
            return this;
        }

        public Builder setCrossProfileIntentFilterAccessControl(int crossProfileIntentFilterAccessControl) {
            this.mCrossProfileIntentFilterAccessControl = crossProfileIntentFilterAccessControl;
            return this;
        }

        public Builder setCrossProfileIntentResolutionStrategy(int crossProfileIntentResolutionStrategy) {
            this.mCrossProfileIntentResolutionStrategy = crossProfileIntentResolutionStrategy;
            return this;
        }

        public Builder setMediaSharedWithParent(boolean mediaSharedWithParent) {
            this.mMediaSharedWithParent = mediaSharedWithParent;
            return this;
        }

        public Builder setCredentialShareableWithParent(boolean credentialShareableWithParent) {
            this.mCredentialShareableWithParent = credentialShareableWithParent;
            return this;
        }

        public Builder setDeleteAppWithParent(boolean deleteAppWithParent) {
            this.mDeleteAppWithParent = deleteAppWithParent;
            return this;
        }

        public UserProperties build() {
            return new UserProperties(this.mShowInLauncher, this.mStartWithParent, this.mShowInSettings, this.mInheritDevicePolicy, this.mUseParentsContacts, this.mUpdateCrossProfileIntentFiltersOnOTA, this.mCrossProfileIntentFilterAccessControl, this.mCrossProfileIntentResolutionStrategy, this.mMediaSharedWithParent, this.mCredentialShareableWithParent, this.mDeleteAppWithParent);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CrossProfileIntentResolutionStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CrossProfileIntentFilterAccessControlLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InheritDevicePolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowInSettings {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowInLauncher {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface PropertyIndex {
    }
}

