/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Random;

public class VerifierDeviceIdentity
implements Parcelable {
    private static final int LONG_SIZE = 13;
    private static final int GROUP_SIZE = 4;
    private final long mIdentity;
    private final String mIdentityString;
    private static final char[] ENCODE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'};
    private static final char SEPARATOR = '-';
    public static final Parcelable.Creator<VerifierDeviceIdentity> CREATOR = new Parcelable.Creator<VerifierDeviceIdentity>(){

        @Override
        public VerifierDeviceIdentity createFromParcel(Parcel source) {
            return new VerifierDeviceIdentity(source);
        }

        public VerifierDeviceIdentity[] newArray(int size) {
            return new VerifierDeviceIdentity[size];
        }
    };

    public VerifierDeviceIdentity(long identity) {
        this.mIdentity = identity;
        this.mIdentityString = VerifierDeviceIdentity.encodeBase32(identity);
    }

    private VerifierDeviceIdentity(Parcel source) {
        long identity;
        this.mIdentity = identity = source.readLong();
        this.mIdentityString = VerifierDeviceIdentity.encodeBase32(identity);
    }

    public static VerifierDeviceIdentity generate() {
        SecureRandom sr = new SecureRandom();
        return VerifierDeviceIdentity.generate(sr);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static VerifierDeviceIdentity generate(Random rng) {
        long identity = rng.nextLong();
        return new VerifierDeviceIdentity(identity);
    }

    private static String encodeBase32(long input) {
        char[] alphabet = ENCODE;
        char[] encoded = new char[16];
        int index = encoded.length;
        for (int i = 0; i < 13; ++i) {
            if (i > 0 && i % 4 == 1) {
                encoded[--index] = 45;
            }
            int group = (int)(input & 0x1FL);
            input >>>= 5;
            encoded[--index] = alphabet[group];
        }
        return String.valueOf(encoded);
    }

    private static long decodeBase32(byte[] input) throws IllegalArgumentException {
        long output = 0L;
        int numParsed = 0;
        for (byte group : input) {
            int value;
            if (65 <= group && group <= 90) {
                value = group - 65;
            } else if (50 <= group && group <= 55) {
                value = group - 24;
            } else {
                if (group == 45) continue;
                if (97 <= group && group <= 122) {
                    value = group - 97;
                } else if (group == 48) {
                    value = 14;
                } else if (group == 49) {
                    value = 8;
                } else {
                    throw new IllegalArgumentException("base base-32 character: " + group);
                }
            }
            output = output << 5 | (long)value;
            if (++numParsed == 1) {
                if ((value & 0xF) == value) continue;
                throw new IllegalArgumentException("illegal start character; will overflow");
            }
            if (numParsed <= 13) continue;
            throw new IllegalArgumentException("too long; should have 13 characters");
        }
        if (numParsed != 13) {
            throw new IllegalArgumentException("too short; should have 13 characters");
        }
        return output;
    }

    public int hashCode() {
        return (int)this.mIdentity;
    }

    public boolean equals(Object other) {
        if (!(other instanceof VerifierDeviceIdentity)) {
            return false;
        }
        VerifierDeviceIdentity o = (VerifierDeviceIdentity)other;
        return this.mIdentity == o.mIdentity;
    }

    public String toString() {
        return this.mIdentityString;
    }

    public static VerifierDeviceIdentity parse(String deviceIdentity) throws IllegalArgumentException {
        byte[] input;
        try {
            input = deviceIdentity.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("bad base-32 characters in input");
        }
        return new VerifierDeviceIdentity(VerifierDeviceIdentity.decodeBase32(input));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mIdentity);
    }
}

