/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.FontScaleConverter;
import android.util.MathUtils;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;

public class FontScaleConverterFactory {
    private static final float SCALE_KEY_MULTIPLIER = 100.0f;
    @VisibleForTesting
    static final SparseArray<FontScaleConverter> LOOKUP_TABLES = new SparseArray();
    private static float sMinScaleBeforeCurvesApplied = 1.05f;

    private FontScaleConverterFactory() {
    }

    public static boolean isNonLinearFontScalingActive(float fontScale) {
        return fontScale >= sMinScaleBeforeCurvesApplied;
    }

    public static FontScaleConverter forScale(float fontScale) {
        if (!FontScaleConverterFactory.isNonLinearFontScalingActive(fontScale)) {
            return null;
        }
        FontScaleConverter lookupTable = FontScaleConverterFactory.get(fontScale);
        if (lookupTable != null) {
            return lookupTable;
        }
        int index = LOOKUP_TABLES.indexOfKey(FontScaleConverterFactory.getKey(fontScale));
        if (index >= 0) {
            return LOOKUP_TABLES.valueAt(index);
        }
        int lowerIndex = -(index + 1) - 1;
        int higherIndex = lowerIndex + 1;
        if (lowerIndex < 0 || higherIndex >= LOOKUP_TABLES.size()) {
            return new FontScaleConverter(new float[]{1.0f}, new float[]{fontScale});
        }
        float startScale = FontScaleConverterFactory.getScaleFromKey(LOOKUP_TABLES.keyAt(lowerIndex));
        float endScale = FontScaleConverterFactory.getScaleFromKey(LOOKUP_TABLES.keyAt(higherIndex));
        float interpolationPoint = MathUtils.constrainedMap(0.0f, 1.0f, startScale, endScale, fontScale);
        return FontScaleConverterFactory.createInterpolatedTableBetween(LOOKUP_TABLES.valueAt(lowerIndex), LOOKUP_TABLES.valueAt(higherIndex), interpolationPoint);
    }

    private static FontScaleConverter createInterpolatedTableBetween(FontScaleConverter start, FontScaleConverter end, float interpolationPoint) {
        float[] commonSpSizes = new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f};
        float[] dpInterpolated = new float[commonSpSizes.length];
        for (int i = 0; i < commonSpSizes.length; ++i) {
            float sp = commonSpSizes[i];
            float startDp = start.convertSpToDp(sp);
            float endDp = end.convertSpToDp(sp);
            dpInterpolated[i] = MathUtils.lerp(startDp, endDp, interpolationPoint);
        }
        return new FontScaleConverter(commonSpSizes, dpInterpolated);
    }

    private static int getKey(float fontScale) {
        return (int)(fontScale * 100.0f);
    }

    private static float getScaleFromKey(int key) {
        return (float)key / 100.0f;
    }

    private static void put(float scaleKey, FontScaleConverter fontScaleConverter) {
        LOOKUP_TABLES.put(FontScaleConverterFactory.getKey(scaleKey), fontScaleConverter);
    }

    private static FontScaleConverter get(float scaleKey) {
        return LOOKUP_TABLES.get(FontScaleConverterFactory.getKey(scaleKey));
    }

    static {
        FontScaleConverterFactory.put(1.15f, new FontScaleConverter(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{9.2f, 11.5f, 13.8f, 16.4f, 19.8f, 21.8f, 25.2f, 30.0f, 100.0f}));
        FontScaleConverterFactory.put(1.3f, new FontScaleConverter(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{10.4f, 13.0f, 15.6f, 18.8f, 21.6f, 23.6f, 26.4f, 30.0f, 100.0f}));
        FontScaleConverterFactory.put(1.5f, new FontScaleConverter(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{12.0f, 15.0f, 18.0f, 22.0f, 24.0f, 26.0f, 28.0f, 30.0f, 100.0f}));
        FontScaleConverterFactory.put(1.8f, new FontScaleConverter(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{14.4f, 18.0f, 21.6f, 24.4f, 27.6f, 30.8f, 32.8f, 34.8f, 100.0f}));
        FontScaleConverterFactory.put(2.0f, new FontScaleConverter(new float[]{8.0f, 10.0f, 12.0f, 14.0f, 18.0f, 20.0f, 24.0f, 30.0f, 100.0f}, new float[]{16.0f, 20.0f, 24.0f, 26.0f, 30.0f, 34.0f, 36.0f, 38.0f, 100.0f}));
        sMinScaleBeforeCurvesApplied = FontScaleConverterFactory.getScaleFromKey(LOOKUP_TABLES.keyAt(0)) - 0.02f;
        if (sMinScaleBeforeCurvesApplied <= 1.0f) {
            throw new IllegalStateException("You should only apply non-linear scaling to font scales > 1");
        }
    }
}

