/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FrameworkStatsLog;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;

public class ResourceTimer {
    private static final String TAG = "ResourceTimer";
    private static boolean sEnabled = true;
    private static boolean sIncrementalMetrics = true;
    private static boolean ENABLE_DEBUG = false;
    private static final Object sLock = new Object();
    private static ResourceTimer sManager;
    private static Handler mHandler;
    private static final long sProcessStart;
    private static final long[] sPublicationPoints;
    private static int sCurrentPoint;
    @GuardedBy(value={"sLock"})
    private static Config sConfig;
    @GuardedBy(value={"sLock"})
    private static int[] sApiMap;
    @GuardedBy(value={"sLock"})
    private static Timer[] sTimers;
    @GuardedBy(value={"sLock"})
    private static long sLastUpdated;

    private ResourceTimer() {
        throw new RuntimeException("ResourceTimer constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = sLock;
        synchronized (object) {
            int i;
            if (!sEnabled) {
                return;
            }
            if (mHandler != null) {
                return;
            }
            if (Looper.getMainLooper() == null) {
                throw new RuntimeException("ResourceTimer started too early");
            }
            mHandler = new Handler(Looper.getMainLooper()){

                @Override
                public void handleMessage(Message msg) {
                    ResourceTimer.handleMessage(msg);
                }
            };
            sConfig = new Config();
            ResourceTimer.nativeEnableTimers(sConfig);
            sTimers = new Timer[ResourceTimer.sConfig.maxTimer];
            for (i = 0; i < sTimers.length; ++i) {
                ResourceTimer.sTimers[i] = new Timer();
                ResourceTimer.sTimers[i].percentile = new int[ResourceTimer.sConfig.maxBuckets];
                ResourceTimer.sTimers[i].largest = new int[ResourceTimer.sConfig.maxLargest];
            }
            sApiMap = new int[ResourceTimer.sConfig.maxTimer];
            for (i = 0; i < sApiMap.length; ++i) {
                ResourceTimer.sApiMap[i] = ResourceTimer.sConfig.timers[i].equals("GetResourceValue") ? 1 : (ResourceTimer.sConfig.timers[i].equals("RetrieveAttributes") ? 2 : 0);
            }
            sCurrentPoint = 0;
            ResourceTimer.startTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleMessage(Message msg) {
        Object object = sLock;
        synchronized (object) {
            ResourceTimer.publish();
            ResourceTimer.startTimer();
        }
    }

    @GuardedBy(value={"sLock"})
    private static void startTimer() {
        long delay;
        if (sCurrentPoint < sPublicationPoints.length) {
            delay = sPublicationPoints[sCurrentPoint];
        } else {
            long repeated = sPublicationPoints[sPublicationPoints.length - 1];
            int prelude = sPublicationPoints.length - 1;
            delay = (long)(sCurrentPoint - prelude) * repeated;
        }
        delay *= 60000L;
        if (ENABLE_DEBUG) {
            delay /= 60L;
        }
        mHandler.sendEmptyMessageAtTime(0, sProcessStart + delay);
    }

    @GuardedBy(value={"sLock"})
    private static void update(boolean reset) {
        ResourceTimer.nativeGetTimers(sTimers, reset);
        sLastUpdated = SystemClock.uptimeMillis();
    }

    @GuardedBy(value={"sLock"})
    private static void publish() {
        ResourceTimer.update(true);
        for (int i = 0; i < sTimers.length; ++i) {
            Timer timer = sTimers[i];
            if (timer.count <= 0) continue;
            Log.i(TAG, TextUtils.formatSimple("%s count=%d pvalues=%s", ResourceTimer.sConfig.timers[i], timer.count, ResourceTimer.packedString(timer.percentile)));
            if (sApiMap[i] == 0) continue;
            FrameworkStatsLog.write(517, sApiMap[i], timer.count, timer.total, timer.percentile[0], timer.percentile[1], timer.percentile[2], timer.percentile[3], timer.largest[0], timer.largest[1], timer.largest[2], timer.largest[3], timer.largest[4]);
        }
        ++sCurrentPoint;
    }

    private static String packedString(int[] a) {
        return Arrays.toString(a).replaceAll("[\\]\\[ ]", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpTimers(ParcelFileDescriptor pfd, String[] args) {
        FileOutputStream fout = new FileOutputStream(pfd.getFileDescriptor());
        FastPrintWriter pw = new FastPrintWriter(fout);
        Object object = sLock;
        synchronized (object) {
            if (!sEnabled || sConfig == null) {
                pw.println("  Timers are not enabled in this process");
                ((PrintWriter)pw).flush();
                return;
            }
        }
        boolean refresh = Arrays.asList(args).contains("-refresh");
        Object object2 = sLock;
        synchronized (object2) {
            ResourceTimer.update(refresh);
            long runtime = sLastUpdated - sProcessStart;
            pw.format("  config runtime=%d proc=%s\n", runtime, Process.myProcessName());
            for (int i = 0; i < sTimers.length; ++i) {
                Timer t = sTimers[i];
                if (t.count == 0) continue;
                String name = ResourceTimer.sConfig.timers[i];
                pw.format("  stats timer=%s cnt=%d avg=%d min=%d max=%d pval=%s largest=%s\n", name, t.count, t.total / (long)t.count, t.mintime, t.maxtime, ResourceTimer.packedString(t.percentile), ResourceTimer.packedString(t.largest));
            }
        }
        ((PrintWriter)pw).flush();
    }

    private static int nativeEnableTimers(Config config) {
        return OverrideMethod.invokeI("android.content.res.ResourceTimer#nativeEnableTimers(Landroid/content/res/ResourceTimer$Config;)I", true, null);
    }

    private static int nativeGetTimers(Timer[] timerArray, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.ResourceTimer#nativeGetTimers([Landroid/content/res/ResourceTimer$Timer;Z)I", true, null);
    }

    static {
        sProcessStart = SystemClock.uptimeMillis();
        sPublicationPoints = new long[]{5L, 60L, 720L};
        sLastUpdated = 0L;
    }

    private static class Config {
        int maxTimer;
        int maxBuckets;
        int maxLargest;
        String[] timers;

        private Config() {
        }
    }

    private static class Timer {
        int count;
        long total;
        int mintime;
        int maxtime;
        int[] largest;
        int[] percentile;

        private Timer() {
        }

        public String toString() {
            return TextUtils.formatSimple("%d:%d:%d:%d", this.count, this.total, this.mintime, this.maxtime);
        }
    }
}

