/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.animation.Animator;
import android.animation.StateListAnimator;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.ComplexColor;
import android.content.res.Configuration;
import android.content.res.ConfigurationBoundResourceCache;
import android.content.res.ResourcesImpl;
import android.content.res.Resources_Delegate;
import android.content.res.Resources_Theme_Delegate;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.content.res.loader.ResourcesLoader;
import android.graphics.Movie;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableInflater;
import android.os.Bundle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pools;
import android.util.TypedValue;
import android.view.DisplayAdjustments;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.java.Reference_Delegate;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParserException;

public class Resources {
    public static final int ID_NULL = 0;
    static final String TAG = "Resources";
    private static final Object sSync = new Object();
    private final Object mUpdateLock = new Object();
    @UnsupportedAppUsage
    static Resources mSystem = null;
    @UnsupportedAppUsage
    private ResourcesImpl mResourcesImpl;
    @UnsupportedAppUsage
    final Pools.SynchronizedPool<TypedArray> mTypedArrayPool = new Pools.SynchronizedPool(5);
    @UnsupportedAppUsage
    private DrawableInflater mDrawableInflater;
    private final Object mTmpValueLock = new Object();
    @UnsupportedAppUsage
    private TypedValue mTmpValue = new TypedValue();
    @UnsupportedAppUsage
    final ClassLoader mClassLoader;
    @GuardedBy(value={"mUpdateLock"})
    private UpdateCallbacks mCallbacks = null;
    private final ArrayList<WeakReference<Theme>> mThemeRefs = new ArrayList();
    private static final int MIN_THEME_REFS_FLUSH_SIZE = 32;
    private static final int MAX_THEME_REFS_FLUSH_SIZE = 512;
    private int mThemeRefsNextFlushSize = 32;
    private int mBaseApkAssetsSize;
    private static Set<Resources> sResourcesHistory = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    @UnsupportedAppUsage
    public static int selectDefaultTheme(int curTheme, int targetSdkVersion) {
        return Resources.selectSystemTheme(curTheme, targetSdkVersion, 16973829, 16973931, 16974120, 16974143);
    }

    public static int selectSystemTheme(int curTheme, int targetSdkVersion, int orig, int holo, int dark, int deviceDefault) {
        if (curTheme != 0) {
            return curTheme;
        }
        if (targetSdkVersion < 11) {
            return orig;
        }
        if (targetSdkVersion < 14) {
            return holo;
        }
        if (targetSdkVersion < 24) {
            return dark;
        }
        return deviceDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources getSystem() {
        Object object = sSync;
        synchronized (object) {
            Resources ret = mSystem;
            if (ret == null) {
                mSystem = ret = new Resources();
            }
            return ret;
        }
    }

    @Deprecated
    public Resources(AssetManager assets, DisplayMetrics metrics, Configuration config) {
        this(null);
        this.mResourcesImpl = new ResourcesImpl(assets, metrics, config, new DisplayAdjustments());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Resources(ClassLoader classLoader) {
        this.mClassLoader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        sResourcesHistory.add(this);
    }

    @UnsupportedAppUsage
    private Resources() {
        this(null);
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.setToDefaults();
        Configuration config = new Configuration();
        config.setToDefaults();
        this.mResourcesImpl = new ResourcesImpl(AssetManager.getSystem(), metrics, config, new DisplayAdjustments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void setImpl(ResourcesImpl impl) {
        if (impl == this.mResourcesImpl) {
            return;
        }
        this.mBaseApkAssetsSize = ArrayUtils.size(impl.getAssets().getApkAssets());
        this.mResourcesImpl = impl;
        ArrayList<WeakReference<Theme>> arrayList = this.mThemeRefs;
        synchronized (arrayList) {
            this.cleanupThemeReferences();
            int count = this.mThemeRefs.size();
            for (int i = 0; i < count; ++i) {
                Theme theme = (Theme)this.mThemeRefs.get(i).get();
                if (theme == null) continue;
                theme.rebase(this.mResourcesImpl);
            }
        }
    }

    public void setCallbacks(UpdateCallbacks callbacks) {
        if (this.mCallbacks != null) {
            throw new IllegalStateException("callback already registered");
        }
        this.mCallbacks = callbacks;
    }

    @UnsupportedAppUsage
    public ResourcesImpl getImpl() {
        return this.mResourcesImpl;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public DrawableInflater getDrawableInflater() {
        if (this.mDrawableInflater == null) {
            this.mDrawableInflater = new DrawableInflater(this, this.mClassLoader);
        }
        return this.mDrawableInflater;
    }

    public ConfigurationBoundResourceCache<Animator> getAnimatorCache() {
        return this.mResourcesImpl.getAnimatorCache();
    }

    public ConfigurationBoundResourceCache<StateListAnimator> getStateListAnimatorCache() {
        return this.mResourcesImpl.getStateListAnimatorCache();
    }

    public CharSequence getText_Original(int id2) throws NotFoundException {
        CharSequence res = this.mResourcesImpl.getAssets().getResourceText(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(id2));
    }

    @LayoutlibDelegate
    public CharSequence getText(int n) throws NotFoundException {
        return Resources_Delegate.getText(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Typeface getFont_Original(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            Typeface typeface = impl.loadFont(this, value, id2);
            if (typeface != null) {
                Typeface typeface2 = typeface;
                return typeface2;
            }
        }
        finally {
            this.releaseTempTypedValue(value);
        }
        throw new NotFoundException("Font resource ID #0x" + Integer.toHexString(id2));
    }

    @LayoutlibDelegate
    public Typeface getFont(int n) throws NotFoundException {
        return Resources_Delegate.getFont(this, n);
    }

    Typeface getFont_Original(TypedValue value, int id2) throws NotFoundException {
        return this.mResourcesImpl.loadFont(this, value, id2);
    }

    @LayoutlibDelegate
    Typeface getFont(TypedValue typedValue, int n) throws NotFoundException {
        return Resources_Delegate.getFont(this, typedValue, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadFonts(int id2) {
        TypedArray array2 = this.obtainTypedArray(id2);
        try {
            int size = array2.length();
            for (int i = 0; i < size; ++i) {
                array2.getFont(i);
            }
        }
        finally {
            array2.recycle();
        }
    }

    public CharSequence getQuantityText_Original(int id2, int quantity) throws NotFoundException {
        return this.mResourcesImpl.getQuantityText(id2, quantity);
    }

    @LayoutlibDelegate
    public CharSequence getQuantityText(int n, int n2) throws NotFoundException {
        return Resources_Delegate.getQuantityText(this, n, n2);
    }

    public String getString_Original(int id2) throws NotFoundException {
        return this.getText(id2).toString();
    }

    @LayoutlibDelegate
    public String getString(int n) throws NotFoundException {
        return Resources_Delegate.getString(this, n);
    }

    public String getString_Original(int id2, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getString(id2);
        return String.format(this.mResourcesImpl.getConfiguration().getLocales().get(0), raw2, formatArgs);
    }

    @LayoutlibDelegate
    public String getString(int n, Object ... objectArray) throws NotFoundException {
        return Resources_Delegate.getString(this, n, objectArray);
    }

    public String getQuantityString_Original(int id2, int quantity, Object ... formatArgs) throws NotFoundException {
        String raw2 = this.getQuantityText(id2, quantity).toString();
        return String.format(this.mResourcesImpl.getConfiguration().getLocales().get(0), raw2, formatArgs);
    }

    @LayoutlibDelegate
    public String getQuantityString(int n, int n2, Object ... objectArray) throws NotFoundException {
        return Resources_Delegate.getQuantityString(this, n, n2, objectArray);
    }

    public String getQuantityString_Original(int id2, int quantity) throws NotFoundException {
        return this.getQuantityText(id2, quantity).toString();
    }

    @LayoutlibDelegate
    public String getQuantityString(int n, int n2) throws NotFoundException {
        return Resources_Delegate.getQuantityString(this, n, n2);
    }

    public CharSequence getText_Original(int id2, CharSequence def) {
        CharSequence res = id2 != 0 ? this.mResourcesImpl.getAssets().getResourceText(id2) : null;
        return res != null ? res : def;
    }

    @LayoutlibDelegate
    public CharSequence getText(int n, CharSequence charSequence) {
        return Resources_Delegate.getText(this, n, charSequence);
    }

    public CharSequence[] getTextArray_Original(int id2) throws NotFoundException {
        CharSequence[] res = this.mResourcesImpl.getAssets().getResourceTextArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Text array resource ID #0x" + Integer.toHexString(id2));
    }

    @LayoutlibDelegate
    public CharSequence[] getTextArray(int n) throws NotFoundException {
        return Resources_Delegate.getTextArray(this, n);
    }

    public String[] getStringArray_Original(int id2) throws NotFoundException {
        String[] res = this.mResourcesImpl.getAssets().getResourceStringArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("String array resource ID #0x" + Integer.toHexString(id2));
    }

    @LayoutlibDelegate
    public String[] getStringArray(int n) throws NotFoundException {
        return Resources_Delegate.getStringArray(this, n);
    }

    public int[] getIntArray_Original(int id2) throws NotFoundException {
        int[] res = this.mResourcesImpl.getAssets().getResourceIntArray(id2);
        if (res != null) {
            return res;
        }
        throw new NotFoundException("Int array resource ID #0x" + Integer.toHexString(id2));
    }

    @LayoutlibDelegate
    public int[] getIntArray(int n) throws NotFoundException {
        return Resources_Delegate.getIntArray(this, n);
    }

    public TypedArray obtainTypedArray_Original(int id2) throws NotFoundException {
        ResourcesImpl impl = this.mResourcesImpl;
        int len = impl.getAssets().getResourceArraySize(id2);
        if (len < 0) {
            throw new NotFoundException("Array resource ID #0x" + Integer.toHexString(id2));
        }
        TypedArray array2 = TypedArray.obtain(this, len);
        array2.mLength = impl.getAssets().getResourceArray(id2, array2.mData);
        array2.mIndices[0] = 0;
        return array2;
    }

    @LayoutlibDelegate
    public TypedArray obtainTypedArray(int n) throws NotFoundException {
        return Resources_Delegate.obtainTypedArray(this, n);
    }

    public float getDimension_Original(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                float f = TypedValue.complexToDimension(value.data, impl.getDisplayMetrics());
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public float getDimension(int n) throws NotFoundException {
        return Resources_Delegate.getDimension(this, n);
    }

    public int getDimensionPixelOffset_Original(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                int n = TypedValue.complexToDimensionPixelOffset(value.data, impl.getDisplayMetrics());
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public int getDimensionPixelOffset(int n) throws NotFoundException {
        return Resources_Delegate.getDimensionPixelOffset(this, n);
    }

    public int getDimensionPixelSize_Original(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 5) {
                int n = TypedValue.complexToDimensionPixelSize(value.data, impl.getDisplayMetrics());
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public int getDimensionPixelSize(int n) throws NotFoundException {
        return Resources_Delegate.getDimensionPixelSize(this, n);
    }

    public float getFraction(int id2, int base, int pbase) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type == 6) {
                float f = TypedValue.complexToFraction(value.data, base, pbase);
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @Deprecated
    public Drawable getDrawable_Original(int id2) throws NotFoundException {
        Drawable d = this.getDrawable(id2, null);
        if (d != null && d.canApplyTheme()) {
            Log.w(TAG, "Drawable " + this.getResourceName(id2) + " has unresolved theme attributes! Consider using Resources.getDrawable(int, Theme) or Context.getDrawable(int).", new RuntimeException());
        }
        return d;
    }

    @LayoutlibDelegate
    public Drawable getDrawable(int n) throws NotFoundException {
        return Resources_Delegate.getDrawable(this, n);
    }

    public Drawable getDrawable_Original(int id2, Theme theme) throws NotFoundException {
        return this.getDrawableForDensity(id2, 0, theme);
    }

    @LayoutlibDelegate
    public Drawable getDrawable(int n, Theme theme) throws NotFoundException {
        return Resources_Delegate.getDrawable(this, n, theme);
    }

    @Deprecated
    public Drawable getDrawableForDensity(int id2, int density) throws NotFoundException {
        return this.getDrawableForDensity(id2, density, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Drawable getDrawableForDensity(int id2, int density, Theme theme) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValueForDensity(id2, density, value, true);
            Drawable drawable2 = this.loadDrawable(value, id2, density, theme);
            return drawable2;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    Drawable loadDrawable(TypedValue value, int id2, int density, Theme theme) throws NotFoundException {
        return this.mResourcesImpl.loadDrawable(this, value, id2, density, theme);
    }

    @Deprecated
    public Movie getMovie(int id2) throws NotFoundException {
        InputStream is = this.openRawResource(id2);
        Movie movie = Movie.decodeStream(is);
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return movie;
    }

    @Deprecated
    public int getColor_Original(int id2) throws NotFoundException {
        return this.getColor(id2, null);
    }

    @LayoutlibDelegate
    public int getColor(int n) throws NotFoundException {
        return Resources_Delegate.getColor(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColor_Original(int id2, Theme theme) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                int n = value.data;
                return n;
            }
            if (value.type != 3) {
                throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
            }
            ColorStateList csl = impl.loadColorStateList(this, value, id2, theme);
            int n = csl.getDefaultColor();
            return n;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public int getColor(int n, Theme theme) throws NotFoundException {
        return Resources_Delegate.getColor(this, n, theme);
    }

    @Deprecated
    public ColorStateList getColorStateList_Original(int id2) throws NotFoundException {
        ColorStateList csl = this.getColorStateList(id2, null);
        if (csl != null && csl.canApplyTheme()) {
            Log.w(TAG, "ColorStateList " + this.getResourceName(id2) + " has unresolved theme attributes! Consider using Resources.getColorStateList(int, Theme) or Context.getColorStateList(int).", new RuntimeException());
        }
        return csl;
    }

    @LayoutlibDelegate
    public ColorStateList getColorStateList(int n) throws NotFoundException {
        return Resources_Delegate.getColorStateList(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorStateList getColorStateList_Original(int id2, Theme theme) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            ColorStateList colorStateList = impl.loadColorStateList(this, value, id2, theme);
            return colorStateList;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public ColorStateList getColorStateList(int n, Theme theme) throws NotFoundException {
        return Resources_Delegate.getColorStateList(this, n, theme);
    }

    ColorStateList loadColorStateList(TypedValue value, int id2, Theme theme) throws NotFoundException {
        return this.mResourcesImpl.loadColorStateList(this, value, id2, theme);
    }

    public ComplexColor loadComplexColor(TypedValue value, int id2, Theme theme) {
        return this.mResourcesImpl.loadComplexColor(this, value, id2, theme);
    }

    public boolean getBoolean_Original(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                boolean bl = value.data != 0;
                return bl;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public boolean getBoolean(int n) throws NotFoundException {
        return Resources_Delegate.getBoolean(this, n);
    }

    public int getInteger_Original(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type >= 16 && value.type <= 31) {
                int n = value.data;
                return n;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public int getInteger(int n) throws NotFoundException {
        return Resources_Delegate.getInteger(this, n);
    }

    public float getFloat_Original(int id2) {
        TypedValue value = this.obtainTempTypedValue();
        try {
            this.mResourcesImpl.getValue(id2, value, true);
            if (value.type == 4) {
                float f = value.getFloat();
                return f;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public float getFloat(int n) {
        return Resources_Delegate.getFloat(this, n);
    }

    public XmlResourceParser getLayout_Original(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "layout");
    }

    @LayoutlibDelegate
    public XmlResourceParser getLayout(int n) throws NotFoundException {
        return Resources_Delegate.getLayout(this, n);
    }

    public XmlResourceParser getAnimation_Original(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "anim");
    }

    @LayoutlibDelegate
    public XmlResourceParser getAnimation(int n) throws NotFoundException {
        return Resources_Delegate.getAnimation(this, n);
    }

    public XmlResourceParser getXml_Original(int id2) throws NotFoundException {
        return this.loadXmlResourceParser(id2, "xml");
    }

    @LayoutlibDelegate
    public XmlResourceParser getXml(int n) throws NotFoundException {
        return Resources_Delegate.getXml(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openRawResource_Original(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            InputStream inputStream = this.openRawResource(id2, value);
            return inputStream;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public InputStream openRawResource(int n) throws NotFoundException {
        return Resources_Delegate.openRawResource(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypedValue obtainTempTypedValue() {
        TypedValue tmpValue = null;
        Object object = this.mTmpValueLock;
        synchronized (object) {
            if (this.mTmpValue != null) {
                tmpValue = this.mTmpValue;
                this.mTmpValue = null;
            }
        }
        if (tmpValue == null) {
            return new TypedValue();
        }
        return tmpValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTempTypedValue(TypedValue value) {
        Object object = this.mTmpValueLock;
        synchronized (object) {
            if (this.mTmpValue == null) {
                this.mTmpValue = value;
            }
        }
    }

    public InputStream openRawResource_Original(int id2, TypedValue value) throws NotFoundException {
        return this.mResourcesImpl.openRawResource(id2, value);
    }

    @LayoutlibDelegate
    public InputStream openRawResource(int n, TypedValue typedValue) throws NotFoundException {
        return Resources_Delegate.openRawResource(this, n, typedValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openRawResourceFd_Original(int id2) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            AssetFileDescriptor assetFileDescriptor = this.mResourcesImpl.openRawResourceFd(id2, value);
            return assetFileDescriptor;
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    public AssetFileDescriptor openRawResourceFd(int n) throws NotFoundException {
        return Resources_Delegate.openRawResourceFd(this, n);
    }

    public void getValue_Original(int id2, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValue(id2, outValue, resolveRefs);
    }

    @LayoutlibDelegate
    public void getValue(int n, TypedValue typedValue, boolean bl) throws NotFoundException {
        Resources_Delegate.getValue(this, n, typedValue, bl);
    }

    public void getValueForDensity_Original(int id2, int density, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValueForDensity(id2, density, outValue, resolveRefs);
    }

    @LayoutlibDelegate
    public void getValueForDensity(int n, int n2, TypedValue typedValue, boolean bl) throws NotFoundException {
        Resources_Delegate.getValueForDensity(this, n, n2, typedValue, bl);
    }

    public void getValue_Original(String name, TypedValue outValue, boolean resolveRefs) throws NotFoundException {
        this.mResourcesImpl.getValue(name, outValue, resolveRefs);
    }

    @LayoutlibDelegate
    public void getValue(String string2, TypedValue typedValue, boolean bl) throws NotFoundException {
        Resources_Delegate.getValue(this, string2, typedValue, bl);
    }

    public static int getAttributeSetSourceResId_Original(AttributeSet set) {
        return ResourcesImpl.getAttributeSetSourceResId(set);
    }

    @LayoutlibDelegate
    public static int getAttributeSetSourceResId(AttributeSet attributeSet) {
        return Resources_Delegate.getAttributeSetSourceResId(attributeSet);
    }

    static int nextPowerOf2(int number) {
        return number < 2 ? 2 : 1 >> (int)(Math.log(number - 1) / Math.log(2.0)) + 1;
    }

    private void cleanupThemeReferences() {
        if (this.mThemeRefs.size() > this.mThemeRefsNextFlushSize) {
            this.mThemeRefs.removeIf(ref -> Reference_Delegate.refersTo(ref, null));
            this.mThemeRefsNextFlushSize = Math.min(Math.max(32, Resources.nextPowerOf2(this.mThemeRefs.size())), 512);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Theme newTheme() {
        Theme theme = new Theme();
        theme.setImpl(this.mResourcesImpl.newThemeImpl());
        ArrayList<WeakReference<Theme>> arrayList = this.mThemeRefs;
        synchronized (arrayList) {
            this.cleanupThemeReferences();
            this.mThemeRefs.add(new WeakReference<Theme>(theme));
        }
        return theme;
    }

    public TypedArray obtainAttributes_Original(AttributeSet set, int[] attrs) {
        int len = attrs.length;
        TypedArray array2 = TypedArray.obtain(this, len);
        XmlBlock.Parser parser = (XmlBlock.Parser)set;
        this.mResourcesImpl.getAssets().retrieveAttributes(parser, attrs, array2.mData, array2.mIndices);
        array2.mXml = parser;
        return array2;
    }

    @LayoutlibDelegate
    public TypedArray obtainAttributes(AttributeSet attributeSet, int[] nArray) {
        return Resources_Delegate.obtainAttributes(this, attributeSet, nArray);
    }

    @Deprecated
    public void updateConfiguration(Configuration config, DisplayMetrics metrics) {
        this.updateConfiguration(config, metrics, null);
    }

    public void updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        this.mResourcesImpl.updateConfiguration(config, metrics, compat);
    }

    @UnsupportedAppUsage
    public static void updateSystemConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        if (mSystem != null) {
            mSystem.updateConfiguration(config, metrics, compat);
        }
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mResourcesImpl.getDisplayMetrics();
    }

    @UnsupportedAppUsage(trackingBug=176190631L)
    public DisplayAdjustments getDisplayAdjustments() {
        return this.mResourcesImpl.getDisplayAdjustments();
    }

    public boolean hasOverrideDisplayAdjustments() {
        return false;
    }

    public Configuration getConfiguration() {
        return this.mResourcesImpl.getConfiguration();
    }

    public Configuration[] getSizeConfigurations() {
        return this.mResourcesImpl.getSizeConfigurations();
    }

    public Configuration[] getSizeAndUiModeConfigurations() {
        return this.mResourcesImpl.getSizeAndUiModeConfigurations();
    }

    @UnsupportedAppUsage
    public CompatibilityInfo getCompatibilityInfo() {
        return this.mResourcesImpl.getCompatibilityInfo();
    }

    @VisibleForTesting
    @UnsupportedAppUsage
    public void setCompatibilityInfo(CompatibilityInfo ci) {
        if (ci != null) {
            this.mResourcesImpl.updateConfiguration(null, null, ci);
        }
    }

    public int getIdentifier_Original(String name, String defType, String defPackage) {
        return this.mResourcesImpl.getIdentifier(name, defType, defPackage);
    }

    @LayoutlibDelegate
    public int getIdentifier(String string2, String string3, String string4) {
        return Resources_Delegate.getIdentifier(this, string2, string3, string4);
    }

    public static boolean resourceHasPackage(int resid) {
        return resid >>> 24 != 0;
    }

    public String getResourceName_Original(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceName(resid);
    }

    @LayoutlibDelegate
    public String getResourceName(int n) throws NotFoundException {
        return Resources_Delegate.getResourceName(this, n);
    }

    public String getResourcePackageName_Original(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourcePackageName(resid);
    }

    @LayoutlibDelegate
    public String getResourcePackageName(int n) throws NotFoundException {
        return Resources_Delegate.getResourcePackageName(this, n);
    }

    public String getResourceTypeName_Original(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceTypeName(resid);
    }

    @LayoutlibDelegate
    public String getResourceTypeName(int n) throws NotFoundException {
        return Resources_Delegate.getResourceTypeName(this, n);
    }

    public String getResourceEntryName_Original(int resid) throws NotFoundException {
        return this.mResourcesImpl.getResourceEntryName(resid);
    }

    @LayoutlibDelegate
    public String getResourceEntryName(int n) throws NotFoundException {
        return Resources_Delegate.getResourceEntryName(this, n);
    }

    public String getLastResourceResolution() throws NotFoundException {
        return this.mResourcesImpl.getLastResourceResolution();
    }

    public void parseBundleExtras(XmlResourceParser parser, Bundle outBundle) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String nodeName = parser.getName();
            if (nodeName.equals("extra")) {
                this.parseBundleExtra("extra", parser, outBundle);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseBundleExtra(String tagName, AttributeSet attrs, Bundle outBundle) throws XmlPullParserException {
        TypedArray sa = this.obtainAttributes(attrs, R.styleable.Extra);
        String name = sa.getString(0);
        if (name == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:name attribute at " + attrs.getPositionDescription());
        }
        TypedValue v = sa.peekValue(1);
        if (v == null) {
            sa.recycle();
            throw new XmlPullParserException("<" + tagName + "> requires an android:value or android:resource attribute at " + attrs.getPositionDescription());
        }
        if (v.type == 3) {
            CharSequence cs = v.coerceToString();
            outBundle.putCharSequence(name, cs);
        } else if (v.type == 18) {
            outBundle.putBoolean(name, v.data != 0);
        } else if (v.type >= 16 && v.type <= 31) {
            outBundle.putInt(name, v.data);
        } else {
            if (v.type != 4) {
                sa.recycle();
                throw new XmlPullParserException("<" + tagName + "> only supports string, integer, float, color, and boolean at " + attrs.getPositionDescription());
            }
            outBundle.putFloat(name, v.getFloat());
        }
        sa.recycle();
    }

    public AssetManager getAssets() {
        return this.mResourcesImpl.getAssets();
    }

    public void flushLayoutCache() {
        this.mResourcesImpl.flushLayoutCache();
    }

    public void startPreloading() {
        this.mResourcesImpl.startPreloading();
    }

    public void finishPreloading() {
        this.mResourcesImpl.finishPreloading();
    }

    @UnsupportedAppUsage
    public LongSparseArray<Drawable.ConstantState> getPreloadedDrawables() {
        return this.mResourcesImpl.getPreloadedDrawables();
    }

    @UnsupportedAppUsage
    XmlResourceParser loadXmlResourceParser_Original(int id2, String type) throws NotFoundException {
        TypedValue value = this.obtainTempTypedValue();
        try {
            ResourcesImpl impl = this.mResourcesImpl;
            impl.getValue(id2, value, true);
            if (value.type == 3) {
                XmlResourceParser xmlResourceParser = this.loadXmlResourceParser(value.string.toString(), id2, value.assetCookie, type);
                return xmlResourceParser;
            }
            throw new NotFoundException("Resource ID #0x" + Integer.toHexString(id2) + " type #0x" + Integer.toHexString(value.type) + " is not valid");
        }
        finally {
            this.releaseTempTypedValue(value);
        }
    }

    @LayoutlibDelegate
    XmlResourceParser loadXmlResourceParser(int n, String string2) throws NotFoundException {
        return Resources_Delegate.loadXmlResourceParser(this, n, string2);
    }

    @UnsupportedAppUsage
    XmlResourceParser loadXmlResourceParser_Original(String file, int id2, int assetCookie, String type) throws NotFoundException {
        return this.mResourcesImpl.loadXmlResourceParser(file, id2, assetCookie, type);
    }

    @LayoutlibDelegate
    XmlResourceParser loadXmlResourceParser(String string2, int n, int n2, String string3) throws NotFoundException {
        return Resources_Delegate.loadXmlResourceParser(this, string2, n, n2, string3);
    }

    @VisibleForTesting
    public int calcConfigChanges(Configuration config) {
        return this.mResourcesImpl.calcConfigChanges(config);
    }

    public static TypedArray obtainAttributes_Original(Resources res, Theme theme, AttributeSet set, int[] attrs) {
        if (theme == null) {
            return res.obtainAttributes(set, attrs);
        }
        return theme.obtainStyledAttributes(set, attrs, 0, 0);
    }

    @LayoutlibDelegate
    public static TypedArray obtainAttributes(Resources resources, Theme theme, AttributeSet attributeSet, int[] nArray) {
        return Resources_Delegate.obtainAttributes(resources, theme, attributeSet, nArray);
    }

    private void checkCallbacksRegistered() {
        if (this.mCallbacks == null) {
            this.mCallbacks = new AssetManagerUpdateHandler();
        }
    }

    public List<ResourcesLoader> getLoaders() {
        return this.mResourcesImpl.getAssets().getLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoaders(ResourcesLoader ... loaders) {
        Object object = this.mUpdateLock;
        synchronized (object) {
            int i;
            this.checkCallbacksRegistered();
            ArrayList<ResourcesLoader> newLoaders = new ArrayList<ResourcesLoader>(this.mResourcesImpl.getAssets().getLoaders());
            ArraySet<ResourcesLoader> loaderSet = new ArraySet<ResourcesLoader>(newLoaders);
            for (i = 0; i < loaders.length; ++i) {
                ResourcesLoader loader = loaders[i];
                if (loaderSet.contains(loader)) continue;
                newLoaders.add(loader);
            }
            if (loaderSet.size() == newLoaders.size()) {
                return;
            }
            this.mCallbacks.onLoadersChanged(this, newLoaders);
            int n = newLoaders.size();
            for (i = loaderSet.size(); i < n; ++i) {
                ((ResourcesLoader)newLoaders.get(i)).registerOnProvidersChangedCallback(this, this.mCallbacks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoaders(ResourcesLoader ... loaders) {
        Object object = this.mUpdateLock;
        synchronized (object) {
            int i;
            this.checkCallbacksRegistered();
            ArraySet<ResourcesLoader> removedLoaders = new ArraySet<ResourcesLoader>(loaders);
            ArrayList<ResourcesLoader> newLoaders = new ArrayList<ResourcesLoader>();
            List<ResourcesLoader> oldLoaders = this.mResourcesImpl.getAssets().getLoaders();
            int n = oldLoaders.size();
            for (i = 0; i < n; ++i) {
                ResourcesLoader loader = oldLoaders.get(i);
                if (removedLoaders.contains(loader)) continue;
                newLoaders.add(loader);
            }
            if (oldLoaders.size() == newLoaders.size()) {
                return;
            }
            this.mCallbacks.onLoadersChanged(this, newLoaders);
            for (i = 0; i < loaders.length; ++i) {
                loaders[i].unregisterOnProvidersChangedCallback(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void clearLoaders() {
        Object object = this.mUpdateLock;
        synchronized (object) {
            this.checkCallbacksRegistered();
            List<ResourcesLoader> newLoaders = Collections.emptyList();
            List<ResourcesLoader> oldLoaders = this.mResourcesImpl.getAssets().getLoaders();
            this.mCallbacks.onLoadersChanged(this, newLoaders);
            for (ResourcesLoader loader : oldLoaders) {
                loader.unregisterOnProvidersChangedCallback(this);
            }
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "class=" + this.getClass());
        pw.println(prefix + "resourcesImpl");
        this.mResourcesImpl.dump(pw, prefix + "  ");
    }

    public static void dumpHistory(PrintWriter pw, String prefix) {
        pw.println(prefix + "history");
        ArrayMap history = new ArrayMap();
        sResourcesHistory.forEach(r -> history.put(Arrays.asList(r.mResourcesImpl.mAssets.getApkAssets()), r));
        int i = 0;
        for (Resources r2 : history.values()) {
            if (r2 == null) continue;
            pw.println(prefix + i++);
            r2.dump(pw, prefix + "  ");
        }
    }

    public static interface UpdateCallbacks
    extends ResourcesLoader.UpdateCallbacks {
        public void onLoadersChanged(Resources var1, List<ResourcesLoader> var2);
    }

    public class Theme {
        private static final int MAX_NUMBER_OF_TRACING_PARENT_THEME = 100;
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        @UnsupportedAppUsage
        private ResourcesImpl.ThemeImpl mThemeImpl;

        private Theme() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setImpl(ResourcesImpl.ThemeImpl impl) {
            Object object = this.mLock;
            synchronized (object) {
                this.mThemeImpl = impl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyStyle(int resId, boolean force) {
            Object object = this.mLock;
            synchronized (object) {
                this.mThemeImpl.applyStyle(resId, force);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTo(Theme other) {
            Object object = this.mLock;
            synchronized (object) {
                Object object2 = other.mLock;
                synchronized (object2) {
                    this.mThemeImpl.setTo(other.mThemeImpl);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TypedArray obtainStyledAttributes_Original(int[] attrs) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.obtainStyledAttributes(this, null, attrs, 0, 0);
            }
        }

        @LayoutlibDelegate
        public TypedArray obtainStyledAttributes(int[] nArray) {
            return Resources_Theme_Delegate.obtainStyledAttributes(Resources.this, this, nArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TypedArray obtainStyledAttributes_Original(int resId, int[] attrs) throws NotFoundException {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.obtainStyledAttributes(this, null, attrs, 0, resId);
            }
        }

        @LayoutlibDelegate
        public TypedArray obtainStyledAttributes(int n, int[] nArray) throws NotFoundException {
            return Resources_Theme_Delegate.obtainStyledAttributes(Resources.this, this, n, nArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TypedArray obtainStyledAttributes_Original(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.obtainStyledAttributes(this, set, attrs, defStyleAttr, defStyleRes);
            }
        }

        @LayoutlibDelegate
        public TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray, int n, int n2) {
            return Resources_Theme_Delegate.obtainStyledAttributes(Resources.this, this, attributeSet, nArray, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UnsupportedAppUsage
        public TypedArray resolveAttributes_Original(int[] values, int[] attrs) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.resolveAttributes(this, values, attrs);
            }
        }

        @LayoutlibDelegate
        public TypedArray resolveAttributes(int[] nArray, int[] nArray2) {
            return Resources_Theme_Delegate.resolveAttributes(Resources.this, this, nArray, nArray2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resolveAttribute_Original(int resid, TypedValue outValue, boolean resolveRefs) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.resolveAttribute(resid, outValue, resolveRefs);
            }
        }

        @LayoutlibDelegate
        public boolean resolveAttribute(int n, TypedValue typedValue, boolean bl) {
            return Resources_Theme_Delegate.resolveAttribute(Resources.this, this, n, typedValue, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getAllAttributes() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.getAllAttributes();
            }
        }

        public Resources getResources() {
            return Resources.this;
        }

        public Drawable getDrawable(int id2) throws NotFoundException {
            return Resources.this.getDrawable(id2, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getChangingConfigurations() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.getChangingConfigurations();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(int priority, String tag, String prefix) {
            Object object = this.mLock;
            synchronized (object) {
                this.mThemeImpl.dump(priority, tag, prefix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getNativeTheme() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.getNativeTheme();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getAppliedStyleResId() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.getAppliedStyleResId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getParentThemeIdentifier(int resId) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.getParentThemeIdentifier(resId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThemeKey getKey() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.getKey();
            }
        }

        private String getResourceNameFromHexString(String hexString) {
            return Resources.this.getResourceName(Integer.parseInt(hexString, 16));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ViewDebug.ExportedProperty(category="theme", hasAdjacentMapping=true)
        public String[] getTheme() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mThemeImpl.getTheme();
            }
        }

        public void encode(ViewHierarchyEncoder encoder) {
            encoder.beginObject(this);
            String[] properties = this.getTheme();
            for (int i = 0; i < properties.length; i += 2) {
                encoder.addProperty(properties[i], properties[i + 1]);
            }
            encoder.endObject();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rebase() {
            Object object = this.mLock;
            synchronized (object) {
                this.mThemeImpl.rebase();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rebase(ResourcesImpl resImpl) {
            Object object = this.mLock;
            synchronized (object) {
                this.mThemeImpl.rebase(resImpl.mAssets);
            }
        }

        public int getExplicitStyle(AttributeSet set) {
            if (set == null) {
                return 0;
            }
            int styleAttr = set.getStyleAttribute();
            if (styleAttr == 0) {
                return 0;
            }
            String styleAttrType = this.getResources().getResourceTypeName(styleAttr);
            if ("attr".equals(styleAttrType)) {
                TypedValue explicitStyle = new TypedValue();
                boolean resolved = this.resolveAttribute(styleAttr, explicitStyle, true);
                if (resolved) {
                    return explicitStyle.resourceId;
                }
            } else if ("style".equals(styleAttrType)) {
                return styleAttr;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getAttributeResolutionStack(int defStyleAttr, int defStyleRes, int explicitStyleRes) {
            Object object = this.mLock;
            synchronized (object) {
                int[] stack = this.mThemeImpl.getAttributeResolutionStack(defStyleAttr, defStyleRes, explicitStyleRes);
                if (stack == null) {
                    return new int[0];
                }
                return stack;
            }
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || this.hashCode() != o.hashCode()) {
                return false;
            }
            Theme other = (Theme)o;
            return this.getKey().equals(other.getKey());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            int themeResId = this.getAppliedStyleResId();
            int i = 0;
            sb.append("InheritanceMap=[");
            while (themeResId > 0) {
                if (i > 100) {
                    sb.append(",...");
                    break;
                }
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("id=0x").append(Integer.toHexString(themeResId));
                sb.append(Resources.this.getResourcePackageName(themeResId)).append(":").append(Resources.this.getResourceTypeName(themeResId)).append("/").append(Resources.this.getResourceEntryName(themeResId));
                ++i;
                themeResId = this.getParentThemeIdentifier(themeResId);
            }
            sb.append("], Themes=").append(Arrays.deepToString(this.getTheme()));
            sb.append('}');
            return sb.toString();
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException() {
        }

        public NotFoundException(String name) {
            super(name);
        }

        public NotFoundException(String name, Exception cause) {
            super(name, cause);
        }
    }

    public class AssetManagerUpdateHandler
    implements UpdateCallbacks {
        @Override
        public void onLoadersChanged(Resources resources, List<ResourcesLoader> newLoaders) {
            Preconditions.checkArgument(Resources.this == resources);
            ResourcesImpl impl = Resources.this.mResourcesImpl;
            impl.clearAllCaches();
            impl.getAssets().setLoaders(newLoaders);
        }

        @Override
        public void onLoaderUpdated(ResourcesLoader loader) {
            ResourcesImpl impl = Resources.this.mResourcesImpl;
            AssetManager assets = impl.getAssets();
            if (assets.getLoaders().contains(loader)) {
                impl.clearAllCaches();
                assets.setLoaders(assets.getLoaders());
            }
        }
    }

    static class ThemeKey
    implements Cloneable {
        int[] mResId;
        boolean[] mForce;
        int mCount;
        private int mHashCode = 0;

        ThemeKey() {
        }

        private int findValue(int resId, boolean force) {
            for (int i = 0; i < this.mCount; ++i) {
                if (this.mResId[i] != resId || this.mForce[i] != force) continue;
                return i;
            }
            return -1;
        }

        private void moveToLast(int index) {
            if (index < 0 || index >= this.mCount - 1) {
                return;
            }
            int id2 = this.mResId[index];
            boolean force = this.mForce[index];
            System.arraycopy(this.mResId, index + 1, this.mResId, index, this.mCount - index - 1);
            this.mResId[this.mCount - 1] = id2;
            System.arraycopy(this.mForce, index + 1, this.mForce, index, this.mCount - index - 1);
            this.mForce[this.mCount - 1] = force;
        }

        public void append(int resId, boolean force) {
            int index;
            if (this.mResId == null) {
                this.mResId = new int[4];
            }
            if (this.mForce == null) {
                this.mForce = new boolean[4];
            }
            if ((index = this.findValue(resId, force)) >= 0) {
                this.moveToLast(index);
            } else {
                this.mResId = GrowingArrayUtils.append(this.mResId, this.mCount, resId);
                this.mForce = GrowingArrayUtils.append(this.mForce, this.mCount, force);
                ++this.mCount;
                this.mHashCode = 31 * (31 * this.mHashCode + resId) + (force ? 1 : 0);
            }
        }

        public void setTo(ThemeKey other) {
            this.mResId = other.mResId == null ? null : (int[])other.mResId.clone();
            this.mForce = other.mForce == null ? null : (boolean[])other.mForce.clone();
            this.mCount = other.mCount;
            this.mHashCode = other.mHashCode;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() || this.hashCode() != o.hashCode()) {
                return false;
            }
            ThemeKey t = (ThemeKey)o;
            if (this.mCount != t.mCount) {
                return false;
            }
            int N = this.mCount;
            for (int i = 0; i < N; ++i) {
                if (this.mResId[i] == t.mResId[i] && this.mForce[i] == t.mForce[i]) continue;
                return false;
            }
            return true;
        }

        public ThemeKey clone() {
            ThemeKey other = new ThemeKey();
            other.mResId = this.mResId;
            other.mForce = this.mForce;
            other.mCount = this.mCount;
            other.mHashCode = this.mHashCode;
            return other;
        }
    }
}

