/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class CreateCredentialRequest
implements Parcelable {
    private final boolean mAlwaysSendAppInfoToProvider;
    private final String mType;
    private final Bundle mCredentialData;
    private final Bundle mCandidateQueryData;
    private final boolean mIsSystemProviderRequired;
    private final String mOrigin;
    public static final Parcelable.Creator<CreateCredentialRequest> CREATOR = new Parcelable.Creator<CreateCredentialRequest>(){

        public CreateCredentialRequest[] newArray(int size) {
            return new CreateCredentialRequest[size];
        }

        @Override
        public CreateCredentialRequest createFromParcel(Parcel in) {
            return new CreateCredentialRequest(in);
        }
    };

    public String getType() {
        return this.mType;
    }

    public Bundle getCredentialData() {
        return this.mCredentialData;
    }

    public Bundle getCandidateQueryData() {
        return this.mCandidateQueryData;
    }

    public boolean isSystemProviderRequired() {
        return this.mIsSystemProviderRequired;
    }

    public boolean alwaysSendAppInfoToProvider() {
        return this.mAlwaysSendAppInfoToProvider;
    }

    public String getOrigin() {
        return this.mOrigin;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mType);
        dest.writeBundle(this.mCredentialData);
        dest.writeBundle(this.mCandidateQueryData);
        dest.writeBoolean(this.mIsSystemProviderRequired);
        dest.writeBoolean(this.mAlwaysSendAppInfoToProvider);
        dest.writeString8(this.mOrigin);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "CreateCredentialRequest {type=" + this.mType + ", credentialData=" + this.mCredentialData + ", candidateQueryData=" + this.mCandidateQueryData + ", isSystemProviderRequired=" + this.mIsSystemProviderRequired + ", alwaysSendAppInfoToProvider=" + this.mAlwaysSendAppInfoToProvider + ", origin=" + this.mOrigin + "}";
    }

    private CreateCredentialRequest(String type, Bundle credentialData, Bundle candidateQueryData, boolean isSystemProviderRequired, boolean alwaysSendAppInfoToProvider, String origin) {
        this.mType = Preconditions.checkStringNotEmpty(type, "type must not be empty");
        this.mCredentialData = Objects.requireNonNull(credentialData, "credentialData must not be null");
        this.mCandidateQueryData = Objects.requireNonNull(candidateQueryData, "candidateQueryData must not be null");
        this.mIsSystemProviderRequired = isSystemProviderRequired;
        this.mAlwaysSendAppInfoToProvider = alwaysSendAppInfoToProvider;
        this.mOrigin = origin;
    }

    private CreateCredentialRequest(Parcel in) {
        String type = in.readString8();
        Bundle credentialData = in.readBundle();
        Bundle candidateQueryData = in.readBundle();
        boolean isSystemProviderRequired = in.readBoolean();
        boolean alwaysSendAppInfoToProvider = in.readBoolean();
        this.mOrigin = in.readString8();
        this.mType = type;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mType);
        this.mCredentialData = credentialData;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mCredentialData);
        this.mCandidateQueryData = candidateQueryData;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mCandidateQueryData);
        this.mIsSystemProviderRequired = isSystemProviderRequired;
        this.mAlwaysSendAppInfoToProvider = alwaysSendAppInfoToProvider;
    }

    public static class Builder {
        private boolean mAlwaysSendAppInfoToProvider = true;
        private String mType;
        private final Bundle mCredentialData;
        private final Bundle mCandidateQueryData;
        private boolean mIsSystemProviderRequired;
        private String mOrigin;

        public Builder(String type, Bundle credentialData, Bundle candidateQueryData) {
            this.mType = Preconditions.checkStringNotEmpty(type, "type must not be null or empty");
            this.mCredentialData = Objects.requireNonNull(credentialData, "credentialData must not be null");
            this.mCandidateQueryData = Objects.requireNonNull(candidateQueryData, "candidateQueryData must not be null");
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAlwaysSendAppInfoToProvider(boolean value) {
            this.mAlwaysSendAppInfoToProvider = value;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setIsSystemProviderRequired(boolean value) {
            this.mIsSystemProviderRequired = value;
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder", "AndroidFrameworkRequiresPermission"})
        @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_SET_ORIGIN")
        public Builder setOrigin(String origin) {
            this.mOrigin = origin;
            return this;
        }

        public CreateCredentialRequest build() {
            Preconditions.checkStringNotEmpty(this.mType, "type must not be empty");
            return new CreateCredentialRequest(this.mType, this.mCredentialData, this.mCandidateQueryData, this.mIsSystemProviderRequired, this.mAlwaysSendAppInfoToProvider, this.mOrigin);
        }
    }
}

