/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import androidx.annotation.RequiresPermission;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.Objects;
import java.util.Set;

public class CredentialOption
implements Parcelable {
    public static final String SUPPORTED_ELEMENT_KEYS = "android.credentials.GetCredentialOption.SUPPORTED_ELEMENT_KEYS";
    private final String mType;
    private final Bundle mCredentialRetrievalData;
    private final Bundle mCandidateQueryData;
    private final boolean mIsSystemProviderRequired;
    private final ArraySet<ComponentName> mAllowedProviders;
    public static final Parcelable.Creator<CredentialOption> CREATOR = new Parcelable.Creator<CredentialOption>(){

        public CredentialOption[] newArray(int size) {
            return new CredentialOption[size];
        }

        @Override
        public CredentialOption createFromParcel(Parcel in) {
            return new CredentialOption(in);
        }
    };

    public String getType() {
        return this.mType;
    }

    public Bundle getCredentialRetrievalData() {
        return this.mCredentialRetrievalData;
    }

    public Bundle getCandidateQueryData() {
        return this.mCandidateQueryData;
    }

    public boolean isSystemProviderRequired() {
        return this.mIsSystemProviderRequired;
    }

    public Set<ComponentName> getAllowedProviders() {
        return this.mAllowedProviders;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.mType);
        dest.writeBundle(this.mCredentialRetrievalData);
        dest.writeBundle(this.mCandidateQueryData);
        dest.writeBoolean(this.mIsSystemProviderRequired);
        dest.writeArraySet(this.mAllowedProviders);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "CredentialOption {type=" + this.mType + ", requestData=" + this.mCredentialRetrievalData + ", candidateQueryData=" + this.mCandidateQueryData + ", isSystemProviderRequired=" + this.mIsSystemProviderRequired + ", allowedProviders=" + this.mAllowedProviders + "}";
    }

    private CredentialOption(String type, Bundle credentialRetrievalData, Bundle candidateQueryData, boolean isSystemProviderRequired, ArraySet<ComponentName> allowedProviders) {
        this.mType = Preconditions.checkStringNotEmpty(type, "type must not be empty");
        this.mCredentialRetrievalData = Objects.requireNonNull(credentialRetrievalData, "requestData must not be null");
        this.mCandidateQueryData = Objects.requireNonNull(candidateQueryData, "candidateQueryData must not be null");
        this.mIsSystemProviderRequired = isSystemProviderRequired;
        this.mAllowedProviders = Objects.requireNonNull(allowedProviders, "providerFilterSer mustnot be empty");
    }

    public CredentialOption(String type, Bundle credentialRetrievalData, Bundle candidateQueryData, boolean isSystemProviderRequired) {
        this(type, credentialRetrievalData, candidateQueryData, isSystemProviderRequired, new ArraySet<ComponentName>());
    }

    private CredentialOption(Parcel in) {
        String type = in.readString8();
        Bundle data = in.readBundle();
        Bundle candidateQueryData = in.readBundle();
        boolean isSystemProviderRequired = in.readBoolean();
        this.mType = type;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mType);
        this.mCredentialRetrievalData = data;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mCredentialRetrievalData);
        this.mCandidateQueryData = candidateQueryData;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mCandidateQueryData);
        this.mIsSystemProviderRequired = isSystemProviderRequired;
        this.mAllowedProviders = in.readArraySet(null);
        AnnotationValidations.validate(NonNull.class, null, this.mAllowedProviders);
    }

    public static class Builder {
        private String mType;
        private Bundle mCredentialRetrievalData;
        private Bundle mCandidateQueryData;
        private boolean mIsSystemProviderRequired = false;
        private ArraySet<ComponentName> mAllowedProviders = new ArraySet();

        public Builder(String type, Bundle credentialRetrievalData, Bundle candidateQueryData) {
            this.mType = Preconditions.checkStringNotEmpty(type, "type must not be null, or empty");
            this.mCredentialRetrievalData = Objects.requireNonNull(credentialRetrievalData, "credentialRetrievalData must not be null");
            this.mCandidateQueryData = Objects.requireNonNull(candidateQueryData, "candidateQueryData must not be null");
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setIsSystemProviderRequired(boolean isSystemProviderRequired) {
            this.mIsSystemProviderRequired = isSystemProviderRequired;
            return this;
        }

        @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_SET_ALLOWED_PROVIDERS")
        public Builder addAllowedProvider(ComponentName allowedProvider) {
            this.mAllowedProviders.add(Objects.requireNonNull(allowedProvider, "allowedProvider must not be null"));
            return this;
        }

        @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_SET_ALLOWED_PROVIDERS")
        public Builder setAllowedProviders(Set<ComponentName> allowedProviders) {
            Preconditions.checkCollectionElementsNotNull(allowedProviders, "allowedProviders");
            this.mAllowedProviders = new ArraySet<ComponentName>(allowedProviders);
            return this;
        }

        public CredentialOption build() {
            return new CredentialOption(this.mType, this.mCredentialRetrievalData, this.mCandidateQueryData, this.mIsSystemProviderRequired, this.mAllowedProviders);
        }
    }
}

