/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CredentialProviderInfo
implements Parcelable {
    private final ServiceInfo mServiceInfo;
    private final Set<String> mCapabilities = new HashSet<String>();
    private final CharSequence mOverrideLabel;
    private CharSequence mSettingsSubtitle = null;
    private final boolean mIsSystemProvider;
    private final boolean mIsEnabled;
    private final boolean mIsPrimary;
    public static final Parcelable.Creator<CredentialProviderInfo> CREATOR = new Parcelable.Creator<CredentialProviderInfo>(){

        public CredentialProviderInfo[] newArray(int size) {
            return new CredentialProviderInfo[size];
        }

        @Override
        public CredentialProviderInfo createFromParcel(Parcel in) {
            return new CredentialProviderInfo(in);
        }
    };

    private CredentialProviderInfo(Builder builder) {
        this.mServiceInfo = builder.mServiceInfo;
        this.mCapabilities.addAll(builder.mCapabilities);
        this.mIsSystemProvider = builder.mIsSystemProvider;
        this.mSettingsSubtitle = builder.mSettingsSubtitle;
        this.mIsEnabled = builder.mIsEnabled;
        this.mIsPrimary = builder.mIsPrimary;
        this.mOverrideLabel = builder.mOverrideLabel;
    }

    public boolean hasCapability(String credentialType) {
        return this.mCapabilities.contains(credentialType);
    }

    public ServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    public boolean isSystemProvider() {
        return this.mIsSystemProvider;
    }

    public Drawable getServiceIcon(Context context) {
        return this.mServiceInfo.loadIcon(context.getPackageManager());
    }

    public CharSequence getLabel(Context context) {
        if (this.mOverrideLabel != null) {
            return this.mOverrideLabel;
        }
        return this.mServiceInfo.loadSafeLabel(context.getPackageManager());
    }

    public List<String> getCapabilities() {
        ArrayList<String> capabilities = new ArrayList<String>();
        for (String capability : this.mCapabilities) {
            capabilities.add(capability);
        }
        return Collections.unmodifiableList(capabilities);
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public boolean isPrimary() {
        return this.mIsPrimary;
    }

    public CharSequence getSettingsSubtitle() {
        return this.mSettingsSubtitle;
    }

    public ComponentName getComponentName() {
        return this.mServiceInfo.getComponentName();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mServiceInfo, flags);
        dest.writeBoolean(this.mIsSystemProvider);
        dest.writeBoolean(this.mIsEnabled);
        dest.writeBoolean(this.mIsPrimary);
        TextUtils.writeToParcel(this.mOverrideLabel, dest, flags);
        TextUtils.writeToParcel(this.mSettingsSubtitle, dest, flags);
        List<String> capabilities = this.getCapabilities();
        dest.writeStringList(capabilities);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "CredentialProviderInfo {serviceInfo=" + this.mServiceInfo + ", isSystemProvider=" + this.mIsSystemProvider + ", isEnabled=" + this.mIsEnabled + ", isPrimary=" + this.mIsPrimary + ", overrideLabel=" + this.mOverrideLabel + ", settingsSubtitle=" + this.mSettingsSubtitle + ", capabilities=" + String.join((CharSequence)",", this.mCapabilities) + "}";
    }

    private CredentialProviderInfo(Parcel in) {
        this.mServiceInfo = in.readTypedObject(ServiceInfo.CREATOR);
        this.mIsSystemProvider = in.readBoolean();
        this.mIsEnabled = in.readBoolean();
        this.mIsPrimary = in.readBoolean();
        this.mOverrideLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mSettingsSubtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        ArrayList<String> capabilities = new ArrayList<String>();
        in.readStringList(capabilities);
        this.mCapabilities.addAll(capabilities);
    }

    public static class Builder {
        private ServiceInfo mServiceInfo;
        private Set<String> mCapabilities = new HashSet<String>();
        private boolean mIsSystemProvider = false;
        private CharSequence mSettingsSubtitle = null;
        private boolean mIsEnabled = false;
        private boolean mIsPrimary = false;
        private CharSequence mOverrideLabel = null;

        public Builder(ServiceInfo serviceInfo) {
            this.mServiceInfo = serviceInfo;
        }

        public Builder setSystemProvider(boolean isSystemProvider) {
            this.mIsSystemProvider = isSystemProvider;
            return this;
        }

        public Builder setOverrideLabel(CharSequence overrideLabel) {
            this.mOverrideLabel = overrideLabel;
            return this;
        }

        public Builder setSettingsSubtitle(CharSequence settingsSubtitle) {
            this.mSettingsSubtitle = settingsSubtitle;
            return this;
        }

        public Builder addCapabilities(List<String> capabilities) {
            this.mCapabilities.addAll(capabilities);
            return this;
        }

        public Builder addCapabilities(Set<String> capabilities) {
            this.mCapabilities.addAll(capabilities);
            return this;
        }

        public Builder setEnabled(boolean isEnabled) {
            this.mIsEnabled = isEnabled;
            return this;
        }

        public Builder setPrimary(boolean isPrimary) {
            this.mIsPrimary = isPrimary;
            return this;
        }

        public CredentialProviderInfo build() {
            return new CredentialProviderInfo(this);
        }
    }
}

