/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.credentials.CredentialOption;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GetCredentialRequest
implements Parcelable {
    private final List<CredentialOption> mCredentialOptions;
    private final Bundle mData;
    private String mOrigin;
    private final boolean mAlwaysSendAppInfoToProvider;
    public static final Parcelable.Creator<GetCredentialRequest> CREATOR = new Parcelable.Creator<GetCredentialRequest>(){

        public GetCredentialRequest[] newArray(int size) {
            return new GetCredentialRequest[size];
        }

        @Override
        public GetCredentialRequest createFromParcel(Parcel in) {
            return new GetCredentialRequest(in);
        }
    };

    public List<CredentialOption> getCredentialOptions() {
        return this.mCredentialOptions;
    }

    public Bundle getData() {
        return this.mData;
    }

    public String getOrigin() {
        return this.mOrigin;
    }

    public boolean alwaysSendAppInfoToProvider() {
        return this.mAlwaysSendAppInfoToProvider;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.mCredentialOptions, flags);
        dest.writeBundle(this.mData);
        dest.writeBoolean(this.mAlwaysSendAppInfoToProvider);
        dest.writeString8(this.mOrigin);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "GetCredentialRequest {credentialOption=" + this.mCredentialOptions + ", data=" + this.mData + ", alwaysSendAppInfoToProvider=" + this.mAlwaysSendAppInfoToProvider + ", origin=" + this.mOrigin + "}";
    }

    private GetCredentialRequest(List<CredentialOption> credentialOptions, Bundle data, boolean alwaysSendAppInfoToProvider, String origin) {
        Preconditions.checkCollectionNotEmpty(credentialOptions, "credentialOptions");
        Preconditions.checkCollectionElementsNotNull(credentialOptions, "credentialOptions");
        this.mCredentialOptions = credentialOptions;
        this.mData = Objects.requireNonNull(data, "data must not be null");
        this.mAlwaysSendAppInfoToProvider = alwaysSendAppInfoToProvider;
        this.mOrigin = origin;
    }

    private GetCredentialRequest(Parcel in) {
        Bundle data;
        ArrayList<CredentialOption> credentialOptions = new ArrayList<CredentialOption>();
        in.readTypedList(credentialOptions, CredentialOption.CREATOR);
        this.mCredentialOptions = credentialOptions;
        AnnotationValidations.validate(NonNull.class, null, this.mCredentialOptions);
        this.mData = data = in.readBundle();
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mData);
        this.mAlwaysSendAppInfoToProvider = in.readBoolean();
        this.mOrigin = in.readString8();
    }

    public static class Builder {
        private List<CredentialOption> mCredentialOptions = new ArrayList<CredentialOption>();
        private final Bundle mData;
        private boolean mAlwaysSendAppInfoToProvider = true;
        private String mOrigin;

        public Builder(Bundle data) {
            this.mData = Objects.requireNonNull(data, "data must not be null");
        }

        public Builder addCredentialOption(CredentialOption credentialOption) {
            this.mCredentialOptions.add(Objects.requireNonNull(credentialOption, "credentialOption must not be null"));
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setAlwaysSendAppInfoToProvider(boolean value) {
            this.mAlwaysSendAppInfoToProvider = value;
            return this;
        }

        public Builder setCredentialOptions(List<CredentialOption> credentialOptions) {
            Preconditions.checkCollectionElementsNotNull(credentialOptions, "credentialOptions");
            this.mCredentialOptions = new ArrayList<CredentialOption>(credentialOptions);
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder", "AndroidFrameworkRequiresPermission"})
        @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_SET_ORIGIN")
        public Builder setOrigin(String origin) {
            this.mOrigin = origin;
            return this;
        }

        public GetCredentialRequest build() {
            Preconditions.checkCollectionNotEmpty(this.mCredentialOptions, "credentialOptions");
            Preconditions.checkCollectionElementsNotNull(this.mCredentialOptions, "credentialOptions");
            return new GetCredentialRequest(this.mCredentialOptions, this.mData, this.mAlwaysSendAppInfoToProvider, this.mOrigin);
        }
    }
}

