/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.app.PendingIntent;
import android.credentials.GetCredentialResponse;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IGetCredentialCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.credentials.IGetCredentialCallback";

    public void onPendingIntent(PendingIntent var1) throws RemoteException;

    public void onResponse(GetCredentialResponse var1) throws RemoteException;

    public void onError(String var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IGetCredentialCallback {
        static final int TRANSACTION_onPendingIntent = 1;
        static final int TRANSACTION_onResponse = 2;
        static final int TRANSACTION_onError = 3;

        public Stub() {
            this.attachInterface(this, IGetCredentialCallback.DESCRIPTOR);
        }

        public static IGetCredentialCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IGetCredentialCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IGetCredentialCallback) {
                return (IGetCredentialCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onPendingIntent";
                }
                case 2: {
                    return "onResponse";
                }
                case 3: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IGetCredentialCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPendingIntent(_arg0);
                    break;
                }
                case 2: {
                    GetCredentialResponse _arg0 = data.readTypedObject(GetCredentialResponse.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResponse(_arg0);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onError(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IGetCredentialCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IGetCredentialCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPendingIntent(PendingIntent pendingIntent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IGetCredentialCallback.DESCRIPTOR);
                    _data.writeTypedObject(pendingIntent, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(GetCredentialResponse response) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IGetCredentialCallback.DESCRIPTOR);
                    _data.writeTypedObject(response, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(String errorType, String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IGetCredentialCallback.DESCRIPTOR);
                    _data.writeString(errorType);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IGetCredentialCallback {
        @Override
        public void onPendingIntent(PendingIntent pendingIntent) throws RemoteException {
        }

        @Override
        public void onResponse(GetCredentialResponse response) throws RemoteException {
        }

        @Override
        public void onError(String errorType, String message) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

