/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.Set;

public class PrepareGetCredentialResponseInternal
implements Parcelable {
    private static final String TAG = "CredentialManager";
    private final boolean mHasQueryApiPermission;
    private final ArraySet<String> mCredentialResultTypes;
    private final boolean mHasAuthenticationResults;
    private final boolean mHasRemoteResults;
    private final PendingIntent mPendingIntent;
    public static final Parcelable.Creator<PrepareGetCredentialResponseInternal> CREATOR = new Parcelable.Creator<PrepareGetCredentialResponseInternal>(){

        public PrepareGetCredentialResponseInternal[] newArray(int size) {
            return new PrepareGetCredentialResponseInternal[size];
        }

        @Override
        public PrepareGetCredentialResponseInternal createFromParcel(Parcel in) {
            return new PrepareGetCredentialResponseInternal(in);
        }
    };

    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_QUERY_CANDIDATE_CREDENTIALS")
    public boolean hasCredentialResults(String credentialType) {
        if (!this.mHasQueryApiPermission) {
            throw new SecurityException("caller doesn't have the permission to query credential results");
        }
        if (this.mCredentialResultTypes == null) {
            return false;
        }
        return this.mCredentialResultTypes.contains(credentialType);
    }

    @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_QUERY_CANDIDATE_CREDENTIALS")
    public boolean hasAuthenticationResults() {
        if (!this.mHasQueryApiPermission) {
            throw new SecurityException("caller doesn't have the permission to query authentication results");
        }
        return this.mHasAuthenticationResults;
    }

    @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_QUERY_CANDIDATE_CREDENTIALS")
    public boolean hasRemoteResults() {
        if (!this.mHasQueryApiPermission) {
            throw new SecurityException("caller doesn't have the permission to query remote results");
        }
        return this.mHasRemoteResults;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mHasQueryApiPermission);
        dest.writeArraySet(this.mCredentialResultTypes);
        dest.writeBoolean(this.mHasAuthenticationResults);
        dest.writeBoolean(this.mHasRemoteResults);
        dest.writeTypedObject(this.mPendingIntent, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public PrepareGetCredentialResponseInternal(boolean hasQueryApiPermission, Set<String> credentialResultTypes, boolean hasAuthenticationResults, boolean hasRemoteResults, PendingIntent pendingIntent) {
        this.mHasQueryApiPermission = hasQueryApiPermission;
        this.mCredentialResultTypes = new ArraySet<String>(credentialResultTypes);
        this.mHasAuthenticationResults = hasAuthenticationResults;
        this.mHasRemoteResults = hasRemoteResults;
        this.mPendingIntent = pendingIntent;
    }

    private PrepareGetCredentialResponseInternal(Parcel in) {
        this.mHasQueryApiPermission = in.readBoolean();
        this.mCredentialResultTypes = in.readArraySet(null);
        this.mHasAuthenticationResults = in.readBoolean();
        this.mHasRemoteResults = in.readBoolean();
        this.mPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
    }
}

