/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.compat.annotation.UnsupportedAppUsage;
import android.database.sqlite.SQLiteCompatibilityWalFlags;
import android.database.sqlite.SQLiteGlobal;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Pair;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;

public class SQLiteDatabaseConfiguration {
    private static final Pattern EMAIL_IN_DB_PATTERN = Pattern.compile("[\\w\\.\\-]+@[\\w\\.\\-]+");
    public static final String MEMORY_DB_PATH = ":memory:";
    public final String path;
    public final String label;
    public int openFlags;
    @UnsupportedAppUsage
    public int maxSqlCacheSize;
    public Locale locale;
    public boolean foreignKeyConstraintsEnabled;
    public final ArrayMap<String, UnaryOperator<String>> customScalarFunctions = new ArrayMap();
    public final ArrayMap<String, BinaryOperator<String>> customAggregateFunctions = new ArrayMap();
    public final ArrayList<Pair<String, Object[]>> perConnectionSql = new ArrayList();
    public int lookasideSlotSize = -1;
    public int lookasideSlotCount = -1;
    public long idleConnectionTimeoutMs = Long.MAX_VALUE;
    public String journalMode;
    public String syncMode;
    public boolean shouldTruncateWalFile;

    public SQLiteDatabaseConfiguration(String path, int openFlags) {
        if (path == null) {
            throw new IllegalArgumentException("path must not be null.");
        }
        this.path = path;
        this.label = SQLiteDatabaseConfiguration.stripPathForLogs(path);
        this.openFlags = openFlags;
        this.maxSqlCacheSize = 25;
        this.locale = AndroidLocale.getDefault();
    }

    public SQLiteDatabaseConfiguration(SQLiteDatabaseConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null.");
        }
        this.path = other.path;
        this.label = other.label;
        this.updateParametersFrom(other);
    }

    public void updateParametersFrom(SQLiteDatabaseConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("other must not be null.");
        }
        if (!this.path.equals(other.path)) {
            throw new IllegalArgumentException("other configuration must refer to the same database.");
        }
        this.openFlags = other.openFlags;
        this.maxSqlCacheSize = other.maxSqlCacheSize;
        this.locale = other.locale;
        this.foreignKeyConstraintsEnabled = other.foreignKeyConstraintsEnabled;
        this.customScalarFunctions.clear();
        this.customScalarFunctions.putAll(other.customScalarFunctions);
        this.customAggregateFunctions.clear();
        this.customAggregateFunctions.putAll(other.customAggregateFunctions);
        this.perConnectionSql.clear();
        this.perConnectionSql.addAll(other.perConnectionSql);
        this.lookasideSlotSize = other.lookasideSlotSize;
        this.lookasideSlotCount = other.lookasideSlotCount;
        this.idleConnectionTimeoutMs = other.idleConnectionTimeoutMs;
        this.journalMode = other.journalMode;
        this.syncMode = other.syncMode;
    }

    public boolean isInMemoryDb() {
        return this.path.equalsIgnoreCase(MEMORY_DB_PATH);
    }

    public boolean isReadOnlyDatabase() {
        return (this.openFlags & 1) != 0;
    }

    boolean isLegacyCompatibilityWalEnabled() {
        return this.journalMode == null && this.syncMode == null && (this.openFlags & Integer.MIN_VALUE) != 0;
    }

    private static String stripPathForLogs(String path) {
        if (path.indexOf(64) == -1) {
            return path;
        }
        return EMAIL_IN_DB_PATTERN.matcher(path).replaceAll("XX@YY");
    }

    boolean isLookasideConfigSet() {
        return this.lookasideSlotCount >= 0 && this.lookasideSlotSize >= 0;
    }

    public String resolveJournalMode() {
        if (this.isReadOnlyDatabase()) {
            return "";
        }
        if (this.isInMemoryDb()) {
            if (this.journalMode != null && this.journalMode.equalsIgnoreCase("OFF")) {
                return "OFF";
            }
            return "MEMORY";
        }
        this.shouldTruncateWalFile = false;
        if (this.isWalEnabledInternal()) {
            this.shouldTruncateWalFile = true;
            return "WAL";
        }
        return this.journalMode != null ? this.journalMode : SQLiteGlobal.getDefaultJournalMode();
    }

    public String resolveSyncMode() {
        if (this.isReadOnlyDatabase()) {
            return "";
        }
        if (this.isInMemoryDb()) {
            return "";
        }
        if (!TextUtils.isEmpty(this.syncMode)) {
            return this.syncMode;
        }
        if (this.isWalEnabledInternal()) {
            if (this.isLegacyCompatibilityWalEnabled()) {
                return SQLiteCompatibilityWalFlags.getWALSyncMode();
            }
            return SQLiteGlobal.getWALSyncMode();
        }
        return SQLiteGlobal.getDefaultSyncMode();
    }

    private boolean isWalEnabledInternal() {
        boolean walEnabled = (this.openFlags & 0x20000000) != 0;
        boolean isCompatibilityWalEnabled = this.isLegacyCompatibilityWalEnabled();
        return walEnabled || isCompatibilityWalEnabled || this.journalMode != null && this.journalMode.equalsIgnoreCase("WAL");
    }
}

