/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.res.Resources;
import android.database.sqlite.SQLiteCompatibilityWalFlags;
import android.os.StatFs;
import android.os.SystemProperties;
import com.android.tools.layoutlib.create.OverrideMethod;

public class SQLiteGlobal {
    private static final String TAG = "SQLiteGlobal";
    public static final String SYNC_MODE_FULL = "FULL";
    static final String WIPE_CHECK_FILE_SUFFIX = "-wipecheck";
    private static final Object sLock = new Object();
    private static int sDefaultPageSize;
    public static volatile String sDefaultSyncMode;

    private static int nativeReleaseMemory() {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteGlobal#nativeReleaseMemory()I", true, null);
    }

    private SQLiteGlobal() {
    }

    public static int releaseMemory() {
        return SQLiteGlobal.nativeReleaseMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDefaultPageSize() {
        Object object = sLock;
        synchronized (object) {
            if (sDefaultPageSize == 0) {
                sDefaultPageSize = new StatFs("/data").getBlockSize();
            }
            return SystemProperties.getInt("debug.sqlite.pagesize", sDefaultPageSize);
        }
    }

    public static String getDefaultJournalMode() {
        return SystemProperties.get("debug.sqlite.journalmode", Resources.getSystem().getString(17040111));
    }

    public static int getJournalSizeLimit() {
        return SystemProperties.getInt("debug.sqlite.journalsizelimit", Resources.getSystem().getInteger(17695001));
    }

    public static String getDefaultSyncMode() {
        String defaultMode = sDefaultSyncMode;
        if (defaultMode != null) {
            return defaultMode;
        }
        return SystemProperties.get("debug.sqlite.syncmode", Resources.getSystem().getString(17040112));
    }

    public static String getWALSyncMode() {
        String defaultMode = sDefaultSyncMode;
        if (defaultMode != null) {
            return defaultMode;
        }
        return SystemProperties.get("debug.sqlite.wal.syncmode", Resources.getSystem().getString(17040113));
    }

    public static int getWALAutoCheckpoint() {
        int value = SystemProperties.getInt("debug.sqlite.wal.autocheckpoint", Resources.getSystem().getInteger(17695002));
        return Math.max(1, value);
    }

    public static int getWALConnectionPoolSize() {
        int value = SystemProperties.getInt("debug.sqlite.wal.poolsize", Resources.getSystem().getInteger(17694999));
        return Math.max(2, value);
    }

    public static int getIdleConnectionTimeout() {
        return SystemProperties.getInt("debug.sqlite.idle_connection_timeout", Resources.getSystem().getInteger(17695000));
    }

    public static long getWALTruncateSize() {
        long setting = SQLiteCompatibilityWalFlags.getTruncateSize();
        if (setting >= 0L) {
            return setting;
        }
        return SystemProperties.getInt("debug.sqlite.wal.truncatesize", Resources.getSystem().getInteger(17695003));
    }

    public static boolean checkDbWipe() {
        return false;
    }
}

