/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.ddm.DdmHandle;
import android.util.Log;
import android.view.View;
import android.view.ViewDebug;
import android.view.WindowManagerGlobal;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.Preconditions;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleViewDebug
extends DdmHandle {
    private static final int CHUNK_VULW = ChunkHandler.type("VULW");
    private static final int CHUNK_VURT = ChunkHandler.type("VURT");
    private static final int VURT_DUMP_HIERARCHY = 1;
    private static final int VURT_CAPTURE_LAYERS = 2;
    private static final int VURT_DUMP_THEME = 3;
    private static final int CHUNK_VUOP = ChunkHandler.type("VUOP");
    private static final int VUOP_CAPTURE_VIEW = 1;
    private static final int VUOP_DUMP_DISPLAYLIST = 2;
    private static final int VUOP_PROFILE_VIEW = 3;
    private static final int VUOP_INVOKE_VIEW_METHOD = 4;
    private static final int VUOP_SET_LAYOUT_PARAMETER = 5;
    private static final int ERR_INVALID_OP = -1;
    private static final int ERR_INVALID_PARAM = -2;
    private static final int ERR_EXCEPTION = -3;
    private static final String TAG = "DdmViewDebug";
    private static final DdmHandleViewDebug sInstance = new DdmHandleViewDebug();
    private static final char SIG_ARRAY = '[';
    private static final char SIG_BOOLEAN = 'Z';
    private static final char SIG_BYTE = 'B';
    private static final char SIG_SHORT = 'S';
    private static final char SIG_CHAR = 'C';
    private static final char SIG_INT = 'I';
    private static final char SIG_LONG = 'J';
    private static final char SIG_FLOAT = 'F';
    private static final char SIG_DOUBLE = 'D';
    private static final char SIG_VOID = 'V';
    private static final char SIG_STRING = 'R';

    private DdmHandleViewDebug() {
    }

    public static void register() {
        DdmServer.registerHandler(CHUNK_VULW, sInstance);
        DdmServer.registerHandler(CHUNK_VURT, sInstance);
        DdmServer.registerHandler(CHUNK_VUOP, sInstance);
    }

    @Override
    public void onConnected() {
    }

    @Override
    public void onDisconnected() {
    }

    @Override
    public Chunk handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_VULW) {
            return this.listWindows();
        }
        ByteBuffer in = DdmHandleViewDebug.wrapChunk(request);
        int op = in.getInt();
        View rootView = this.getRootView(in);
        if (rootView == null) {
            return DdmHandleViewDebug.createFailChunk(-2, "Invalid View Root");
        }
        if (type == CHUNK_VURT) {
            if (op == 1) {
                return this.dumpHierarchy(rootView, in);
            }
            if (op == 2) {
                return this.captureLayers(rootView);
            }
            if (op == 3) {
                return this.dumpTheme(rootView);
            }
            return DdmHandleViewDebug.createFailChunk(-1, "Unknown view root operation: " + op);
        }
        View targetView = this.getTargetView(rootView, in);
        if (targetView == null) {
            return DdmHandleViewDebug.createFailChunk(-2, "Invalid target view");
        }
        if (type == CHUNK_VUOP) {
            switch (op) {
                case 1: {
                    return this.captureView(rootView, targetView);
                }
                case 2: {
                    return this.dumpDisplayLists(rootView, targetView);
                }
                case 3: {
                    return this.profileView(rootView, targetView);
                }
                case 4: {
                    return this.invokeViewMethod(rootView, targetView, in);
                }
                case 5: {
                    return this.setLayoutParameter(rootView, targetView, in);
                }
            }
            return DdmHandleViewDebug.createFailChunk(-1, "Unknown view operation: " + op);
        }
        throw new RuntimeException("Unknown packet " + DdmHandleViewDebug.name(type));
    }

    private Chunk listWindows() {
        String[] windowNames = WindowManagerGlobal.getInstance().getViewRootNames();
        int responseLength = 4;
        for (String name : windowNames) {
            responseLength += 4;
            responseLength += name.length() * 2;
        }
        ByteBuffer out = ByteBuffer.allocate(responseLength);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(windowNames.length);
        for (String name : windowNames) {
            out.putInt(name.length());
            DdmHandleViewDebug.putString(out, name);
        }
        return new Chunk(CHUNK_VULW, out);
    }

    private View getRootView(ByteBuffer in) {
        try {
            int viewRootNameLength = in.getInt();
            String viewRootName = DdmHandleViewDebug.getString(in, viewRootNameLength);
            return WindowManagerGlobal.getInstance().getRootView(viewRootName);
        }
        catch (BufferUnderflowException e) {
            return null;
        }
    }

    private View getTargetView(View root, ByteBuffer in) {
        String viewName;
        try {
            int viewLength = in.getInt();
            viewName = DdmHandleViewDebug.getString(in, viewLength);
        }
        catch (BufferUnderflowException e) {
            return null;
        }
        return ViewDebug.findView(root, viewName);
    }

    private Chunk dumpHierarchy(View rootView, ByteBuffer in) {
        boolean skipChildren = in.getInt() > 0;
        boolean includeProperties = in.getInt() > 0;
        boolean v2 = in.hasRemaining() && in.getInt() > 0;
        long start = System_Delegate.currentTimeMillis();
        ByteArrayOutputStream b = new ByteArrayOutputStream(0x200000);
        try {
            if (v2) {
                ViewDebug.dumpv2(rootView, b);
            } else {
                ViewDebug.dump(rootView, skipChildren, includeProperties, b);
            }
        }
        catch (IOException | InterruptedException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while obtaining view hierarchy: " + e.getMessage());
        }
        long end = System_Delegate.currentTimeMillis();
        Log.d(TAG, "Time to obtain view hierarchy (ms): " + (end - start));
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk captureLayers(View rootView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        DataOutputStream dos = new DataOutputStream(b);
        try {
            ViewDebug.captureLayers(rootView, dos);
        }
        catch (IOException e) {
            Chunk chunk = DdmHandleViewDebug.createFailChunk(1, "Unexpected error while obtaining view hierarchy: " + e.getMessage());
            return chunk;
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException iOException) {}
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    private Chunk dumpTheme(View rootView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.dumpTheme(rootView, b);
        }
        catch (IOException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while dumping the theme: " + e.getMessage());
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VURT, data, 0, data.length);
    }

    private Chunk captureView(View rootView, View targetView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(1024);
        try {
            ViewDebug.capture(rootView, (OutputStream)b, targetView);
        }
        catch (IOException e) {
            return DdmHandleViewDebug.createFailChunk(1, "Unexpected error while capturing view: " + e.getMessage());
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VUOP, data, 0, data.length);
    }

    private Chunk dumpDisplayLists(final View rootView, final View targetView) {
        rootView.post(new Runnable(){

            @Override
            public void run() {
                ViewDebug.outputDisplayList(rootView, targetView);
            }
        });
        return null;
    }

    private Chunk invokeViewMethod(View rootView, View targetView, ByteBuffer in) {
        Method method;
        Object[] args;
        Class[] argTypes;
        int l = in.getInt();
        String methodName = DdmHandleViewDebug.getString(in, l);
        if (!in.hasRemaining()) {
            argTypes = new Class[]{};
            args = new Object[]{};
        } else {
            int nArgs = in.getInt();
            argTypes = new Class[nArgs];
            args = new Object[nArgs];
            try {
                DdmHandleViewDebug.deserializeMethodParameters(args, argTypes, in);
            }
            catch (ViewMethodInvocationSerializationException e) {
                return DdmHandleViewDebug.createFailChunk(-2, e.getMessage());
            }
        }
        try {
            method = targetView.getClass().getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            Log.e(TAG, "No such method: " + e.getMessage());
            return DdmHandleViewDebug.createFailChunk(-2, "No such method: " + e.getMessage());
        }
        try {
            Object result = ViewDebug.invokeViewMethod(targetView, method, args);
            Class<?> returnType = method.getReturnType();
            byte[] returnValue = DdmHandleViewDebug.serializeReturnValue(returnType, returnType.cast(result));
            return new Chunk(CHUNK_VUOP, returnValue, 0, returnValue.length);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception while invoking method: " + e.getCause().getMessage());
            String msg = e.getCause().getMessage();
            if (msg == null) {
                msg = e.getCause().toString();
            }
            return DdmHandleViewDebug.createFailChunk(-3, msg);
        }
    }

    private Chunk setLayoutParameter(View rootView, View targetView, ByteBuffer in) {
        int l = in.getInt();
        String param = DdmHandleViewDebug.getString(in, l);
        int value = in.getInt();
        try {
            ViewDebug.setLayoutParameter(targetView, param, value);
        }
        catch (Exception e) {
            Log.e(TAG, "Exception setting layout parameter: " + e);
            return DdmHandleViewDebug.createFailChunk(-3, "Error accessing field " + param + ":" + e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chunk profileView(View rootView, View targetView) {
        ByteArrayOutputStream b = new ByteArrayOutputStream(32768);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(b), 32768);
        try {
            ViewDebug.profileViewAndChildren(targetView, bw);
        }
        catch (IOException e) {
            Chunk chunk = DdmHandleViewDebug.createFailChunk(1, "Unexpected error while profiling view: " + e.getMessage());
            return chunk;
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
        byte[] data = b.toByteArray();
        return new Chunk(CHUNK_VUOP, data, 0, data.length);
    }

    @VisibleForTesting
    public static void deserializeMethodParameters(Object[] args, Class<?>[] argTypes, ByteBuffer in) throws ViewMethodInvocationSerializationException {
        Preconditions.checkArgument(args.length == argTypes.length);
        block11: for (int i = 0; i < args.length; ++i) {
            boolean isArray;
            char typeSignature = in.getChar();
            boolean bl = isArray = typeSignature == '[';
            if (isArray) {
                char arrayType = in.getChar();
                if (arrayType != 'B') {
                    throw new ViewMethodInvocationSerializationException("Unsupported array parameter type (" + typeSignature + ") to invoke view method @argument " + i);
                }
                int arrayLength = in.getInt();
                if (arrayLength > in.remaining()) {
                    throw new BufferUnderflowException();
                }
                byte[] byteArray = new byte[arrayLength];
                in.get(byteArray);
                argTypes[i] = byte[].class;
                args[i] = byteArray;
                continue;
            }
            switch (typeSignature) {
                case 'Z': {
                    argTypes[i] = Boolean.TYPE;
                    args[i] = in.get() != 0;
                    continue block11;
                }
                case 'B': {
                    argTypes[i] = Byte.TYPE;
                    args[i] = in.get();
                    continue block11;
                }
                case 'C': {
                    argTypes[i] = Character.TYPE;
                    args[i] = Character.valueOf(in.getChar());
                    continue block11;
                }
                case 'S': {
                    argTypes[i] = Short.TYPE;
                    args[i] = in.getShort();
                    continue block11;
                }
                case 'I': {
                    argTypes[i] = Integer.TYPE;
                    args[i] = in.getInt();
                    continue block11;
                }
                case 'J': {
                    argTypes[i] = Long.TYPE;
                    args[i] = in.getLong();
                    continue block11;
                }
                case 'F': {
                    argTypes[i] = Float.TYPE;
                    args[i] = Float.valueOf(in.getFloat());
                    continue block11;
                }
                case 'D': {
                    argTypes[i] = Double.TYPE;
                    args[i] = in.getDouble();
                    continue block11;
                }
                case 'R': {
                    argTypes[i] = String.class;
                    int stringUtf8ByteCount = Short.toUnsignedInt(in.getShort());
                    byte[] rawStringBuffer = new byte[stringUtf8ByteCount];
                    in.get(rawStringBuffer);
                    args[i] = new String(rawStringBuffer, StandardCharsets.UTF_8);
                    continue block11;
                }
                default: {
                    Log.e(TAG, "arg " + i + ", unrecognized type: " + typeSignature);
                    throw new ViewMethodInvocationSerializationException("Unsupported parameter type (" + typeSignature + ") to invoke view method.");
                }
            }
        }
    }

    @VisibleForTesting
    public static byte[] serializeReturnValue(Class<?> type, Object value) throws ViewMethodInvocationSerializationException, IOException {
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(1024);
        DataOutputStream dos = new DataOutputStream(byteOutStream);
        if (type.isArray()) {
            if (!type.equals(byte[].class)) {
                throw new ViewMethodInvocationSerializationException("Unsupported array return type (" + type + ")");
            }
            byte[] byteArray = (byte[])value;
            dos.writeChar(91);
            dos.writeChar(66);
            dos.writeInt(byteArray.length);
            dos.write(byteArray);
        } else if (Boolean.TYPE.equals(type)) {
            dos.writeChar(90);
            dos.write((Boolean)value != false ? 1 : 0);
        } else if (Byte.TYPE.equals(type)) {
            dos.writeChar(66);
            dos.writeByte(((Byte)value).byteValue());
        } else if (Character.TYPE.equals(type)) {
            dos.writeChar(67);
            dos.writeChar(((Character)value).charValue());
        } else if (Short.TYPE.equals(type)) {
            dos.writeChar(83);
            dos.writeShort(((Short)value).shortValue());
        } else if (Integer.TYPE.equals(type)) {
            dos.writeChar(73);
            dos.writeInt((Integer)value);
        } else if (Long.TYPE.equals(type)) {
            dos.writeChar(74);
            dos.writeLong((Long)value);
        } else if (Double.TYPE.equals(type)) {
            dos.writeChar(68);
            dos.writeDouble((Double)value);
        } else if (Float.TYPE.equals(type)) {
            dos.writeChar(70);
            dos.writeFloat(((Float)value).floatValue());
        } else if (String.class.equals(type)) {
            dos.writeChar(82);
            dos.writeUTF(value != null ? (String)value : "");
        } else {
            dos.writeChar(86);
        }
        return byteOutStream.toByteArray();
    }

    @VisibleForTesting
    public static class ViewMethodInvocationSerializationException
    extends Exception {
        ViewMethodInvocationSerializationException(String message) {
            super(message);
        }
    }
}

