/*
 * Decompiled with CFR 0.152.
 */
package android.devicelock;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.content.Context;
import android.devicelock.DeviceId;
import android.devicelock.IDeviceLockService;
import android.devicelock.IGetDeviceIdCallback;
import android.devicelock.IGetKioskAppsCallback;
import android.devicelock.IIsDeviceLockedCallback;
import android.devicelock.ILockUnlockDeviceCallback;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class DeviceLockManager {
    private static final String TAG = "DeviceLockManager";
    private final IDeviceLockService mService;
    public static final int DEVICE_LOCK_ROLE_FINANCING = 0;
    private static final Map<Class, Map<Integer, Exception>> ERROR_MAP = Map.of(ILockUnlockDeviceCallback.class, Map.of(0, DeviceLockManager.getUnknwnException(), 1, DeviceLockManager.getSecurityException()), IIsDeviceLockedCallback.class, Map.of(0, DeviceLockManager.getUnknwnException(), 1, DeviceLockManager.getSecurityException()), IGetDeviceIdCallback.class, Map.of(0, DeviceLockManager.getUnknwnException(), 1, DeviceLockManager.getSecurityException(), 2, new Exception("Invalid device type"), 3, new Exception("Unable to get device id")), IGetKioskAppsCallback.class, Map.of(0, DeviceLockManager.getUnknwnException()));

    private static SecurityException getSecurityException() {
        return new SecurityException("Need MANAGE_DEVICE_LOCK_STATE permission");
    }

    private static Exception getUnknwnException() {
        return new Exception("Unknown error");
    }

    private static Exception getException(Class clazz, int error) {
        Map<Integer, Exception> map = ERROR_MAP.get(clazz);
        if (map == null) {
            Log.e(TAG, "Cannot find error map for: " + clazz.getSimpleName());
            return new Exception();
        }
        Exception ex = map.get(error);
        if (ex == null) {
            return new Exception();
        }
        return ex;
    }

    public DeviceLockManager(Context context, IDeviceLockService service) {
        this.mService = service;
    }

    public IDeviceLockService getService() {
        return this.mService;
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    public void lockDevice(final Executor executor, final OutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.lockDevice(new ILockUnlockDeviceCallback.Stub(){

                @Override
                public void onDeviceLockedUnlocked() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(int error) {
                    callback.onError(DeviceLockManager.getException(ILockUnlockDeviceCallback.class, error));
                }
            });
        }
        catch (RemoteException e) {
            executor.execute(() -> callback.onError(new RuntimeException(e)));
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    public void unlockDevice(final Executor executor, final OutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.unlockDevice(new ILockUnlockDeviceCallback.Stub(){

                @Override
                public void onDeviceLockedUnlocked() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(int error) {
                    callback.onError(DeviceLockManager.getException(ILockUnlockDeviceCallback.class, error));
                }
            });
        }
        catch (RemoteException e) {
            executor.execute(() -> callback.onError(new RuntimeException(e)));
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    public void isDeviceLocked(final Executor executor, final OutcomeReceiver<Boolean, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.isDeviceLocked(new IIsDeviceLockedCallback.Stub(){

                @Override
                public void onIsDeviceLocked(boolean locked) {
                    executor.execute(() -> callback.onResult(locked));
                }

                @Override
                public void onError(int error) {
                    executor.execute(() -> callback.onError(DeviceLockManager.getException(IIsDeviceLockedCallback.class, error)));
                }
            });
        }
        catch (RemoteException e) {
            executor.execute(() -> callback.onError(new RuntimeException(e)));
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    public void getDeviceId(final Executor executor, final OutcomeReceiver<DeviceId, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getDeviceId(new IGetDeviceIdCallback.Stub(){

                @Override
                public void onDeviceIdReceived(int type, String id2) {
                    if (TextUtils.isEmpty(id2)) {
                        executor.execute(() -> callback.onError(new Exception("Cannot get device id (empty)")));
                    } else {
                        executor.execute(() -> callback.onResult(new DeviceId(type, id2)));
                    }
                }

                @Override
                public void onError(int error) {
                    callback.onError(DeviceLockManager.getException(IGetDeviceIdCallback.class, error));
                }
            });
        }
        catch (RemoteException e) {
            executor.execute(() -> callback.onError(new RuntimeException(e)));
        }
    }

    @RequiresNoPermission
    public void getKioskApps(final Executor executor, final OutcomeReceiver<Map<Integer, String>, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getKioskApps(new IGetKioskAppsCallback.Stub(){

                @Override
                public void onKioskAppsReceived(Map kioskApps) {
                    executor.execute(() -> callback.onResult(kioskApps));
                }

                @Override
                public void onError(int error) {
                    callback.onError(DeviceLockManager.getException(IGetKioskAppsCallback.class, error));
                }
            });
        }
        catch (RemoteException e) {
            executor.execute(() -> callback.onError(new RuntimeException(e)));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceLockRole {
    }
}

