/*
 * Decompiled with CFR 0.152.
 */
package android.devicelock;

import android.devicelock.IGetDeviceIdCallback;
import android.devicelock.IGetKioskAppsCallback;
import android.devicelock.IIsDeviceLockedCallback;
import android.devicelock.ILockUnlockDeviceCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;

public interface IDeviceLockService
extends IInterface {
    public static final String DESCRIPTOR = "android.devicelock.IDeviceLockService";
    public static final int DEVICE_LOCK_ROLE_FINANCING = 0;
    public static final String KEY_REMOTE_CALLBACK_RESULT = "KEY_REMOTE_CALLBACK_RESULT";

    public void lockDevice(ILockUnlockDeviceCallback var1) throws RemoteException;

    public void unlockDevice(ILockUnlockDeviceCallback var1) throws RemoteException;

    public void isDeviceLocked(IIsDeviceLockedCallback var1) throws RemoteException;

    public void getDeviceId(IGetDeviceIdCallback var1) throws RemoteException;

    public void getKioskApps(IGetKioskAppsCallback var1) throws RemoteException;

    public void addFinancedDeviceKioskRole(String var1, RemoteCallback var2) throws RemoteException;

    public void removeFinancedDeviceKioskRole(String var1, RemoteCallback var2) throws RemoteException;

    public void setExemptFromActivityBackgroundStartRestriction(boolean var1, RemoteCallback var2) throws RemoteException;

    public void setExemptFromHibernation(String var1, boolean var2, RemoteCallback var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDeviceLockService {
        static final int TRANSACTION_lockDevice = 1;
        static final int TRANSACTION_unlockDevice = 2;
        static final int TRANSACTION_isDeviceLocked = 3;
        static final int TRANSACTION_getDeviceId = 4;
        static final int TRANSACTION_getKioskApps = 5;
        static final int TRANSACTION_addFinancedDeviceKioskRole = 6;
        static final int TRANSACTION_removeFinancedDeviceKioskRole = 7;
        static final int TRANSACTION_setExemptFromActivityBackgroundStartRestriction = 8;
        static final int TRANSACTION_setExemptFromHibernation = 9;

        public Stub() {
            this.attachInterface(this, IDeviceLockService.DESCRIPTOR);
        }

        public static IDeviceLockService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDeviceLockService.DESCRIPTOR);
            if (iin != null && iin instanceof IDeviceLockService) {
                return (IDeviceLockService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "lockDevice";
                }
                case 2: {
                    return "unlockDevice";
                }
                case 3: {
                    return "isDeviceLocked";
                }
                case 4: {
                    return "getDeviceId";
                }
                case 5: {
                    return "getKioskApps";
                }
                case 6: {
                    return "addFinancedDeviceKioskRole";
                }
                case 7: {
                    return "removeFinancedDeviceKioskRole";
                }
                case 8: {
                    return "setExemptFromActivityBackgroundStartRestriction";
                }
                case 9: {
                    return "setExemptFromHibernation";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDeviceLockService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ILockUnlockDeviceCallback _arg0 = ILockUnlockDeviceCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.lockDevice(_arg0);
                    break;
                }
                case 2: {
                    ILockUnlockDeviceCallback _arg0 = ILockUnlockDeviceCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unlockDevice(_arg0);
                    break;
                }
                case 3: {
                    IIsDeviceLockedCallback _arg0 = IIsDeviceLockedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.isDeviceLocked(_arg0);
                    break;
                }
                case 4: {
                    IGetDeviceIdCallback _arg0 = IGetDeviceIdCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getDeviceId(_arg0);
                    break;
                }
                case 5: {
                    IGetKioskAppsCallback _arg0 = IGetKioskAppsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getKioskApps(_arg0);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.addFinancedDeviceKioskRole(_arg0, _arg1);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeFinancedDeviceKioskRole(_arg0, _arg1);
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.setExemptFromActivityBackgroundStartRestriction(_arg0, _arg1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.setExemptFromHibernation(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IDeviceLockService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDeviceLockService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockDevice(ILockUnlockDeviceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockDevice(ILockUnlockDeviceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isDeviceLocked(IIsDeviceLockedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDeviceId(IGetDeviceIdCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getKioskApps(IGetKioskAppsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addFinancedDeviceKioskRole(String packageName, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeFinancedDeviceKioskRole(String packageName, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExemptFromActivityBackgroundStartRestriction(boolean exempt, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeBoolean(exempt);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setExemptFromHibernation(String packageName, boolean exempt, RemoteCallback remoteCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDeviceLockService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeBoolean(exempt);
                    _data.writeTypedObject(remoteCallback, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDeviceLockService {
        @Override
        public void lockDevice(ILockUnlockDeviceCallback callback) throws RemoteException {
        }

        @Override
        public void unlockDevice(ILockUnlockDeviceCallback callback) throws RemoteException {
        }

        @Override
        public void isDeviceLocked(IIsDeviceLockedCallback callback) throws RemoteException {
        }

        @Override
        public void getDeviceId(IGetDeviceIdCallback callback) throws RemoteException {
        }

        @Override
        public void getKioskApps(IGetKioskAppsCallback callback) throws RemoteException {
        }

        @Override
        public void addFinancedDeviceKioskRole(String packageName, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void removeFinancedDeviceKioskRole(String packageName, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void setExemptFromActivityBackgroundStartRestriction(boolean exempt, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public void setExemptFromHibernation(String packageName, boolean exempt, RemoteCallback remoteCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

