/*
 * Decompiled with CFR 0.152.
 */
package android.devicelock;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILockUnlockDeviceCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.devicelock.ILockUnlockDeviceCallback";
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_SECURITY = 1;

    public void onDeviceLockedUnlocked() throws RemoteException;

    public void onError(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILockUnlockDeviceCallback {
        static final int TRANSACTION_onDeviceLockedUnlocked = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, ILockUnlockDeviceCallback.DESCRIPTOR);
        }

        public static ILockUnlockDeviceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILockUnlockDeviceCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ILockUnlockDeviceCallback) {
                return (ILockUnlockDeviceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDeviceLockedUnlocked";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILockUnlockDeviceCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.onDeviceLockedUnlocked();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ILockUnlockDeviceCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILockUnlockDeviceCallback.DESCRIPTOR;
            }

            @Override
            public void onDeviceLockedUnlocked() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ILockUnlockDeviceCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int error) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ILockUnlockDeviceCallback.DESCRIPTOR);
                    _data.writeInt(error);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILockUnlockDeviceCallback {
        @Override
        public void onDeviceLockedUnlocked() throws RemoteException {
        }

        @Override
        public void onError(int error) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

