/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import libcore.util.NativeAllocationRegistry;

public final class Gainmap
implements Parcelable {
    final long mNativePtr;
    private Bitmap mGainmapContents;
    public static final Parcelable.Creator<Gainmap> CREATOR = new Parcelable.Creator<Gainmap>(){

        @Override
        public Gainmap createFromParcel(Parcel in) {
            Gainmap gm = new Gainmap(in.readTypedObject(Bitmap.CREATOR));
            Gainmap.nReadGainmapFromParcel(gm.mNativePtr, in);
            return gm;
        }

        public Gainmap[] newArray(int size) {
            return new Gainmap[size];
        }
    };

    private Gainmap(Bitmap gainmapContents, long nativeGainmap) {
        if (nativeGainmap == 0L) {
            throw new RuntimeException("internal error: native gainmap is 0");
        }
        this.mNativePtr = nativeGainmap;
        this.setGainmapContents(gainmapContents);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, nativeGainmap);
    }

    public Gainmap(Bitmap gainmapContents) {
        this(gainmapContents, Gainmap.nCreateEmpty());
    }

    public Gainmap(Gainmap gainmap, Bitmap gainmapContents) {
        this(gainmapContents, Gainmap.nCreateCopy(gainmap.mNativePtr));
    }

    public Bitmap getGainmapContents() {
        return this.mGainmapContents;
    }

    public void setGainmapContents(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("Bitmap is recycled");
        }
        Gainmap.nSetBitmap(this.mNativePtr, bitmap);
        this.mGainmapContents = bitmap;
    }

    public void setRatioMin(float r, float g, float b) {
        Gainmap.nSetRatioMin(this.mNativePtr, r, g, b);
    }

    public float[] getRatioMin() {
        float[] ret = new float[3];
        Gainmap.nGetRatioMin(this.mNativePtr, ret);
        return ret;
    }

    public void setRatioMax(float r, float g, float b) {
        Gainmap.nSetRatioMax(this.mNativePtr, r, g, b);
    }

    public float[] getRatioMax() {
        float[] ret = new float[3];
        Gainmap.nGetRatioMax(this.mNativePtr, ret);
        return ret;
    }

    public void setGamma(float r, float g, float b) {
        Gainmap.nSetGamma(this.mNativePtr, r, g, b);
    }

    public float[] getGamma() {
        float[] ret = new float[3];
        Gainmap.nGetGamma(this.mNativePtr, ret);
        return ret;
    }

    public void setEpsilonSdr(float r, float g, float b) {
        Gainmap.nSetEpsilonSdr(this.mNativePtr, r, g, b);
    }

    public float[] getEpsilonSdr() {
        float[] ret = new float[3];
        Gainmap.nGetEpsilonSdr(this.mNativePtr, ret);
        return ret;
    }

    public void setEpsilonHdr(float r, float g, float b) {
        Gainmap.nSetEpsilonHdr(this.mNativePtr, r, g, b);
    }

    public float[] getEpsilonHdr() {
        float[] ret = new float[3];
        Gainmap.nGetEpsilonHdr(this.mNativePtr, ret);
        return ret;
    }

    public void setDisplayRatioForFullHdr(float max) {
        if (!Float.isFinite(max) || max < 1.0f) {
            throw new IllegalArgumentException("setDisplayRatioForFullHdr must be >= 1.0f, got = " + max);
        }
        Gainmap.nSetDisplayRatioHdr(this.mNativePtr, max);
    }

    public float getDisplayRatioForFullHdr() {
        return Gainmap.nGetDisplayRatioHdr(this.mNativePtr);
    }

    public void setMinDisplayRatioForHdrTransition(float min) {
        if (!Float.isFinite(min) || min < 1.0f) {
            throw new IllegalArgumentException("setMinDisplayRatioForHdrTransition must be >= 1.0f, got = " + min);
        }
        Gainmap.nSetDisplayRatioSdr(this.mNativePtr, min);
    }

    public float getMinDisplayRatioForHdrTransition() {
        return Gainmap.nGetDisplayRatioSdr(this.mNativePtr);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("Cannot be written to a parcel");
        }
        dest.writeTypedObject(this.mGainmapContents, flags);
        Gainmap.nWriteGainmapToParcel(this.mNativePtr, dest);
    }

    private static native long nGetFinalizer();

    private static native long nCreateEmpty();

    private static native long nCreateCopy(long var0);

    private static native void nSetBitmap(long var0, Bitmap var2);

    private static native void nSetRatioMin(long var0, float var2, float var3, float var4);

    private static native void nGetRatioMin(long var0, float[] var2);

    private static native void nSetRatioMax(long var0, float var2, float var3, float var4);

    private static native void nGetRatioMax(long var0, float[] var2);

    private static native void nSetGamma(long var0, float var2, float var3, float var4);

    private static native void nGetGamma(long var0, float[] var2);

    private static native void nSetEpsilonSdr(long var0, float var2, float var3, float var4);

    private static native void nGetEpsilonSdr(long var0, float[] var2);

    private static native void nSetEpsilonHdr(long var0, float var2, float var3, float var4);

    private static native void nGetEpsilonHdr(long var0, float[] var2);

    private static native void nSetDisplayRatioHdr(long var0, float var2);

    private static native float nGetDisplayRatioHdr(long var0);

    private static native void nSetDisplayRatioSdr(long var0, float var2);

    private static native float nGetDisplayRatioSdr(long var0);

    private static native void nWriteGainmapToParcel(long var0, Parcel var2);

    private static native void nReadGainmapFromParcel(long var0, Parcel var2);

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Gainmap.class.getClassLoader(), Gainmap.nGetFinalizer());

        private NoImagePreloadHolder() {
        }
    }
}

