/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;

public class GraphicBuffer
implements Parcelable {
    public static final int USAGE_SW_READ_NEVER = 0;
    public static final int USAGE_SW_READ_RARELY = 2;
    public static final int USAGE_SW_READ_OFTEN = 3;
    public static final int USAGE_SW_READ_MASK = 15;
    public static final int USAGE_SW_WRITE_NEVER = 0;
    public static final int USAGE_SW_WRITE_RARELY = 32;
    public static final int USAGE_SW_WRITE_OFTEN = 48;
    public static final int USAGE_SW_WRITE_MASK = 240;
    public static final int USAGE_SOFTWARE_MASK = 255;
    public static final int USAGE_PROTECTED = 16384;
    public static final int USAGE_HW_TEXTURE = 256;
    public static final int USAGE_HW_RENDER = 512;
    public static final int USAGE_HW_2D = 1024;
    public static final int USAGE_HW_COMPOSER = 2048;
    public static final int USAGE_HW_VIDEO_ENCODER = 65536;
    public static final int USAGE_HW_MASK = 466688;
    private final int mWidth;
    private final int mHeight;
    private final int mFormat;
    private final int mUsage;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mNativeObject;
    private Canvas mCanvas;
    private int mSaveCount;
    private boolean mDestroyed;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<GraphicBuffer> CREATOR = new Parcelable.Creator<GraphicBuffer>(){

        @Override
        public GraphicBuffer createFromParcel(Parcel in) {
            int width = in.readInt();
            int height = in.readInt();
            int format = in.readInt();
            int usage = in.readInt();
            long nativeObject = GraphicBuffer.nReadGraphicBufferFromParcel(in);
            if (nativeObject != 0L) {
                return new GraphicBuffer(width, height, format, usage, nativeObject);
            }
            return null;
        }

        public GraphicBuffer[] newArray(int size) {
            return new GraphicBuffer[size];
        }
    };

    public static GraphicBuffer create(int width, int height, int format, int usage) {
        long nativeObject = GraphicBuffer.nCreateGraphicBuffer(width, height, format, usage);
        if (nativeObject != 0L) {
            return new GraphicBuffer(width, height, format, usage, nativeObject);
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private GraphicBuffer(int width, int height, int format, int usage, long nativeObject) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mUsage = usage;
        this.mNativeObject = nativeObject;
    }

    public static GraphicBuffer createFromHardwareBuffer(HardwareBuffer buffer) {
        return GraphicBuffer.nCreateFromHardwareBuffer(buffer);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getFormat() {
        return this.mFormat;
    }

    public int getUsage() {
        return this.mUsage;
    }

    public Canvas lockCanvas() {
        return this.lockCanvas(null);
    }

    public Canvas lockCanvas(Rect dirty) {
        if (this.mDestroyed) {
            return null;
        }
        if (this.mCanvas == null) {
            this.mCanvas = new Canvas();
        }
        if (GraphicBuffer.nLockCanvas(this.mNativeObject, this.mCanvas, dirty)) {
            this.mSaveCount = this.mCanvas.save();
            return this.mCanvas;
        }
        return null;
    }

    public void unlockCanvasAndPost(Canvas canvas) {
        if (!this.mDestroyed && this.mCanvas != null && canvas == this.mCanvas) {
            canvas.restoreToCount(this.mSaveCount);
            this.mSaveCount = 0;
            GraphicBuffer.nUnlockCanvasAndPost(this.mNativeObject, this.mCanvas);
        }
    }

    public void destroy() {
        if (!this.mDestroyed) {
            this.mDestroyed = true;
            GraphicBuffer.nDestroyGraphicBuffer(this.mNativeObject);
            this.mNativeObject = 0L;
        }
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mDestroyed) {
            throw new IllegalStateException("This GraphicBuffer has been destroyed and cannot be written to a parcel.");
        }
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mFormat);
        dest.writeInt(this.mUsage);
        GraphicBuffer.nWriteGraphicBufferToParcel(this.mNativeObject, dest);
    }

    private static long nCreateGraphicBuffer(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeL("android.graphics.GraphicBuffer#nCreateGraphicBuffer(IIII)J", true, null);
    }

    private static void nDestroyGraphicBuffer(long l) {
        OverrideMethod.invokeV("android.graphics.GraphicBuffer#nDestroyGraphicBuffer(J)V", true, null);
    }

    private static void nWriteGraphicBufferToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.graphics.GraphicBuffer#nWriteGraphicBufferToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static long nReadGraphicBufferFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.graphics.GraphicBuffer#nReadGraphicBufferFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static boolean nLockCanvas(long l, Canvas canvas, Rect rect) {
        return OverrideMethod.invokeI("android.graphics.GraphicBuffer#nLockCanvas(JLandroid/graphics/Canvas;Landroid/graphics/Rect;)Z", true, null) != 0;
    }

    private static boolean nUnlockCanvasAndPost(long l, Canvas canvas) {
        return OverrideMethod.invokeI("android.graphics.GraphicBuffer#nUnlockCanvasAndPost(JLandroid/graphics/Canvas;)Z", true, null) != 0;
    }

    private static GraphicBuffer nCreateFromHardwareBuffer(HardwareBuffer hardwareBuffer) {
        return (GraphicBuffer)OverrideMethod.invokeA("android.graphics.GraphicBuffer#nCreateFromHardwareBuffer(Landroid/hardware/HardwareBuffer;)Landroid/graphics/GraphicBuffer;", true, null);
    }
}

