/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorSpace;
import android.graphics.RecordingCanvas;
import android.graphics.RenderNode;
import android.hardware.HardwareBuffer;
import android.hardware.SyncFence;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import libcore.util.NativeAllocationRegistry;

public class HardwareBufferRenderer
implements AutoCloseable {
    private static final ColorSpace DEFAULT_COLORSPACE = ColorSpace.get(ColorSpace.Named.SRGB);
    private final HardwareBuffer mHardwareBuffer;
    private final RenderRequest mRenderRequest;
    private final RenderNode mRootNode;
    private final Runnable mCleaner;
    private long mProxy;

    public HardwareBufferRenderer(HardwareBuffer buffer) {
        RenderNode rootNode = RenderNode.adopt(HardwareBufferRenderer.nCreateRootRenderNode());
        rootNode.setClipToBounds(false);
        this.mProxy = HardwareBufferRenderer.nCreateHardwareBufferRenderer(buffer, rootNode.mNativeRenderNode);
        this.mCleaner = HardwareBufferRendererHolder.REGISTRY.registerNativeAllocation(this, this.mProxy);
        this.mRenderRequest = new RenderRequest();
        this.mRootNode = rootNode;
        this.mHardwareBuffer = buffer;
    }

    public void setContentRoot(RenderNode content) {
        RecordingCanvas canvas = this.mRootNode.beginRecording();
        if (content != null) {
            canvas.drawRenderNode(content);
        }
        this.mRootNode.endRecording();
    }

    public RenderRequest obtainRenderRequest() {
        this.mRenderRequest.reset();
        return this.mRenderRequest;
    }

    public boolean isClosed() {
        return this.mProxy == 0L;
    }

    @Override
    public void close() {
        HardwareBufferRenderer.nDestroyRootRenderNode(this.mRootNode.mNativeRenderNode);
        if (this.mProxy != 0L) {
            this.mCleaner.run();
            this.mProxy = 0L;
        }
    }

    public void setLightSourceGeometry(float lightX, float lightY, float lightZ, float lightRadius) {
        HardwareBufferRenderer.validateFinite(lightX, "lightX");
        HardwareBufferRenderer.validateFinite(lightY, "lightY");
        HardwareBufferRenderer.validatePositive(lightZ, "lightZ");
        HardwareBufferRenderer.validatePositive(lightRadius, "lightRadius");
        HardwareBufferRenderer.nSetLightGeometry(this.mProxy, lightX, lightY, lightZ, lightRadius);
    }

    public void setLightSourceAlpha(float ambientShadowAlpha, float spotShadowAlpha) {
        HardwareBufferRenderer.validateAlpha(ambientShadowAlpha, "ambientShadowAlpha");
        HardwareBufferRenderer.validateAlpha(spotShadowAlpha, "spotShadowAlpha");
        HardwareBufferRenderer.nSetLightAlpha(this.mProxy, ambientShadowAlpha, spotShadowAlpha);
    }

    static int nRender(long l, int n, int n2, int n3, long l2, Consumer<RenderResult> consumer) {
        return OverrideMethod.invokeI("android.graphics.HardwareBufferRenderer#nRender(JIIIJLjava/util/function/Consumer;)I", true, null);
    }

    private static long nCreateRootRenderNode() {
        return OverrideMethod.invokeL("android.graphics.HardwareBufferRenderer#nCreateRootRenderNode()J", true, null);
    }

    private static void nDestroyRootRenderNode(long l) {
        OverrideMethod.invokeV("android.graphics.HardwareBufferRenderer#nDestroyRootRenderNode(J)V", true, null);
    }

    private static long nCreateHardwareBufferRenderer(HardwareBuffer hardwareBuffer, long l) {
        return OverrideMethod.invokeL("android.graphics.HardwareBufferRenderer#nCreateHardwareBufferRenderer(Landroid/hardware/HardwareBuffer;J)J", true, null);
    }

    private static void nSetLightGeometry(long l, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.graphics.HardwareBufferRenderer#nSetLightGeometry(JFFFF)V", true, null);
    }

    private static void nSetLightAlpha(long l, float f, float f2) {
        OverrideMethod.invokeV("android.graphics.HardwareBufferRenderer#nSetLightAlpha(JFF)V", true, null);
    }

    private static long nGetFinalizer() {
        return OverrideMethod.invokeL("android.graphics.HardwareBufferRenderer#nGetFinalizer()J", true, null);
    }

    private static void invokeRenderCallback(Consumer<RenderResult> callback, int fd, int status) {
        callback.accept(new RenderResult(SyncFence.adopt(fd), status));
    }

    private static void validateAlpha(float alpha, String argumentName) {
        if (!(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            throw new IllegalArgumentException(argumentName + " must be a valid alpha, " + alpha + " is not in the range of 0.0f to 1.0f");
        }
    }

    private static void validateFinite(float f, String argumentName) {
        if (!Float.isFinite(f)) {
            throw new IllegalArgumentException(argumentName + " must be finite, given=" + f);
        }
    }

    private static void validatePositive(float f, String argumentName) {
        if (!Float.isFinite(f) || !(f >= 0.0f)) {
            throw new IllegalArgumentException(argumentName + " must be a finite positive, given=" + f);
        }
    }

    private static class HardwareBufferRendererHolder {
        public static final NativeAllocationRegistry REGISTRY = NativeAllocationRegistry.createMalloced(HardwareBufferRenderer.class.getClassLoader(), HardwareBufferRenderer.nGetFinalizer());

        private HardwareBufferRendererHolder() {
        }
    }

    public class RenderRequest {
        private ColorSpace mColorSpace = DEFAULT_COLORSPACE;
        private int mTransform = 0;

        private RenderRequest() {
        }

        public void draw(Executor executor, Consumer<RenderResult> renderCallback) {
            int renderHeight;
            int renderWidth;
            Consumer<RenderResult> wrapped = consumable -> executor.execute(() -> renderCallback.accept((RenderResult)consumable));
            if (!HardwareBufferRenderer.this.isClosed()) {
                if (this.mTransform == 4 || this.mTransform == 7) {
                    renderWidth = HardwareBufferRenderer.this.mHardwareBuffer.getHeight();
                    renderHeight = HardwareBufferRenderer.this.mHardwareBuffer.getWidth();
                } else {
                    renderWidth = HardwareBufferRenderer.this.mHardwareBuffer.getWidth();
                    renderHeight = HardwareBufferRenderer.this.mHardwareBuffer.getHeight();
                }
            } else {
                throw new IllegalStateException("Attempt to draw with a HardwareBufferRenderer instance that has already been closed");
            }
            HardwareBufferRenderer.nRender(HardwareBufferRenderer.this.mProxy, this.mTransform, renderWidth, renderHeight, this.mColorSpace.getNativeInstance(), wrapped);
        }

        private void reset() {
            this.mColorSpace = DEFAULT_COLORSPACE;
            this.mTransform = 0;
        }

        public RenderRequest setColorSpace(ColorSpace colorSpace) {
            this.mColorSpace = colorSpace == null ? DEFAULT_COLORSPACE : colorSpace;
            return this;
        }

        public RenderRequest setBufferTransform(int bufferTransform) {
            boolean validTransform;
            boolean bl = validTransform = bufferTransform == 0 || bufferTransform == 4 || bufferTransform == 3 || bufferTransform == 7;
            if (!validTransform) {
                throw new IllegalArgumentException("Invalid transform provided, must be one ofthe SurfaceControl.BufferTransform values");
            }
            this.mTransform = bufferTransform;
            return this;
        }
    }

    public static class RenderResult {
        public static final int SUCCESS = 0;
        public static final int ERROR_UNKNOWN = 1;
        private final SyncFence mFence;
        private final int mResultStatus;

        private RenderResult(SyncFence fence, int resultStatus) {
            this.mFence = fence;
            this.mResultStatus = resultStatus;
        }

        public SyncFence getFence() {
            return this.mFence;
        }

        public int getStatus() {
            return this.mResultStatus;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RenderResultStatus {
        }
    }
}

