/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.Compatibility;
import android.graphics.ImageDecoder_Delegate;
import android.graphics.PostProcessor;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Trace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Size;
import android.util.TypedValue;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;

public final class ImageDecoder
implements AutoCloseable {
    @Deprecated
    public static final int ERROR_SOURCE_EXCEPTION = 1;
    @Deprecated
    public static final int ERROR_SOURCE_INCOMPLETE = 2;
    @Deprecated
    public static final int ERROR_SOURCE_ERROR = 3;
    private long mNativePtr;
    private final int mWidth;
    private final int mHeight;
    private final boolean mAnimated;
    private final boolean mIsNinePatch;
    private int mDesiredWidth;
    private int mDesiredHeight;
    private int mAllocator = 0;
    private boolean mUnpremultipliedRequired = false;
    private boolean mMutable = false;
    private boolean mConserveMemory = false;
    private boolean mDecodeAsAlphaMask = false;
    private ColorSpace mDesiredColorSpace = null;
    private Rect mCropRect;
    private Rect mOutPaddingRect;
    private Source mSource;
    private PostProcessor mPostProcessor;
    private OnPartialImageListener mOnPartialImageListener;
    private InputStream mInputStream;
    private boolean mOwnsInputStream;
    private byte[] mTempStorage;
    private AssetFileDescriptor mAssetFd;
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final int ALLOCATOR_DEFAULT = 0;
    public static final int ALLOCATOR_SOFTWARE = 1;
    public static final int ALLOCATOR_SHARED_MEMORY = 2;
    public static final int ALLOCATOR_HARDWARE = 3;
    public static final int MEMORY_POLICY_LOW_RAM = 0;
    public static final int MEMORY_POLICY_DEFAULT = 1;
    private static boolean sIsHevcDecoderSupported = false;
    private static boolean sIsHevcDecoderSupportedInitialized = false;
    private static final Object sIsHevcDecoderSupportedLock = new Object();
    private static boolean sIsP010SupportedForAV1 = false;
    private static boolean sIsP010SupportedForHEVC = false;
    private static boolean sIsP010SupportedFlagsInitialized = false;
    private static final Object sIsP010SupportedLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromFile(File file, boolean preferAnimation, Source source) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        FileDescriptor fd = stream.getFD();
        try {
            Os.lseek(fd, 0L, OsConstants.SEEK_CUR);
        }
        catch (ErrnoException e) {
            return ImageDecoder.createFromStream(stream, true, preferAnimation, source);
        }
        ImageDecoder decoder = null;
        try {
            decoder = ImageDecoder.nCreate(fd, -1L, preferAnimation, source);
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(stream);
            } else {
                decoder.mInputStream = stream;
                decoder.mOwnsInputStream = true;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromStream(InputStream is, boolean closeInputStream, boolean preferAnimation, Source source) throws IOException {
        byte[] storage = new byte[16384];
        ImageDecoder decoder = null;
        try {
            decoder = ImageDecoder.nCreate(is, storage, preferAnimation, source);
        }
        finally {
            if (decoder == null) {
                if (closeInputStream) {
                    IoUtils.closeQuietly(is);
                }
            } else {
                decoder.mInputStream = is;
                decoder.mOwnsInputStream = closeInputStream;
                decoder.mTempStorage = storage;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromAssetFileDescriptor(AssetFileDescriptor assetFd, boolean preferAnimation, Source source) throws IOException {
        if (assetFd == null) {
            throw new FileNotFoundException();
        }
        FileDescriptor fd = assetFd.getFileDescriptor();
        long offset = assetFd.getStartOffset();
        ImageDecoder decoder = null;
        try {
            try {
                Os.lseek(fd, offset, OsConstants.SEEK_SET);
                decoder = ImageDecoder.nCreate(fd, assetFd.getDeclaredLength(), preferAnimation, source);
            }
            catch (ErrnoException e) {
                decoder = ImageDecoder.createFromStream(new FileInputStream(fd), true, preferAnimation, source);
            }
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(assetFd);
            } else {
                decoder.mAssetFd = assetFd;
            }
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageDecoder createFromAsset(AssetManager.AssetInputStream ais, boolean preferAnimation, Source source) throws IOException {
        ImageDecoder decoder = null;
        try {
            long asset = ais.getNativeAsset();
            decoder = ImageDecoder.nCreate(asset, preferAnimation, source);
        }
        finally {
            if (decoder == null) {
                IoUtils.closeQuietly(ais);
            } else {
                decoder.mInputStream = ais;
                decoder.mOwnsInputStream = true;
            }
        }
        return decoder;
    }

    private ImageDecoder(long nativePtr, int width, int height, boolean animated, boolean isNinePatch) {
        this.mNativePtr = nativePtr;
        this.mWidth = width;
        this.mHeight = height;
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        this.mAnimated = animated;
        this.mIsNinePatch = isNinePatch;
        this.mCloseGuard.open("close");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mInputStream = null;
            this.mAssetFd = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static boolean isMimeTypeSupported(String mimeType) {
        Objects.requireNonNull(mimeType);
        switch (mimeType.toLowerCase(Locale.US)) {
            case "image/png": 
            case "image/jpeg": 
            case "image/webp": 
            case "image/gif": 
            case "image/bmp": 
            case "image/x-ico": 
            case "image/vnd.wap.wbmp": 
            case "image/x-sony-arw": 
            case "image/x-canon-cr2": 
            case "image/x-adobe-dng": 
            case "image/x-nikon-nef": 
            case "image/x-nikon-nrw": 
            case "image/x-olympus-orf": 
            case "image/x-fuji-raf": 
            case "image/x-panasonic-rw2": 
            case "image/x-pentax-pef": 
            case "image/x-samsung-srw": {
                return true;
            }
            case "image/heif": 
            case "image/heic": {
                return ImageDecoder.isHevcDecoderSupported();
            }
            case "image/avif": {
                return ImageDecoder.isP010SupportedForAV1();
            }
        }
        return false;
    }

    public static Source createSource(Resources res, int resId) {
        return new ResourceSource(res, resId);
    }

    public static Source createSource(ContentResolver cr, Uri uri) {
        return new ContentResolverSource(cr, uri, null);
    }

    public static Source createSource(ContentResolver cr, Uri uri, Resources res) {
        return new ContentResolverSource(cr, uri, res);
    }

    public static Source createSource(AssetManager assets, String fileName) {
        return new AssetSource(assets, fileName);
    }

    public static Source createSource(byte[] data, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (data == null) {
            throw new NullPointerException("null byte[] in createSource!");
        }
        if (offset < 0 || length < 0 || offset >= data.length || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException("invalid offset/length!");
        }
        return new ByteArraySource(data, offset, length);
    }

    public static Source createSource(byte[] data) {
        return ImageDecoder.createSource(data, 0, data.length);
    }

    public static Source createSource(ByteBuffer buffer) {
        return new ByteBufferSource(buffer);
    }

    public static Source createSource(Resources res, InputStream is) {
        return new InputStreamSource(res, is, Bitmap.getDefaultDensity());
    }

    public static Source createSource(Resources res, InputStream is, int density) {
        return new InputStreamSource(res, is, density);
    }

    public static Source createSource(File file) {
        return new FileSource(file);
    }

    public static Source createSource(Callable<AssetFileDescriptor> callable) {
        return new CallableSource(callable);
    }

    private Size getSampledSize(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("sampleSize must be positive! provided " + sampleSize);
        }
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("ImageDecoder is closed!");
        }
        return ImageDecoder.nGetSampledSize(this.mNativePtr, sampleSize);
    }

    @Deprecated
    public ImageDecoder setResize(int width, int height) {
        this.setTargetSize(width, height);
        return this;
    }

    public void setTargetSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Dimensions must be positive! provided (" + width + ", " + height + ")");
        }
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
    }

    @Deprecated
    public ImageDecoder setResize(int sampleSize) {
        this.setTargetSampleSize(sampleSize);
        return this;
    }

    private int getTargetDimension(int original, int sampleSize, int computed) {
        if (sampleSize >= original) {
            return 1;
        }
        int target = original / sampleSize;
        if (computed == target) {
            return computed;
        }
        int reverse = computed * sampleSize;
        if (Math.abs(reverse - original) < sampleSize) {
            return computed;
        }
        return target;
    }

    public void setTargetSampleSize(int sampleSize) {
        Size size = this.getSampledSize(sampleSize);
        int targetWidth = this.getTargetDimension(this.mWidth, sampleSize, size.getWidth());
        int targetHeight = this.getTargetDimension(this.mHeight, sampleSize, size.getHeight());
        this.setTargetSize(targetWidth, targetHeight);
    }

    private boolean requestedResize() {
        return this.mWidth != this.mDesiredWidth || this.mHeight != this.mDesiredHeight;
    }

    public void setAllocator(int allocator) {
        if (allocator < 0 || allocator > 3) {
            throw new IllegalArgumentException("invalid allocator " + allocator);
        }
        this.mAllocator = allocator;
    }

    public int getAllocator() {
        return this.mAllocator;
    }

    public void setUnpremultipliedRequired(boolean unpremultipliedRequired) {
        this.mUnpremultipliedRequired = unpremultipliedRequired;
    }

    @Deprecated
    public ImageDecoder setRequireUnpremultiplied(boolean unpremultipliedRequired) {
        this.setUnpremultipliedRequired(unpremultipliedRequired);
        return this;
    }

    public boolean isUnpremultipliedRequired() {
        return this.mUnpremultipliedRequired;
    }

    @Deprecated
    public boolean getRequireUnpremultiplied() {
        return this.isUnpremultipliedRequired();
    }

    public void setPostProcessor(PostProcessor postProcessor) {
        this.mPostProcessor = postProcessor;
    }

    public PostProcessor getPostProcessor() {
        return this.mPostProcessor;
    }

    public void setOnPartialImageListener(OnPartialImageListener listener) {
        this.mOnPartialImageListener = listener;
    }

    public OnPartialImageListener getOnPartialImageListener() {
        return this.mOnPartialImageListener;
    }

    public void setCrop(Rect subset) {
        this.mCropRect = subset;
    }

    public Rect getCrop() {
        return this.mCropRect;
    }

    public void setOutPaddingRect(Rect outPadding) {
        this.mOutPaddingRect = outPadding;
    }

    public void setMutableRequired(boolean mutable) {
        this.mMutable = mutable;
    }

    @Deprecated
    public ImageDecoder setMutable(boolean mutable) {
        this.setMutableRequired(mutable);
        return this;
    }

    public boolean isMutableRequired() {
        return this.mMutable;
    }

    @Deprecated
    public boolean getMutable() {
        return this.isMutableRequired();
    }

    public void setMemorySizePolicy(int policy) {
        this.mConserveMemory = policy == 0;
    }

    public int getMemorySizePolicy() {
        return this.mConserveMemory ? 0 : 1;
    }

    @Deprecated
    public void setConserveMemory(boolean conserveMemory) {
        this.mConserveMemory = conserveMemory;
    }

    @Deprecated
    public boolean getConserveMemory() {
        return this.mConserveMemory;
    }

    public void setDecodeAsAlphaMaskEnabled(boolean enabled) {
        this.mDecodeAsAlphaMask = enabled;
    }

    @Deprecated
    public ImageDecoder setDecodeAsAlphaMask(boolean enabled) {
        this.setDecodeAsAlphaMaskEnabled(enabled);
        return this;
    }

    @Deprecated
    public ImageDecoder setAsAlphaMask(boolean asAlphaMask) {
        this.setDecodeAsAlphaMask(asAlphaMask);
        return this;
    }

    public boolean isDecodeAsAlphaMaskEnabled() {
        return this.mDecodeAsAlphaMask;
    }

    @Deprecated
    public boolean getDecodeAsAlphaMask() {
        return this.mDecodeAsAlphaMask;
    }

    @Deprecated
    public boolean getAsAlphaMask() {
        return this.getDecodeAsAlphaMask();
    }

    public void setTargetColorSpace(ColorSpace colorSpace) {
        this.mDesiredColorSpace = colorSpace;
    }

    @Override
    public void close() {
        this.mCloseGuard.close();
        if (!this.mClosed.compareAndSet(false, true)) {
            return;
        }
        ImageDecoder.nClose(this.mNativePtr);
        this.mNativePtr = 0L;
        if (this.mOwnsInputStream) {
            IoUtils.closeQuietly(this.mInputStream);
        }
        IoUtils.closeQuietly(this.mAssetFd);
        this.mInputStream = null;
        this.mAssetFd = null;
        this.mTempStorage = null;
    }

    private void checkState(boolean animated) {
        if (this.mNativePtr == 0L) {
            throw new IllegalStateException("Cannot use closed ImageDecoder!");
        }
        ImageDecoder.checkSubset(this.mDesiredWidth, this.mDesiredHeight, this.mCropRect);
        if (!animated && this.mAllocator == 3) {
            if (this.mMutable) {
                throw new IllegalStateException("Cannot make mutable HARDWARE Bitmap!");
            }
            if (this.mDecodeAsAlphaMask) {
                throw new IllegalStateException("Cannot make HARDWARE Alpha mask Bitmap!");
            }
        }
        if (this.mPostProcessor != null && this.mUnpremultipliedRequired) {
            throw new IllegalStateException("Cannot draw to unpremultiplied pixels!");
        }
    }

    private static void checkSubset(int width, int height, Rect r) {
        if (r == null) {
            return;
        }
        if (r.width() <= 0 || r.height() <= 0) {
            throw new IllegalStateException("Subset " + r + " is empty/unsorted");
        }
        if (r.left < 0 || r.top < 0 || r.right > width || r.bottom > height) {
            throw new IllegalStateException("Subset " + r + " not contained by scaled image bounds: (" + width + " x " + height + ")");
        }
    }

    private boolean checkForExtended() {
        if (this.mDesiredColorSpace == null) {
            return false;
        }
        return this.mDesiredColorSpace == ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB) || this.mDesiredColorSpace == ColorSpace.get(ColorSpace.Named.LINEAR_EXTENDED_SRGB);
    }

    private long getColorSpacePtr() {
        if (this.mDesiredColorSpace == null) {
            return 0L;
        }
        return this.mDesiredColorSpace.getNativeInstance();
    }

    private Bitmap decodeBitmapInternal() throws IOException {
        this.checkState(false);
        return ImageDecoder.nDecodeBitmap(this.mNativePtr, this, this.mPostProcessor != null, this.mDesiredWidth, this.mDesiredHeight, this.mCropRect, this.mMutable, this.mAllocator, this.mUnpremultipliedRequired, this.mConserveMemory, this.mDecodeAsAlphaMask, this.getColorSpacePtr(), this.checkForExtended());
    }

    private void callHeaderDecoded(OnHeaderDecodedListener listener, Source src) {
        if (listener != null) {
            ImageInfo info = new ImageInfo(new Size(this.mWidth, this.mHeight), this.mAnimated, this.getMimeType(), this.getColorSpace());
            listener.onHeaderDecoded(this, info, src);
        }
    }

    public static ImageInfo decodeHeader(Source src) throws IOException {
        Trace.traceBegin(8192L, "ImageDecoder#decodeHeader");
        try {
            ImageDecoder decoder = src.createImageDecoder(true);
            try {
                ImageInfo imageInfo = new ImageInfo(new Size(decoder.mWidth, decoder.mHeight), decoder.mAnimated, decoder.getMimeType(), decoder.getColorSpace());
                if (decoder != null) {
                    decoder.close();
                }
                return imageInfo;
            }
            catch (Throwable throwable) {
                if (decoder != null) {
                    try {
                        decoder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    public static Drawable decodeDrawable(Source src, OnHeaderDecodedListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null! Use decodeDrawable(Source) to not have a listener");
        }
        return ImageDecoder.decodeDrawableImpl(src, listener);
    }

    /*
     * Exception decompiling
     */
    private static Drawable decodeDrawableImpl(Source src, OnHeaderDecodedListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Drawable decodeDrawable(Source src) throws IOException {
        return ImageDecoder.decodeDrawableImpl(src, null);
    }

    public static Bitmap decodeBitmap(Source src, OnHeaderDecodedListener listener) throws IOException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null! Use decodeBitmap(Source) to not have a listener");
        }
        return ImageDecoder.decodeBitmapImpl(src, listener);
    }

    /*
     * Exception decompiling
     */
    static Bitmap decodeBitmapImpl_Original(Source src, OnHeaderDecodedListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @LayoutlibDelegate
    private static Bitmap decodeBitmapImpl(Source source, OnHeaderDecodedListener onHeaderDecodedListener) throws IOException {
        return ImageDecoder_Delegate.decodeBitmapImpl(source, onHeaderDecodedListener);
    }

    private static AutoCloseable traceDecoderSource(ImageDecoder decoder) {
        final boolean resourceTracingEnabled = Trace.isTagEnabled(8192L);
        if (resourceTracingEnabled) {
            Trace.traceBegin(8192L, ImageDecoder.describeDecoderForTrace(decoder));
        }
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                if (resourceTracingEnabled) {
                    Trace.traceEnd(8192L);
                }
            }
        };
    }

    private int computeDensity(Source src) {
        if (this.requestedResize()) {
            return 0;
        }
        int srcDensity = src.getDensity();
        if (srcDensity == 0) {
            return srcDensity;
        }
        if (this.mIsNinePatch && this.mPostProcessor == null) {
            return srcDensity;
        }
        Resources res = src.getResources();
        if (res != null && res.getDisplayMetrics().noncompatDensityDpi == srcDensity) {
            return srcDensity;
        }
        int dstDensity = src.computeDstDensity();
        if (srcDensity == dstDensity) {
            return srcDensity;
        }
        if (srcDensity < dstDensity && Compatibility.getTargetSdkVersion() >= 28) {
            return srcDensity;
        }
        float scale = (float)dstDensity / (float)srcDensity;
        int scaledWidth = Math.max((int)((float)this.mWidth * scale + 0.5f), 1);
        int scaledHeight = Math.max((int)((float)this.mHeight * scale + 0.5f), 1);
        this.setTargetSize(scaledWidth, scaledHeight);
        return dstDensity;
    }

    private String getMimeType() {
        return ImageDecoder.nGetMimeType(this.mNativePtr);
    }

    private ColorSpace getColorSpace() {
        return ImageDecoder.nGetColorSpace(this.mNativePtr);
    }

    public static Bitmap decodeBitmap(Source src) throws IOException {
        return ImageDecoder.decodeBitmapImpl(src, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isHevcDecoderSupported() {
        Object object = sIsHevcDecoderSupportedLock;
        synchronized (object) {
            if (sIsHevcDecoderSupportedInitialized) {
                return sIsHevcDecoderSupported;
            }
            MediaFormat format = new MediaFormat();
            format.setString("mime", "video/hevc");
            MediaCodecList mcl = new MediaCodecList(0);
            sIsHevcDecoderSupported = mcl.findDecoderForFormat(format) != null;
            sIsHevcDecoderSupportedInitialized = true;
            return sIsHevcDecoderSupported;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isP010SupportedForAV1() {
        Object object = sIsP010SupportedLock;
        synchronized (object) {
            if (sIsP010SupportedFlagsInitialized) {
                return sIsP010SupportedForAV1;
            }
            ImageDecoder.checkP010SupportforAV1HEVC();
            return sIsP010SupportedForAV1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isP010SupportedForHEVC() {
        Object object = sIsP010SupportedLock;
        synchronized (object) {
            if (sIsP010SupportedFlagsInitialized) {
                return sIsP010SupportedForHEVC;
            }
            ImageDecoder.checkP010SupportforAV1HEVC();
            return sIsP010SupportedForHEVC;
        }
    }

    private static void checkP010SupportforAV1HEVC() {
        MediaCodecList codecList = new MediaCodecList(0);
        for (MediaCodecInfo mediaCodecInfo : codecList.getCodecInfos()) {
            if (mediaCodecInfo.isEncoder()) continue;
            for (String mediaType : mediaCodecInfo.getSupportedTypes()) {
                if (!mediaType.equalsIgnoreCase("video/av01") && !mediaType.equalsIgnoreCase("video/hevc")) continue;
                MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(mediaType);
                for (int i = 0; i < codecCapabilities.colorFormats.length; ++i) {
                    if (codecCapabilities.colorFormats[i] != 54) continue;
                    if (mediaType.equalsIgnoreCase("video/av01")) {
                        sIsP010SupportedForAV1 = true;
                        continue;
                    }
                    sIsP010SupportedForHEVC = true;
                }
            }
        }
        sIsP010SupportedFlagsInitialized = true;
    }

    private int postProcessAndRelease(Canvas canvas) {
        try {
            int n = this.mPostProcessor.onPostProcess(canvas);
            return n;
        }
        finally {
            canvas.release();
        }
    }

    private void onPartialImage(int error, Throwable cause) throws DecodeException {
        DecodeException exception = new DecodeException(error, cause, this.mSource);
        if (this.mOnPartialImageListener == null || !this.mOnPartialImageListener.onPartialImage(exception)) {
            throw exception;
        }
    }

    private static String describeDecoderForTrace(ImageDecoder decoder) {
        StringBuilder builder = new StringBuilder();
        builder.append("ID#w=");
        builder.append(decoder.mWidth);
        builder.append(";h=");
        builder.append(decoder.mHeight);
        if (decoder.mDesiredWidth != decoder.mWidth || decoder.mDesiredHeight != decoder.mHeight) {
            builder.append(";dw=");
            builder.append(decoder.mDesiredWidth);
            builder.append(";dh=");
            builder.append(decoder.mDesiredHeight);
        }
        builder.append(";src=");
        builder.append(decoder.mSource);
        return builder.toString();
    }

    private static native ImageDecoder nCreate(long var0, boolean var2, Source var3) throws IOException;

    private static native ImageDecoder nCreate(ByteBuffer var0, int var1, int var2, boolean var3, Source var4) throws IOException;

    private static native ImageDecoder nCreate(byte[] var0, int var1, int var2, boolean var3, Source var4) throws IOException;

    private static native ImageDecoder nCreate(InputStream var0, byte[] var1, boolean var2, Source var3) throws IOException;

    private static native ImageDecoder nCreate(FileDescriptor var0, long var1, boolean var3, Source var4) throws IOException;

    private static native Bitmap nDecodeBitmap(long var0, ImageDecoder var2, boolean var3, int var4, int var5, Rect var6, boolean var7, int var8, boolean var9, boolean var10, boolean var11, long var12, boolean var14) throws IOException;

    private static native Size nGetSampledSize(long var0, int var2);

    private static native void nGetPadding(long var0, Rect var2);

    private static native void nClose(long var0);

    private static native String nGetMimeType(long var0);

    private static native ColorSpace nGetColorSpace(long var0);

    public static abstract class Source {
        private Source() {
        }

        Resources getResources() {
            return null;
        }

        int getDensity() {
            return 0;
        }

        int computeDstDensity() {
            Resources res = this.getResources();
            if (res == null) {
                return Bitmap.getDefaultDensity();
            }
            return res.getDisplayMetrics().densityDpi;
        }

        abstract ImageDecoder createImageDecoder(boolean var1) throws IOException;
    }

    public static class ResourceSource
    extends Source {
        final Resources mResources;
        final int mResId;
        int mResDensity;
        private Object mLock = new Object();

        ResourceSource(Resources res, int resId) {
            this.mResources = res;
            this.mResId = resId;
            this.mResDensity = 0;
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDensity() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mResDensity;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            TypedValue value = new TypedValue();
            InputStream is = this.mResources.openRawResource(this.mResId, value);
            Object object = this.mLock;
            synchronized (object) {
                if (value.density == 0) {
                    this.mResDensity = 160;
                } else if (value.density != 65535) {
                    this.mResDensity = value.density;
                }
            }
            return ImageDecoder.createFromAsset((AssetManager.AssetInputStream)is, preferAnimation, this);
        }

        public String toString() {
            try {
                return "Resource{name=" + this.mResources.getResourceName(this.mResId) + "}";
            }
            catch (Resources.NotFoundException notFoundException) {
                return "Resource{id=" + this.mResId + "}";
            }
        }
    }

    private static class ContentResolverSource
    extends Source {
        private final ContentResolver mResolver;
        private final Uri mUri;
        private final Resources mResources;

        ContentResolverSource(ContentResolver resolver, Uri uri, Resources res) {
            this.mResolver = resolver;
            this.mUri = uri;
            this.mResources = res;
        }

        @Override
        Resources getResources() {
            return this.mResources;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            AssetFileDescriptor assetFd = null;
            try {
                assetFd = "content".equals(this.mUri.getScheme()) ? this.mResolver.openTypedAssetFileDescriptor(this.mUri, "image/*", null) : this.mResolver.openAssetFileDescriptor(this.mUri, "r");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (assetFd == null) {
                InputStream is = this.mResolver.openInputStream(this.mUri);
                if (is == null) {
                    throw new FileNotFoundException(this.mUri.toString());
                }
                return ImageDecoder.createFromStream(is, true, preferAnimation, this);
            }
            return ImageDecoder.createFromAssetFileDescriptor(assetFd, preferAnimation, this);
        }

        public String toString() {
            String uri = this.mUri.toString();
            if (uri.length() > 90) {
                uri = uri.substring(0, 80) + ".." + uri.substring(uri.length() - 10);
            }
            return "ContentResolverSource{uri=" + uri + "}";
        }
    }

    private static class AssetSource
    extends Source {
        private final AssetManager mAssets;
        private final String mFileName;

        AssetSource(AssetManager assets, String fileName) {
            this.mAssets = assets;
            this.mFileName = fileName;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            InputStream is = this.mAssets.open(this.mFileName);
            return ImageDecoder.createFromAsset((AssetManager.AssetInputStream)is, preferAnimation, this);
        }

        public String toString() {
            return "AssetSource{file=" + this.mFileName + "}";
        }
    }

    private static class ByteArraySource
    extends Source {
        private final byte[] mData;
        private final int mOffset;
        private final int mLength;

        ByteArraySource(byte[] data, int offset, int length) {
            this.mData = data;
            this.mOffset = offset;
            this.mLength = length;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            return ImageDecoder.nCreate(this.mData, this.mOffset, this.mLength, preferAnimation, (Source)this);
        }

        public String toString() {
            return "ByteArraySource{len=" + this.mLength + "}";
        }
    }

    private static class ByteBufferSource
    extends Source {
        private final ByteBuffer mBuffer;
        private final int mLength;

        ByteBufferSource(ByteBuffer buffer) {
            this.mBuffer = buffer;
            this.mLength = this.mBuffer.limit() - this.mBuffer.position();
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            if (!this.mBuffer.isDirect() && this.mBuffer.hasArray()) {
                int offset = this.mBuffer.arrayOffset() + this.mBuffer.position();
                int length = this.mBuffer.limit() - this.mBuffer.position();
                return ImageDecoder.nCreate(this.mBuffer.array(), offset, length, preferAnimation, (Source)this);
            }
            ByteBuffer buffer = this.mBuffer.slice();
            return ImageDecoder.nCreate(buffer, buffer.position(), buffer.limit(), preferAnimation, (Source)this);
        }

        public String toString() {
            return "ByteBufferSource{len=" + this.mLength + "}";
        }
    }

    public static class InputStreamSource
    extends Source {
        final Resources mResources;
        public InputStream mInputStream;
        final int mInputDensity;

        InputStreamSource(Resources res, InputStream is, int inputDensity) {
            if (is == null) {
                throw new IllegalArgumentException("The InputStream cannot be null");
            }
            this.mResources = res;
            this.mInputStream = is;
            this.mInputDensity = inputDensity;
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mInputDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            InputStreamSource inputStreamSource = this;
            synchronized (inputStreamSource) {
                if (this.mInputStream == null) {
                    throw new IOException("Cannot reuse InputStreamSource");
                }
                InputStream is = this.mInputStream;
                this.mInputStream = null;
                return ImageDecoder.createFromStream(is, false, preferAnimation, this);
            }
        }

        public String toString() {
            return "InputStream{s=" + this.mInputStream + "}";
        }
    }

    private static class FileSource
    extends Source {
        private final File mFile;

        FileSource(File file) {
            this.mFile = file;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            return ImageDecoder.createFromFile(this.mFile, preferAnimation, this);
        }

        public String toString() {
            return "FileSource{file=" + this.mFile + "}";
        }
    }

    private static class CallableSource
    extends Source {
        private final Callable<AssetFileDescriptor> mCallable;

        CallableSource(Callable<AssetFileDescriptor> callable) {
            this.mCallable = callable;
        }

        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            AssetFileDescriptor assetFd = null;
            try {
                assetFd = this.mCallable.call();
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
            return ImageDecoder.createFromAssetFileDescriptor(assetFd, preferAnimation, this);
        }

        public String toString() {
            return "CallableSource{obj=" + this.mCallable.toString() + "}";
        }
    }

    public static interface OnPartialImageListener {
        public boolean onPartialImage(DecodeException var1);
    }

    public static class ImageInfo {
        private final Size mSize;
        private final boolean mIsAnimated;
        private final String mMimeType;
        private final ColorSpace mColorSpace;

        private ImageInfo(Size size, boolean isAnimated, String mimeType, ColorSpace colorSpace) {
            this.mSize = size;
            this.mIsAnimated = isAnimated;
            this.mMimeType = mimeType;
            this.mColorSpace = colorSpace;
        }

        public Size getSize() {
            return this.mSize;
        }

        public String getMimeType() {
            return this.mMimeType;
        }

        public boolean isAnimated() {
            return this.mIsAnimated;
        }

        public ColorSpace getColorSpace() {
            return this.mColorSpace;
        }
    }

    public static interface OnHeaderDecodedListener {
        public void onHeaderDecoded(ImageDecoder var1, ImageInfo var2, Source var3);
    }

    private static class ImageDecoderSourceTrace
    implements AutoCloseable {
        private final boolean mResourceTracingEnabled = Trace.isTagEnabled(8192L);

        ImageDecoderSourceTrace(ImageDecoder decoder) {
            if (this.mResourceTracingEnabled) {
                Trace.traceBegin(8192L, ImageDecoder.describeDecoderForTrace(decoder));
            }
        }

        @Override
        public void close() {
            if (this.mResourceTracingEnabled) {
                Trace.traceEnd(8192L);
            }
        }
    }

    public static class DecodeException
    extends IOException {
        public static final int SOURCE_EXCEPTION = 1;
        public static final int SOURCE_INCOMPLETE = 2;
        public static final int SOURCE_MALFORMED_DATA = 3;
        final int mError;
        final Source mSource;

        DecodeException(int error, Throwable cause, Source source) {
            super(DecodeException.errorMessage(error, cause), cause);
            this.mError = error;
            this.mSource = source;
        }

        DecodeException(int error, String msg, Throwable cause, Source source) {
            super(msg + DecodeException.errorMessage(error, cause), cause);
            this.mError = error;
            this.mSource = source;
        }

        public int getError() {
            return this.mError;
        }

        public Source getSource() {
            return this.mSource;
        }

        private static String errorMessage(int error, Throwable cause) {
            switch (error) {
                case 1: {
                    return "Exception in input: " + cause;
                }
                case 2: {
                    return "Input was incomplete.";
                }
                case 3: {
                    return "Input contained an error.";
                }
            }
            return "";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Error {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MemoryPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Allocator {
    }

    @Deprecated
    public static class IncompleteException
    extends IOException {
    }

    public static class AssetInputStreamSource
    extends Source {
        private AssetManager.AssetInputStream mAssetInputStream;
        private final Resources mResources;
        private final int mDensity;

        public AssetInputStreamSource(AssetManager.AssetInputStream ais, Resources res, TypedValue value) {
            this.mAssetInputStream = ais;
            this.mResources = res;
            this.mDensity = value.density == 0 ? 160 : (value.density != 65535 ? value.density : 0);
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mDensity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImageDecoder createImageDecoder(boolean preferAnimation) throws IOException {
            AssetInputStreamSource assetInputStreamSource = this;
            synchronized (assetInputStreamSource) {
                if (this.mAssetInputStream == null) {
                    throw new IOException("Cannot reuse AssetInputStreamSource");
                }
                AssetManager.AssetInputStream ais = this.mAssetInputStream;
                this.mAssetInputStream = null;
                return ImageDecoder.createFromAsset(ais, preferAnimation, this);
            }
        }

        public String toString() {
            return "AssetInputStream{s=" + this.mAssetInputStream + "}";
        }
    }
}

