/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.MeshSpecification;
import android.graphics.RectF;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import libcore.util.NativeAllocationRegistry;

public class Mesh {
    private long mNativeMeshWrapper;
    private boolean mIsIndexed;
    public static final int TRIANGLES = 0;
    public static final int TRIANGLE_STRIP = 1;

    public Mesh(MeshSpecification meshSpec, @Mode int mode, Buffer vertexBuffer, int vertexCount, RectF bounds) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Invalid value passed in for mode parameter");
        }
        long nativeMesh = Mesh.nativeMake(meshSpec.mNativeMeshSpec, mode, vertexBuffer, vertexBuffer.isDirect(), vertexCount, vertexBuffer.position(), bounds.left, bounds.top, bounds.right, bounds.bottom);
        if (nativeMesh == 0L) {
            throw new IllegalArgumentException("Mesh construction failed.");
        }
        this.meshSetup(nativeMesh, false);
    }

    public Mesh(MeshSpecification meshSpec, @Mode int mode, Buffer vertexBuffer, int vertexCount, ShortBuffer indexBuffer, RectF bounds) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Invalid value passed in for mode parameter");
        }
        long nativeMesh = Mesh.nativeMakeIndexed(meshSpec.mNativeMeshSpec, mode, vertexBuffer, vertexBuffer.isDirect(), vertexCount, vertexBuffer.position(), indexBuffer, indexBuffer.isDirect(), indexBuffer.capacity(), indexBuffer.position(), bounds.left, bounds.top, bounds.right, bounds.bottom);
        if (nativeMesh == 0L) {
            throw new IllegalArgumentException("Mesh construction failed.");
        }
        this.meshSetup(nativeMesh, true);
    }

    public void setColorUniform(String uniformName, int color2) {
        this.setUniform(uniformName, Color.valueOf(color2).getComponents(), true);
    }

    public void setColorUniform(String uniformName, long color2) {
        Color exSRGB = Color.valueOf(color2).convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setColorUniform(String uniformName, Color color2) {
        if (color2 == null) {
            throw new NullPointerException("The color parameter must not be null");
        }
        Color exSRGB = color2.convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setFloatUniform(String uniformName, float value) {
        this.setFloatUniform(uniformName, value, 0.0f, 0.0f, 0.0f, 1);
    }

    public void setFloatUniform(String uniformName, float value1, float value2) {
        this.setFloatUniform(uniformName, value1, value2, 0.0f, 0.0f, 2);
    }

    public void setFloatUniform(String uniformName, float value1, float value2, float value3) {
        this.setFloatUniform(uniformName, value1, value2, value3, 0.0f, 3);
    }

    public void setFloatUniform(String uniformName, float value1, float value2, float value3, float value4) {
        this.setFloatUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setFloatUniform(String uniformName, float[] values) {
        this.setUniform(uniformName, values, false);
    }

    private void setFloatUniform(String uniformName, float value1, float value2, float value3, float value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        Mesh.nativeUpdateUniforms(this.mNativeMeshWrapper, uniformName, value1, value2, value3, value4, count);
    }

    private void setUniform(String uniformName, float[] values, boolean isColor) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        Mesh.nativeUpdateUniforms(this.mNativeMeshWrapper, uniformName, values, isColor);
    }

    public void setIntUniform(String uniformName, int value) {
        this.setIntUniform(uniformName, value, 0, 0, 0, 1);
    }

    public void setIntUniform(String uniformName, int value1, int value2) {
        this.setIntUniform(uniformName, value1, value2, 0, 0, 2);
    }

    public void setIntUniform(String uniformName, int value1, int value2, int value3) {
        this.setIntUniform(uniformName, value1, value2, value3, 0, 3);
    }

    public void setIntUniform(String uniformName, int value1, int value2, int value3, int value4) {
        this.setIntUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setIntUniform(String uniformName, int[] values) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        Mesh.nativeUpdateUniforms(this.mNativeMeshWrapper, uniformName, values);
    }

    long getNativeWrapperInstance() {
        return this.mNativeMeshWrapper;
    }

    private void setIntUniform(String uniformName, int value1, int value2, int value3, int value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        Mesh.nativeUpdateUniforms(this.mNativeMeshWrapper, uniformName, value1, value2, value3, value4, count);
    }

    private void meshSetup(long nativeMeshWrapper, boolean isIndexed) {
        this.mNativeMeshWrapper = nativeMeshWrapper;
        this.mIsIndexed = isIndexed;
        MeshHolder.MESH_SPECIFICATION_REGISTRY.registerNativeAllocation(this, this.mNativeMeshWrapper);
    }

    private static long nativeGetFinalizer() {
        return OverrideMethod.invokeL("android.graphics.Mesh#nativeGetFinalizer()J", true, null);
    }

    private static long nativeMake(long l, int n, Buffer buffer, boolean bl, int n2, int n3, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeL("android.graphics.Mesh#nativeMake(JILjava/nio/Buffer;ZIIFFFF)J", true, null);
    }

    private static long nativeMakeIndexed(long l, int n, Buffer buffer, boolean bl, int n2, int n3, ShortBuffer shortBuffer, boolean bl2, int n4, int n5, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeL("android.graphics.Mesh#nativeMakeIndexed(JILjava/nio/Buffer;ZIILjava/nio/ShortBuffer;ZIIFFFF)J", true, null);
    }

    private static void nativeUpdateUniforms(long l, String string2, float f, float f2, float f3, float f4, int n) {
        OverrideMethod.invokeV("android.graphics.Mesh#nativeUpdateUniforms(JLjava/lang/String;FFFFI)V", true, null);
    }

    private static void nativeUpdateUniforms(long l, String string2, float[] fArray, boolean bl) {
        OverrideMethod.invokeV("android.graphics.Mesh#nativeUpdateUniforms(JLjava/lang/String;[FZ)V", true, null);
    }

    private static void nativeUpdateUniforms(long l, String string2, int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.graphics.Mesh#nativeUpdateUniforms(JLjava/lang/String;IIIII)V", true, null);
    }

    private static void nativeUpdateUniforms(long l, String string2, int[] nArray) {
        OverrideMethod.invokeV("android.graphics.Mesh#nativeUpdateUniforms(JLjava/lang/String;[I)V", true, null);
    }

    private static class MeshHolder {
        public static final NativeAllocationRegistry MESH_SPECIFICATION_REGISTRY = NativeAllocationRegistry.createMalloced(MeshSpecification.class.getClassLoader(), Mesh.nativeGetFinalizer());

        private MeshHolder() {
        }
    }

    private static @interface Mode {
    }
}

