/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.SuppressLint;
import android.graphics.ColorSpace;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

public class MeshSpecification {
    long mNativeMeshSpec;
    public static final int ALPHA_TYPE_UNKNOWN = 0;
    public static final int ALPHA_TYPE_OPAQUE = 1;
    public static final int ALPHA_TYPE_PREMULTIPLIED = 2;
    public static final int ALPHA_TYPE_UNPREMULTIPLIED = 3;
    public static final int TYPE_FLOAT = 0;
    public static final int TYPE_FLOAT2 = 1;
    public static final int TYPE_FLOAT3 = 2;
    public static final int TYPE_FLOAT4 = 3;
    public static final int TYPE_UBYTE4 = 4;

    public static MeshSpecification make(@SuppressLint(value={"ArrayReturn"}) Attribute[] attributes, int vertexStride, @SuppressLint(value={"ArrayReturn"}) Varying[] varyings, String vertexShader, String fragmentShader) {
        long nativeMeshSpec = MeshSpecification.nativeMake(attributes, vertexStride, varyings, vertexShader, fragmentShader);
        if (nativeMeshSpec == 0L) {
            throw new IllegalArgumentException("MeshSpecification construction failed");
        }
        return new MeshSpecification(nativeMeshSpec);
    }

    public static MeshSpecification make(@SuppressLint(value={"ArrayReturn"}) Attribute[] attributes, int vertexStride, @SuppressLint(value={"ArrayReturn"}) Varying[] varyings, String vertexShader, String fragmentShader, ColorSpace colorSpace) {
        long nativeMeshSpec = MeshSpecification.nativeMakeWithCS(attributes, vertexStride, varyings, vertexShader, fragmentShader, colorSpace.getNativeInstance());
        if (nativeMeshSpec == 0L) {
            throw new IllegalArgumentException("MeshSpecification construction failed");
        }
        return new MeshSpecification(nativeMeshSpec);
    }

    public static MeshSpecification make(@SuppressLint(value={"ArrayReturn"}) Attribute[] attributes, int vertexStride, @SuppressLint(value={"ArrayReturn"}) Varying[] varyings, String vertexShader, String fragmentShader, ColorSpace colorSpace, int alphaType) {
        long nativeMeshSpec = MeshSpecification.nativeMakeWithAlpha(attributes, vertexStride, varyings, vertexShader, fragmentShader, colorSpace.getNativeInstance(), alphaType);
        if (nativeMeshSpec == 0L) {
            throw new IllegalArgumentException("MeshSpecification construction failed");
        }
        return new MeshSpecification(nativeMeshSpec);
    }

    private MeshSpecification(long meshSpec) {
        this.mNativeMeshSpec = meshSpec;
        MeshSpecificationHolder.MESH_SPECIFICATION_REGISTRY.registerNativeAllocation(this, meshSpec);
    }

    private static long nativeGetFinalizer() {
        return OverrideMethod.invokeL("android.graphics.MeshSpecification#nativeGetFinalizer()J", true, null);
    }

    private static long nativeMake(Attribute[] attributeArray, int n, Varying[] varyingArray, String string2, String string3) {
        return OverrideMethod.invokeL("android.graphics.MeshSpecification#nativeMake([Landroid/graphics/MeshSpecification$Attribute;I[Landroid/graphics/MeshSpecification$Varying;Ljava/lang/String;Ljava/lang/String;)J", true, null);
    }

    private static long nativeMakeWithCS(Attribute[] attributeArray, int n, Varying[] varyingArray, String string2, String string3, long l) {
        return OverrideMethod.invokeL("android.graphics.MeshSpecification#nativeMakeWithCS([Landroid/graphics/MeshSpecification$Attribute;I[Landroid/graphics/MeshSpecification$Varying;Ljava/lang/String;Ljava/lang/String;J)J", true, null);
    }

    private static long nativeMakeWithAlpha(Attribute[] attributeArray, int n, Varying[] varyingArray, String string2, String string3, long l, int n2) {
        return OverrideMethod.invokeL("android.graphics.MeshSpecification#nativeMakeWithAlpha([Landroid/graphics/MeshSpecification$Attribute;I[Landroid/graphics/MeshSpecification$Varying;Ljava/lang/String;Ljava/lang/String;JI)J", true, null);
    }

    public static class Attribute {
        private final int mType;
        private final int mOffset;
        private final String mName;

        public Attribute(int type, int offset, String name) {
            this.mType = type;
            this.mOffset = offset;
            this.mName = name;
        }

        public int getType() {
            return this.mType;
        }

        public int getOffset() {
            return this.mOffset;
        }

        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "Attribute{mType=" + this.mType + ", mOffset=" + this.mOffset + ", mName='" + this.mName + '\'' + '}';
        }
    }

    public static class Varying {
        private final int mType;
        private final String mName;

        public Varying(int type, String name) {
            this.mType = type;
            this.mName = name;
        }

        public int getType() {
            return this.mType;
        }

        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "Varying{mType=" + this.mType + ", mName='" + this.mName + '\'' + '}';
        }
    }

    private static class MeshSpecificationHolder {
        public static final NativeAllocationRegistry MESH_SPECIFICATION_REGISTRY = NativeAllocationRegistry.createMalloced(MeshSpecification.class.getClassLoader(), MeshSpecification.nativeGetFinalizer());

        private MeshSpecificationHolder() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Type {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface AlphaType {
    }
}

