/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.system.VMRuntime;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import libcore.util.NativeAllocationRegistry;

public class PathIterator
implements Iterator<Segment> {
    private final float[] mPointsArray;
    private final long mPointsAddress;
    private int mCachedVerb = -1;
    private boolean mDone = false;
    private final long mNativeIterator;
    private final Path mPath;
    private final int mPathGenerationId;
    private static final int POINT_ARRAY_SIZE = 8;
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(PathIterator.class.getClassLoader(), PathIterator.nGetFinalizer());
    public static final int VERB_MOVE = 0;
    public static final int VERB_LINE = 1;
    public static final int VERB_QUAD = 2;
    public static final int VERB_CONIC = 3;
    public static final int VERB_CUBIC = 4;
    public static final int VERB_CLOSE = 5;
    public static final int VERB_DONE = 6;

    PathIterator(Path path) {
        this.mPath = path;
        this.mNativeIterator = PathIterator.nCreate(this.mPath.mNativePath);
        this.mPathGenerationId = this.mPath.getGenerationId();
        VMRuntime runtime = VMRuntime.getRuntime();
        this.mPointsArray = (float[])runtime.newNonMovableArray(Float.TYPE, 8);
        this.mPointsAddress = runtime.addressOf(this.mPointsArray);
        sRegistry.registerNativeAllocation(this, this.mNativeIterator);
    }

    public int next(float[] points, int offset) {
        if (points.length < offset + 8) {
            throw new ArrayIndexOutOfBoundsException("points array must be able to hold at least 8 entries");
        }
        int returnVerb = this.getReturnVerb(this.mCachedVerb);
        this.mCachedVerb = -1;
        System.arraycopy(this.mPointsArray, 0, points, offset, 8);
        return returnVerb;
    }

    @Override
    public boolean hasNext() {
        if (this.mCachedVerb == -1) {
            this.mCachedVerb = this.nextInternal();
        }
        return this.mCachedVerb != 6;
    }

    public int peek() {
        if (this.mPathGenerationId != this.mPath.getGenerationId()) {
            throw new ConcurrentModificationException("Iterator cannot be used on modified Path");
        }
        if (this.mDone) {
            return 6;
        }
        return PathIterator.nPeek(this.mNativeIterator);
    }

    private int nextInternal() {
        if (this.mDone) {
            return 6;
        }
        if (this.mPathGenerationId != this.mPath.getGenerationId()) {
            throw new ConcurrentModificationException("Iterator cannot be used on modified Path");
        }
        int verb = PathIterator.nNext(this.mNativeIterator, this.mPointsAddress);
        if (verb == 6) {
            this.mDone = true;
        }
        return verb;
    }

    @Override
    public Segment next() {
        int returnVerb = this.getReturnVerb(this.mCachedVerb);
        this.mCachedVerb = -1;
        float conicWeight = 0.0f;
        if (returnVerb == 3) {
            conicWeight = this.mPointsArray[6];
        }
        float[] returnPoints = new float[8];
        System.arraycopy(this.mPointsArray, 0, returnPoints, 0, 8);
        return new Segment(returnVerb, returnPoints, conicWeight);
    }

    private int getReturnVerb(int cachedVerb) {
        switch (cachedVerb) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        return this.nextInternal();
    }

    private static long nCreate(long l) {
        return OverrideMethod.invokeL("android.graphics.PathIterator#nCreate(J)J", true, null);
    }

    private static long nGetFinalizer() {
        return OverrideMethod.invokeL("android.graphics.PathIterator#nGetFinalizer()J", true, null);
    }

    @CriticalNative
    private static int nNext(long l, long l2) {
        return OverrideMethod.invokeI("android.graphics.PathIterator#nNext(JJ)I", true, null);
    }

    @CriticalNative
    private static int nPeek(long l) {
        return OverrideMethod.invokeI("android.graphics.PathIterator#nPeek(J)I", true, null);
    }

    public static class Segment {
        private final int mVerb;
        private final float[] mPoints;
        private final float mConicWeight;

        public int getVerb() {
            return this.mVerb;
        }

        public float[] getPoints() {
            return this.mPoints;
        }

        public float getConicWeight() {
            return this.mConicWeight;
        }

        Segment(int verb, float[] points, float conicWeight) {
            this.mVerb = verb;
            this.mPoints = points;
            this.mConicWeight = conicWeight;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Verb {
    }
}

